/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.migration;

import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.io.IOCloser;
import com.ericsson.ere.migration.MigrationContext;
import com.ericsson.ere.migration.MigrationDocumentBuilder;
import com.ericsson.ere.migration.MigrationException;
import com.ericsson.ere.migration.MigrationManager;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MigrationManagerImpl
implements MigrationManager {
    static final String ATTR_NAME = "Name";
    static final String ATTR_TYPE = "Type";
    static final String TAG_SERVICE_LIST = "ServiceList";
    static final String TAG_SERVICE_PROVIDER_LIST = "ServiceProviderList";
    static final String TAG_SERVICE_PROVIDER = "ServiceProvider";
    static final String TAG_SERVICE = "Service";
    static final String TAG_RATING_PERIOD = "RatingPeriod";
    static final String TAG_RATING_PLAN = "RatingPlan";
    static final String TAG_RATING_MANAGER = "RatingManager";
    static final String TAG_SERVICE_DEF = "ServiceDefinition";
    static final String TAG_TARIFF_STRUCTURE = "TariffStructure";
    static final String TAG_ERE_EXPORT = "EreExport";

    @Override
    public boolean isFileValid(File file) throws IOException, IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        boolean isValid = false;
        try {
            if (!this.containsRootTag(XMLUtil.buildDocumentFromFile(file), TAG_ERE_EXPORT)) {
                return false;
            }
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(this.getClass().getResourceAsStream("/config/ere-schema.xsd")));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(file.getAbsoluteFile()));
            isValid = true;
        }
        catch (SAXException ex) {
            RmaDefs.loggerRatingManager.info("Import file does not seem to be valid regarding our schema, exception message =\n " + ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            ExceptionUtil.handleException(ex, "navigator", 2, "Import file is invalid", false);
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File migrateFile(File file, MigrationContext ctx) throws MigrationException, IOException {
        File file2;
        File resultFile = null;
        OutputStreamWriter writer = null;
        Document originalDoc = null;
        try {
            originalDoc = XMLUtil.buildDocumentFromFile(file);
            Document resultDoc = this.createMigratedDoc(originalDoc, ctx);
            resultFile = File.createTempFile("migratedFile", ".xml");
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFile), "UTF-8");
            try {
                DomWriter.elementToStream(resultDoc.getDocumentElement(), writer);
            }
            finally {
                ((Writer)writer).close();
            }
            resultFile.deleteOnExit();
            file2 = resultFile;
        }
        catch (ParserConfigurationException ex) {
            try {
                throw this.exceptionForCorruptXML(ex);
                catch (SAXException ex2) {
                    throw this.exceptionForCorruptXML(ex2);
                }
            }
            catch (Throwable throwable) {
                IOCloser.closeIgnoringException(writer);
                throw throwable;
            }
        }
        IOCloser.closeIgnoringException(writer);
        return file2;
    }

    private MigrationException exceptionForCorruptXML(Exception ex) {
        return new MigrationException("Failed to migrate file due to corrupt or incorrect XML. No resulting file created.", ex);
    }

    private Document createMigratedDoc(Document originalDoc, MigrationContext ctx) throws MigrationException {
        Element orgRootElement = originalDoc.getDocumentElement();
        String nodeName = orgRootElement.getNodeName();
        Document resultDoc = null;
        MigrationDocumentBuilder docBuilder = new MigrationDocumentBuilder();
        if (TAG_TARIFF_STRUCTURE.equalsIgnoreCase(nodeName)) {
            resultDoc = docBuilder.buildDocumentFromTariffStructure(originalDoc, ctx);
        } else if (TAG_SERVICE_DEF.equalsIgnoreCase(nodeName)) {
            resultDoc = docBuilder.buildDocumentFromServiceDefinition(originalDoc, ctx);
        } else if (TAG_ERE_EXPORT.equalsIgnoreCase(nodeName)) {
            if (ImportUtil.containsFloatingServiceElement(originalDoc)) {
                resultDoc = docBuilder.buildDocumentFromFloatingServiceElement(originalDoc);
            } else {
                NodeListIterable children = new NodeListIterable(orgRootElement.getChildNodes(), 1);
                String elementChildName = children.iterator().next().getNodeName();
                if (TAG_RATING_PLAN.equalsIgnoreCase(elementChildName)) {
                    resultDoc = docBuilder.buildDocumentFromRatingPlan(originalDoc, ctx);
                } else if (TAG_SERVICE_PROVIDER.equalsIgnoreCase(elementChildName)) {
                    resultDoc = docBuilder.buildDocumentFromServiceProvider(originalDoc);
                } else if (TAG_RATING_PERIOD.equalsIgnoreCase(elementChildName)) {
                    resultDoc = docBuilder.buildDocumentFromRatingPeriod(originalDoc, ctx);
                } else if (TAG_RATING_MANAGER.equalsIgnoreCase(elementChildName)) {
                    resultDoc = docBuilder.buildDocumentFromRatingManager(originalDoc);
                } else if (TAG_SERVICE.equalsIgnoreCase(elementChildName)) {
                    resultDoc = docBuilder.buildDocumentFromService(originalDoc);
                } else if (TAG_SERVICE_LIST.equalsIgnoreCase(elementChildName) && XMLUtil.containsElementNamed(orgRootElement, TAG_RATING_PLAN)) {
                    resultDoc = docBuilder.buildDocumentFromRatingPlan(originalDoc, ctx);
                } else if (TAG_SERVICE_LIST.equalsIgnoreCase(elementChildName) && XMLUtil.containsElementNamed(orgRootElement, TAG_RATING_PERIOD)) {
                    resultDoc = docBuilder.buildDocumentFromRatingPeriod(originalDoc, ctx);
                }
            }
        } else {
            throw new MigrationException("Failed to migrate file. It seems to contain incorrect XML");
        }
        return resultDoc;
    }

    private boolean containsRootTag(Document doc, String tag) {
        Element root = doc.getDocumentElement();
        return tag.equalsIgnoreCase(root.getNodeName());
    }
}

