/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.math;

import com.ericsson.ere.math.BaseRationalNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RationalNumber
extends Number
implements Comparable<Object> {
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    public static final double EPSILON = 1.0E-15;
    private long myNumerator;
    private long myDenominator;
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);

    public RationalNumber(RationalNumber number) {
        this.myNumerator = number.myNumerator;
        this.myDenominator = number.myDenominator;
    }

    public RationalNumber(long numerator, long denominator) {
        if (denominator < 0L) {
            throw new ArithmeticException("Negative denominator not allowed");
        }
        this.myNumerator = numerator;
        this.myDenominator = denominator;
    }

    public RationalNumber(String number) {
        number = BaseRationalNumber.removeZeros(number);
        if (number.length() < 20) {
            this.constructFromSmallString(number);
        } else {
            this.constructFromLargeString(number, -1, false);
        }
    }

    private void constructFromSmallString(String number) {
        String fraction = "";
        String whole = "";
        int comma = number.indexOf(46);
        if (comma >= 0) {
            fraction = number.substring(comma + 1);
            whole = number.substring(0, comma);
        } else {
            whole = number;
        }
        this.myDenominator = 1L;
        long len = fraction.length();
        for (long i = 0L; i < len; ++i) {
            this.myDenominator *= 10L;
        }
        this.myNumerator = Long.parseLong(whole + fraction);
        this.simplify();
    }

    private void constructFromLargeString(String number, int scale, boolean checkOverflow) {
        BigDecimal intPart;
        BigInteger gcd;
        BigDecimal bignum = new BigDecimal(number);
        BigInteger bigintNumerator = null;
        BigInteger bigintDenominator = null;
        if (scale != -1) {
            bignum = bignum.setScale(scale, 3);
        }
        if ((scale = bignum.scale()) < 0) {
            throw new ArithmeticException("Overflow when constructing number: " + number);
        }
        if (scale == 0) {
            bigintNumerator = bignum.toBigIntegerExact();
            bigintDenominator = BigInteger.ONE;
        } else if (scale > 0 && (gcd = (bigintNumerator = (intPart = bignum.scaleByPowerOfTen(scale)).toBigIntegerExact()).gcd(bigintDenominator = BigInteger.TEN.pow(scale))).compareTo(BigInteger.ONE) > 0) {
            bigintNumerator = bigintNumerator.divide(gcd);
            bigintDenominator = bigintDenominator.divide(gcd);
        }
        if (bigintNumerator.compareTo(LONG_MAX) < 0 && bigintNumerator.compareTo(LONG_MIN) > 0 && bigintDenominator.compareTo(LONG_MAX) < 0 && bigintDenominator.compareTo(LONG_MIN) > 0) {
            this.myNumerator = bigintNumerator.longValue();
            this.myDenominator = bigintDenominator.longValue();
        } else {
            if (scale == -1 || !checkOverflow) {
                throw new ArithmeticException("Overflow when constructing number: " + number);
            }
            this.checkMaxValue(bigintNumerator, bigintDenominator, scale);
            this.checkMaxValue(bigintDenominator, bigintNumerator, scale);
        }
    }

    private void checkMaxValue(BigInteger lvalue, BigInteger rvalue, int scale) {
        if (lvalue.compareTo(LONG_MIN) < 0) {
            if (rvalue.compareTo(BigInteger.ZERO) > 0) {
                this.myNumerator = LONG_MIN.longValue();
                this.myDenominator = scale;
            } else {
                this.myNumerator = LONG_MAX.longValue();
                this.myDenominator = scale;
            }
        } else if (lvalue.compareTo(LONG_MAX) > 0) {
            if (rvalue.compareTo(BigInteger.ZERO) < 0) {
                this.myNumerator = LONG_MIN.longValue();
                this.myDenominator = scale;
            } else {
                this.myNumerator = LONG_MAX.longValue();
                this.myDenominator = scale;
            }
        }
    }

    public RationalNumber add(RationalNumber number) {
        boolean simplified = false;
        boolean overflow = false;
        long origOrigD = this.myDenominator;
        long origOrigN = this.myNumerator;
        long origOtherD = number.myDenominator;
        long origOtherN = number.myNumerator;
        if (origOtherN == 0L) {
            return this;
        }
        while (true) {
            long origD = this.myDenominator;
            long origN = this.myNumerator;
            long d = number.myDenominator;
            long n = number.myNumerator;
            if (this.myNumerator == 0L) {
                this.myDenominator = d;
            }
            if (d != this.myDenominator) {
                long scale;
                if (d % this.myDenominator == 0L) {
                    scale = d / this.myDenominator;
                    this.myDenominator *= scale;
                    this.myNumerator *= scale;
                } else if (this.myDenominator % d == 0L) {
                    scale = this.myDenominator / d;
                    d *= scale;
                    n *= scale;
                } else {
                    this.myNumerator *= d;
                    if (this.myNumerator / origN != d) {
                        overflow = true;
                    }
                    if ((n *= this.myDenominator) / number.myNumerator != d) {
                        overflow = true;
                    }
                    this.myDenominator *= d;
                }
            }
            this.myNumerator += n;
            if (this.myDenominator < origD || this.myDenominator < number.myDenominator) {
                overflow = true;
            }
            if (origN < 0L && number.myNumerator < 0L) {
                if (this.myNumerator > 0L) {
                    overflow = true;
                }
            } else if (origN > 0L && number.myNumerator > 0L && this.myNumerator < 0L) {
                overflow = true;
            }
            if (!overflow) break;
            if (simplified) {
                long[] res = this.addBigIntegers(origOrigN, origOrigD, origOtherN, origOtherD);
                this.myNumerator = res[0];
                this.myDenominator = res[1];
                break;
            }
            simplified = true;
            this.myDenominator = origD;
            this.myNumerator = origN;
            this.simplify();
            number.simplify();
        }
        return this;
    }

    public RationalNumber add(long number) {
        return this.add(new RationalNumber(number, 1L));
    }

    private long[] addBigIntegers(long p1, long q1, long p2, long q2) throws ArithmeticException {
        BigInteger P1 = BigInteger.valueOf(p1);
        BigInteger Q1 = BigInteger.valueOf(q1);
        BigInteger P2 = BigInteger.valueOf(p2);
        BigInteger Q2 = BigInteger.valueOf(q2);
        BigInteger P1Q2 = P1.multiply(Q2);
        BigInteger P2Q1 = P2.multiply(Q1);
        BigInteger numerator = P1Q2.add(P2Q1);
        BigInteger denominator = Q1.multiply(Q2);
        BigInteger gcd = numerator.gcd(denominator);
        numerator = numerator.divide(gcd);
        denominator = denominator.divide(gcd);
        if (numerator.compareTo(LONG_MAX) > 0 || denominator.compareTo(LONG_MAX) > 0) {
            throw new ArithmeticException("Overflow when adding (" + p1 + "/" + q1 + ") + (" + p2 + "/" + q2 + ")");
        }
        if (numerator.compareTo(LONG_MIN) < 0 || denominator.compareTo(LONG_MIN) < 0) {
            throw new ArithmeticException("Neg. Overflow when adding (" + p1 + "/" + q1 + ") + (" + p2 + "/" + q2 + ")");
        }
        long[] res = new long[]{numerator.longValue(), denominator.longValue()};
        return res;
    }

    public RationalNumber subtract(RationalNumber number) {
        boolean simplified = false;
        boolean overflow = false;
        long origOrigD = this.myDenominator;
        long origOrigN = this.myNumerator;
        long origOtherD = number.myDenominator;
        long origOtherN = number.myNumerator;
        if (origOtherN == 0L) {
            return this;
        }
        while (true) {
            long origD = this.myDenominator;
            long origN = this.myNumerator;
            long d = number.myDenominator;
            long n = number.myNumerator;
            if (d != this.myDenominator) {
                long scale;
                if (this.myNumerator == 0L) {
                    this.myDenominator = number.myDenominator;
                } else if (d % this.myDenominator == 0L) {
                    scale = d / this.myDenominator;
                    this.myDenominator *= scale;
                    this.myNumerator *= scale;
                } else if (this.myDenominator % d == 0L) {
                    scale = this.myDenominator / d;
                    d *= scale;
                    n *= scale;
                } else {
                    this.myNumerator *= d;
                    if (this.myNumerator / origN != d) {
                        overflow = true;
                    }
                    if ((n *= this.myDenominator) / number.myNumerator != this.myDenominator) {
                        overflow = true;
                    }
                    this.myDenominator *= d;
                }
            }
            this.myNumerator -= n;
            if (this.myDenominator < origD || this.myDenominator < number.myDenominator) {
                overflow = true;
            }
            if (origN < 0L && number.myNumerator > 0L) {
                if (this.myNumerator > 0L) {
                    overflow = true;
                }
            } else if (origN > 0L && number.myNumerator < 0L && this.myNumerator < 0L) {
                overflow = true;
            }
            if (!overflow) break;
            if (simplified) {
                long[] res = this.addBigIntegers(origOrigN, origOrigD, -1L * origOtherN, origOtherD);
                this.myNumerator = res[0];
                this.myDenominator = res[1];
                break;
            }
            simplified = true;
            this.myDenominator = origD;
            this.myNumerator = origN;
            this.simplify();
            number.simplify();
        }
        return this;
    }

    public RationalNumber subtract(long number) {
        return this.subtract(new RationalNumber(number, 1L));
    }

    public RationalNumber multiply(RationalNumber number) {
        boolean simplified = false;
        while (true) {
            long origD = this.myDenominator;
            long origN = this.myNumerator;
            long d = number.myDenominator;
            long n = number.myNumerator;
            if (origD <= 0L || d <= 0L) {
                throw new IllegalArgumentException("Zero (or negative) denominator is not allowed");
            }
            if (origN == 0L || n == 0L) {
                this.myDenominator = 1L;
                this.myNumerator = 0L;
                return this;
            }
            this.myDenominator *= d;
            this.myNumerator *= n;
            boolean overflow = false;
            if (this.myDenominator / origD != d) {
                overflow = true;
            }
            if (this.myNumerator / origN != n) {
                overflow = true;
            }
            if (!overflow) break;
            if (simplified) {
                throw new ArithmeticException("Overflow when multiplying.");
            }
            simplified = true;
            this.myDenominator = origD;
            this.myNumerator = origN;
            this.simplify();
            number.simplify();
        }
        return this;
    }

    public RationalNumber multiply(long number) {
        return this.multiply(new RationalNumber(number, 1L));
    }

    public RationalNumber divide(RationalNumber number) {
        boolean simplified = false;
        while (true) {
            long origD = this.myDenominator;
            long origN = this.myNumerator;
            long d = number.myDenominator;
            long n = number.myNumerator;
            if (origD <= 0L || d <= 0L) {
                throw new IllegalArgumentException("Zero (or negative) denominator is not allowed");
            }
            if (n == 0L) {
                throw new ArithmeticException("Divide by zero");
            }
            if (origN == 0L) {
                this.myDenominator = 1L;
                this.myNumerator = 0L;
                return this;
            }
            this.myDenominator *= n;
            this.myNumerator *= d;
            boolean overflow = false;
            if (this.myDenominator / origD != n) {
                overflow = true;
            }
            if (this.myNumerator / origN != d) {
                overflow = true;
            }
            if (n < 0L) {
                this.myNumerator = -this.myNumerator;
            }
            if (this.myDenominator < 0L) {
                this.myDenominator = -this.myDenominator;
            }
            if (!overflow) break;
            if (simplified) {
                this.myDenominator = origD;
                this.myNumerator = origN;
                RationalNumber number1 = new RationalNumber(number.myDenominator, origD);
                RationalNumber number2 = new RationalNumber(origN, number.myNumerator);
                try {
                    number1.multiply(number2);
                    this.myNumerator = number1.myNumerator;
                    this.myDenominator = number1.myDenominator;
                    return this;
                }
                catch (ArithmeticException e) {
                    throw new ArithmeticException("Overflow when dividing.");
                }
            }
            simplified = true;
            this.myDenominator = origD;
            this.myNumerator = origN;
            this.simplify();
            number.simplify();
        }
        return this;
    }

    public RationalNumber divide(long number) {
        return this.divide(new RationalNumber(number, 1L));
    }

    @Override
    public int compareTo(Object o) {
        Class<?> c = o.getClass();
        if (c == RationalNumber.class) {
            return this.compareTo((RationalNumber)o);
        }
        if (c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == AtomicInteger.class || c == AtomicLong.class) {
            return this.compareTo(((Number)o).longValue());
        }
        if (c == Double.class || c == Float.class) {
            double other;
            double me = this.doubleValue();
            if (Math.abs(me - (other = ((Number)o).doubleValue())) < 1.0E-15) {
                return 0;
            }
            return me > other ? 1 : -1;
        }
        throw new ClassCastException("Can only compare to " + RationalNumber.class);
    }

    @Override
    public int compareTo(long o) {
        return this.compareTo(new RationalNumber(o, 1L));
    }

    @Override
    public int compareTo(RationalNumber o) {
        double other;
        double own = this.doubleValue();
        if (own == (other = o.doubleValue())) {
            return 0;
        }
        if (own > other) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        this.simplify();
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.myDenominator ^ this.myDenominator >>> 32);
        result = 31 * result + (int)(this.myNumerator ^ this.myNumerator >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((RationalNumber)obj);
    }

    public boolean equals(RationalNumber other) {
        this.simplify();
        other.simplify();
        return this.myNumerator == other.myNumerator && this.myDenominator == other.myDenominator;
    }

    public boolean equals(long o) {
        this.simplify();
        return this.myDenominator == 1L && this.myNumerator == o;
    }

    private void simplify() {
        long gcd = Math.abs(this.euclid(this.myNumerator, this.myDenominator));
        this.myNumerator /= gcd;
        this.myDenominator /= gcd;
    }

    private long euclid(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return this.euclid(b, a % b);
    }

    @Override
    public double doubleValue() {
        return (double)this.myNumerator / (double)this.myDenominator;
    }

    @Override
    public float floatValue() {
        return (float)this.myNumerator / (float)this.myDenominator;
    }

    @Override
    public int intValue() {
        return (int)(this.myNumerator / this.myDenominator);
    }

    @Override
    public long longValue() {
        return this.myNumerator / this.myDenominator;
    }

    public BigDecimal bigDecimalValue(int scale, int roundingMode) {
        BigDecimal numer = new BigDecimal(this.myNumerator);
        BigDecimal denom = new BigDecimal(this.myDenominator);
        return numer.divide(denom, scale, roundingMode);
    }

    public String toString() {
        return this.doubleValue() + "";
    }

    public String toDotString(int scale, int roundingMode) {
        BigDecimal numer = new BigDecimal(this.myNumerator);
        BigDecimal denom = new BigDecimal(this.myDenominator);
        BigDecimal result = numer.divide(denom, scale, roundingMode);
        return result.toPlainString();
    }

    public static RationalNumber valueOf(String s) {
        return new RationalNumber(s);
    }

    public static RationalNumber valueOf(String s, int scale, boolean checkOverflow) {
        RationalNumber n = new RationalNumber(0L, 1L);
        s = BaseRationalNumber.removeZeros(s);
        n.constructFromLargeString(s, scale, checkOverflow);
        return n;
    }

    public RationalNumber negate() {
        if (this.myNumerator == 0L) {
            this.myDenominator = 1L;
        } else {
            this.myNumerator *= -1L;
        }
        return this;
    }

    public RationalNumber remainder(RationalNumber divisor) {
        if (divisor.myNumerator == 0L) {
            throw new ArithmeticException("Zero divisor");
        }
        if (divisor.myNumerator < 0L) {
            throw new ArithmeticException("Negative divisor");
        }
        RationalNumber number = new RationalNumber(this);
        RationalNumber divisorCopy = new RationalNumber(divisor);
        number.subtract(divisorCopy.multiply(this.divideToIntegralValue(divisorCopy)));
        this.myNumerator = number.myNumerator;
        this.myDenominator = number.myDenominator;
        return this;
    }

    private RationalNumber divideToIntegralValue(RationalNumber number) {
        RationalNumber divRes = this.divide(number);
        return new RationalNumber(divRes.longValue(), 1L);
    }

    public RationalNumber abs() {
        assert (this.myDenominator > 0L);
        if (this.myNumerator < 0L) {
            return new RationalNumber(this).multiply(-1L);
        }
        return new RationalNumber(this);
    }

    public RationalNumber round(int precision, int roundingMode) {
        String s = this.toDotString(precision, roundingMode);
        return new RationalNumber(s);
    }

    public long getDenominator() {
        return this.myDenominator;
    }

    public long getNumerator() {
        return this.myNumerator;
    }
}

