/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.math;

import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.datatype.UnsignedLong;
import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;

public final class RatingDecimalUtil {
    private static final RatingDecimal RD_LONG_MAX = new RatingDecimal(Long.MAX_VALUE, 1L);
    private static final RatingDecimal RD_LONG_MIN = new RatingDecimal(Long.MIN_VALUE, 1L);
    private static final RatingDecimal ULONG_MAX_PLUS_ONE = new RatingDecimal("18446744073709551616");

    private RatingDecimalUtil() {
    }

    public static Object convertRatingDecimalToValueOfDataType(DataType dataType, RatingDecimal value) {
        Serializable ret;
        if (!dataType.isNumeric()) {
            throw new IllegalArgumentException("Non-numeric data type: " + dataType);
        }
        switch (dataType) {
            case RATINGDECIMAL: {
                ret = value;
                break;
            }
            case DECIMAL: {
                ret = new Decimal(RatingDecimalUtil.toString(value));
                break;
            }
            case DOUBLE: {
                ret = Double.valueOf(value.doubleValue());
                break;
            }
            case UNSIGNEDLONG: 
            case LONG: {
                ret = Long.valueOf(value.longValue());
                break;
            }
            case UNSIGNEDINT32: {
                ret = new UnsignedInt32(value.longValue());
                break;
            }
            case UNSIGNEDINT: 
            case INTEGER: {
                ret = Integer.valueOf(value.intValue());
                break;
            }
            case UNSIGNEDINT16: {
                ret = new UnsignedInt16(value.intValue());
                break;
            }
            case UNSIGNEDSHORT: 
            case SHORT: {
                ret = Short.valueOf(value.shortValue());
                break;
            }
            case UNSIGNEDINT8: {
                ret = new UnsignedInt8(value.shortValue());
                break;
            }
            default: {
                throw new AssertionError((Object)("Data type not handled: " + dataType));
            }
        }
        return ret;
    }

    public static RatingDecimal createRatingDecimalFromNumericValue(Object value) {
        RatingDecimal rd;
        if (value == null) {
            rd = null;
        } else if (value instanceof RatingDecimal) {
            rd = (RatingDecimal)value;
        } else if (value instanceof Double) {
            rd = new RatingDecimal((Double)value);
        } else if (value instanceof BigInteger) {
            rd = new RatingDecimal(((BigInteger)value).toString());
        } else if (value instanceof Float) {
            rd = new RatingDecimal(((Float)value).floatValue());
        } else if (value instanceof UnsignedLong) {
            rd = new RatingDecimal(((UnsignedLong)value).longValue(), 1L);
            if (rd.isLessThanZero()) {
                rd = rd.add(ULONG_MAX_PLUS_ONE);
            }
        } else {
            rd = value instanceof Decimal ? ((Decimal)value).getRatingDecimal() : (value instanceof Number ? new RatingDecimal(((Number)value).longValue(), 1L) : new RatingDecimal(String.valueOf(value)));
        }
        return rd;
    }

    public static BigInteger toBigInteger(RatingDecimal rd) {
        return rd.bigDecimalValue(MathContext.DECIMAL128).toBigInteger();
    }

    public static String toString(RatingDecimal rd) {
        if (rd.isWholeNumber()) {
            return rd.toDotString(0, 3);
        }
        return String.valueOf(rd);
    }

    public static boolean isWithinLongRange(RatingDecimal rd) {
        return rd.compareTo(RD_LONG_MIN) >= 0 && rd.compareTo(RD_LONG_MAX) <= 0;
    }
}

