/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.math;

import com.ericsson.ere.math.BigRationalNumber;
import com.ericsson.ere.math.LongRationalNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public abstract class BaseRationalNumber
extends Number
implements Comparable<BaseRationalNumber> {
    static final int LONG_BASED = 1;
    static final int BIGINTEGER_BASED = 2;
    private static final char PLUS_CHAR = '+';
    private static final char MINUS_CHAR = '-';
    private static final char DOT_CHAR = '.';
    public static final double EPSILON = 1.0E-15;
    protected int myBase;
    protected static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);

    public static BaseRationalNumber valueOf(long numerator, long denominator) {
        return new LongRationalNumber(numerator, denominator);
    }

    public static BaseRationalNumber valueOf(long numerator) {
        return new LongRationalNumber(numerator, 1L);
    }

    public static BaseRationalNumber valueOf(BaseRationalNumber value) {
        return new LongRationalNumber((LongRationalNumber)value);
    }

    public static BaseRationalNumber valueOf(String number) {
        BaseRationalNumber.throwIfInvalidFormat(number);
        number = BaseRationalNumber.removeZeros(number);
        if (number.length() < 20) {
            return BaseRationalNumber.constructFromSmallString(number);
        }
        return BaseRationalNumber.constructFromLargeString(number, -1);
    }

    public static BaseRationalNumber valueOf(String number, int scale) {
        BaseRationalNumber.throwIfInvalidFormat(number);
        number = BaseRationalNumber.removeZeros(number);
        return BaseRationalNumber.constructFromLargeString(number, scale);
    }

    public static BaseRationalNumber valueof(byte[] data) {
        if (data[0] == 1) {
            return new LongRationalNumber(data);
        }
        if (data[0] == 2) {
            return new BigRationalNumber(data);
        }
        throw new ArithmeticException("Can not create RatingDecimal from byte array");
    }

    public abstract BaseRationalNumber add(BaseRationalNumber var1);

    public abstract BaseRationalNumber add(long var1);

    public abstract BaseRationalNumber subtract(BaseRationalNumber var1);

    public abstract BaseRationalNumber subtract(long var1);

    public abstract BaseRationalNumber multiply(BaseRationalNumber var1);

    public abstract BaseRationalNumber multiply(long var1);

    public abstract BaseRationalNumber divide(BaseRationalNumber var1);

    public abstract BaseRationalNumber divide(long var1);

    public abstract BigDecimal bigDecimalValue(int var1, int var2);

    public abstract BigDecimal toBigDecimal(MathContext var1);

    public abstract boolean isZero();

    public abstract byte[] toByteArray();

    public abstract String toDotString(int var1, int var2);

    public abstract BaseRationalNumber negate();

    public abstract BaseRationalNumber remainder(BaseRationalNumber var1);

    public abstract BaseRationalNumber abs();

    public abstract boolean isWholeNumber();

    public BaseRationalNumber round(int precision, int roundingMode) {
        String s = this.toDotString(precision, roundingMode);
        return BaseRationalNumber.valueOf(s);
    }

    private static BaseRationalNumber constructFromSmallString(String number) {
        String fraction = "";
        String whole = "";
        int comma = number.indexOf(46);
        if (comma >= 0) {
            fraction = number.substring(comma + 1);
            whole = number.substring(0, comma);
        } else {
            whole = number;
        }
        long denominator = 1L;
        long len = fraction.length();
        for (long i = 0L; i < len; ++i) {
            denominator *= 10L;
        }
        long numerator = 0L;
        try {
            numerator = Long.parseLong(whole + fraction);
        }
        catch (NumberFormatException e) {
            return BaseRationalNumber.constructFromLargeString(number, -1);
        }
        LongRationalNumber rationalNumber = new LongRationalNumber(numerator, denominator);
        rationalNumber.normalize();
        return rationalNumber;
    }

    private static BaseRationalNumber constructFromLargeString(String number, int scale) {
        BigInteger gcd;
        BigDecimal intPart;
        BigDecimal bignum = new BigDecimal(number);
        BigInteger bigintNumerator = null;
        BigInteger bigintDenominator = null;
        if (scale != -1) {
            bignum = bignum.setScale(scale, 3);
        }
        if ((scale = bignum.scale()) < 0) {
            intPart = bignum.scaleByPowerOfTen(scale);
            bigintNumerator = intPart.toBigIntegerExact().multiply(BigInteger.TEN.pow(-scale));
            BigInteger gcd2 = bigintNumerator.gcd(bigintDenominator = BigInteger.ONE);
            if (gcd2.compareTo(BigInteger.ONE) > 0) {
                bigintNumerator = bigintNumerator.divide(gcd2);
                bigintDenominator = bigintDenominator.divide(gcd2);
            }
        } else if (scale == 0) {
            bigintNumerator = bignum.toBigIntegerExact();
            bigintDenominator = BigInteger.ONE;
        } else if (scale > 0 && (gcd = (bigintNumerator = (intPart = bignum.scaleByPowerOfTen(scale)).toBigIntegerExact()).gcd(bigintDenominator = BigInteger.TEN.pow(scale))).compareTo(BigInteger.ONE) > 0) {
            bigintNumerator = bigintNumerator.divide(gcd);
            bigintDenominator = bigintDenominator.divide(gcd);
        }
        if (BaseRationalNumber.isWithinLongRange(bigintNumerator) && BaseRationalNumber.isWithinLongRange(bigintDenominator)) {
            long numerator = bigintNumerator.longValue();
            long denominator = bigintDenominator.longValue();
            LongRationalNumber rationalNumber = new LongRationalNumber(numerator, denominator);
            rationalNumber.normalize();
            return rationalNumber;
        }
        BigRationalNumber rationalNumber = new BigRationalNumber(bigintNumerator, bigintDenominator);
        return rationalNumber.simplify();
    }

    protected static boolean isWithinLongRange(BigInteger num) {
        return num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0;
    }

    private static void throwIfInvalidFormat(String number) {
        char firstChar;
        if (number.length() > 0 && !Character.isDigit(firstChar = number.charAt(0)) && firstChar != '+' && firstChar != '-' && firstChar != '.') {
            throw new NumberFormatException("Number strings must start with digit or ./+/-");
        }
    }

    protected static String removeZeros(String n) {
        String candidate;
        int i;
        boolean containsDot = n.indexOf(46) >= 0;
        boolean containsExp = false;
        int indexOfExp = 0;
        int len = n.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = n.charAt(i2);
            if (c != 'E' && c != 'e') continue;
            indexOfExp = i2;
            containsExp = true;
            break;
        }
        int head = 0;
        int tail = containsExp ? indexOfExp - 1 : n.length() - 1;
        for (i = 0; i <= tail && '0' == n.charAt(i); ++i) {
            head = i + 1;
        }
        if (containsDot) {
            for (i = tail; i >= 0 && '0' == n.charAt(i); --i) {
                tail = i - 1;
            }
        }
        if (head >= n.length() || tail < 0) {
            candidate = "0";
        } else {
            candidate = n.substring(head, tail + 1);
            if (".".equals(candidate)) {
                candidate = "0";
            }
            if (containsExp) {
                candidate = candidate + n.substring(indexOfExp);
            }
        }
        return candidate;
    }
}

