/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CSVUtil {
    public static final char LIST_SEPARATOR_TAB = '\t';

    public static List<String> splitCSVLine(String line, char separator) {
        if (line == null) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        boolean inString = false;
        int tokenStart = line.startsWith("=\"") ? 1 : 0;
        ArrayList<String> vec = new ArrayList<String>();
        int length = line.length();
        if (length == 0) {
            vec.add("");
        }
        for (int i = 0; i < length; ++i) {
            if (!inString) {
                if (line.charAt(i) == '\"') {
                    if (i == tokenStart) {
                        inString = true;
                        continue;
                    }
                    if (length > i + 1 && line.charAt(i + 1) == '\"') {
                        ++i;
                        continue;
                    }
                    if (separator == '\t') continue;
                    throw new IllegalArgumentException("Single quotes can only appear at the ends of a token: " + line);
                }
                if (line.charAt(i) != separator) continue;
                String token = line.substring(tokenStart, i);
                token = CSVUtil.unquote(token);
                vec.add(token);
                tokenStart = i + (line.substring(i + 1).startsWith("=\"") ? 2 : 1);
                continue;
            }
            if (line.charAt(i) != '\"') continue;
            if (length > i + 1 && line.charAt(i + 1) == '\"') {
                ++i;
                continue;
            }
            if (i == length - 1 || line.charAt(i + 1) == separator) {
                inString = false;
                continue;
            }
            throw new IllegalArgumentException("Single quotes can only appear at the ends of a token: " + line);
        }
        if (inString) {
            throw new IllegalArgumentException("Malformed input, quote was never closed: " + line);
        }
        if (tokenStart < line.length()) {
            String token = line.substring(tokenStart);
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = CSVUtil.unquote(token);
            }
            vec.add(token);
        }
        return vec;
    }

    public static String escapeStringForCSV(String toEscape, char separator, boolean forceText) {
        String escaped = new String(toEscape);
        boolean addQuotation = toEscape.contains(Character.toString(separator));
        if (toEscape.contains("\"")) {
            escaped = escaped.replace("\"", "\"\"");
            addQuotation = true;
        }
        if (addQuotation || toEscape.contains("\n") || forceText) {
            escaped = "\"" + escaped + "\"";
            if (forceText && !toEscape.contains("\n")) {
                escaped = "=" + escaped;
            }
        }
        return escaped;
    }

    public static char getSystemSpecificListSeparator() {
        char separator;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            try {
                separator = CSVUtil.fetchLineSeparatorFromRegistry();
            }
            catch (Exception e) {
                separator = CSVUtil.getEducatedGuess();
            }
        } else {
            separator = CSVUtil.getEducatedGuess();
        }
        return separator;
    }

    private static char fetchLineSeparatorFromRegistry() throws IOException {
        String line;
        Process process = Runtime.getRuntime().exec("reg query \"HKCU\\Control Panel\\International\" /v sList");
        BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = processOutput.readLine()) != null) {
            if (!line.contains("sList")) continue;
            return line.charAt(line.length() - 1);
        }
        throw new IllegalArgumentException("reg query result did not contain the expected data.");
    }

    private static char getEducatedGuess() {
        char decimalSeparator;
        Locale locale = Locale.getDefault();
        if (locale == null) {
            locale = Locale.US;
        }
        decimalSeparator = (decimalSeparator = new DecimalFormatSymbols(locale).getDecimalSeparator()) == ',' ? (char)';' : ',';
        return decimalSeparator;
    }

    private static String unquote(String aString) {
        String token = aString;
        if (token.startsWith("\"") && token.endsWith("\"")) {
            token = token.substring(1, token.length() - 1);
            token = token.replaceAll("\"\"", "\"");
        }
        return token;
    }
}

