/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.wizard.selectabletree;

import com.ericsson.ere.exportmanager.NonExportable;
import com.ericsson.ere.gui.navigator.nodeimport.ElementTreeNode;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceNode;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableNodeWrapper;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class SelectableTreeModel
extends DefaultTreeModel {
    public SelectableTreeModel(TreeNode root) {
        super(root);
        this.reload();
    }

    public static SelectableNodeWrapper wrapExportableTree(AbstractNavigatorNode rootNode) {
        if (rootNode instanceof ServiceNode || rootNode instanceof RatingPeriodNode) {
            return new SelectableNodeWrapper(rootNode);
        }
        Enumeration<TreeNode> rootChildren = rootNode.children();
        if (!rootChildren.hasMoreElements()) {
            return null;
        }
        DefaultMutableTreeNode tRoot = null;
        while (rootChildren.hasMoreElements()) {
            SelectableNodeWrapper wrappedExportableTree;
            AbstractNavigatorNode navNode = (AbstractNavigatorNode)rootChildren.nextElement();
            boolean isExportable = !(navNode.getProxy() instanceof NonExportable);
            if (!isExportable || (wrappedExportableTree = SelectableTreeModel.wrapExportableTree(navNode)) == null) continue;
            if (tRoot == null) {
                tRoot = new SelectableNodeWrapper(rootNode);
            }
            tRoot.add(wrappedExportableTree);
        }
        return tRoot;
    }

    public static SelectableNodeWrapper wrapTree(DefaultMutableTreeNode rootNode) {
        SelectableNodeWrapper tRoot = new SelectableNodeWrapper(rootNode);
        Enumeration<TreeNode> e = rootNode.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)e.nextElement();
            tRoot.add(SelectableTreeModel.wrapTree(tNode));
        }
        return tRoot;
    }

    public void markAllForExport(boolean marked) {
        SelectableNodeWrapper rootNode = (SelectableNodeWrapper)this.getRoot();
        rootNode.setMarkedForExport(marked);
        Enumeration<TreeNode> e = rootNode.children();
        while (e.hasMoreElements()) {
            SelectableNodeWrapper nextNode = (SelectableNodeWrapper)e.nextElement();
            nextNode.setMarkedForExport(marked);
            this.recMarkAllForExport(nextNode, marked);
        }
    }

    private void recMarkAllForExport(SelectableNodeWrapper node, boolean mark) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            SelectableNodeWrapper nextNode = (SelectableNodeWrapper)e.nextElement();
            nextNode.setMarkedForExport(mark);
            this.recMarkAllForExport(nextNode, mark);
        }
    }

    public boolean hasExportableSelection() {
        return this.recHasMarkedLeafs((SelectableNodeWrapper)this.getRoot());
    }

    private boolean recHasMarkedLeafs(SelectableNodeWrapper wrapper) {
        boolean result = false;
        if (wrapper.isLeaf() && wrapper.markedForExport) {
            return true;
        }
        Enumeration<TreeNode> e = wrapper.children();
        while (e.hasMoreElements()) {
            SelectableNodeWrapper nextNode = (SelectableNodeWrapper)e.nextElement();
            if (!this.recHasMarkedLeafs(nextNode)) continue;
            result = true;
        }
        return result;
    }

    public Vector<DefaultMutableTreeNode> getAllMarkedForExport() {
        Vector<DefaultMutableTreeNode> result = new Vector<DefaultMutableTreeNode>();
        SelectableNodeWrapper rootNode = (SelectableNodeWrapper)this.getRoot();
        if (rootNode.markedForExport) {
            result.add(rootNode.wrappedNode);
            Enumeration<TreeNode> e = rootNode.children();
            while (e.hasMoreElements()) {
                SelectableNodeWrapper nextNode = (SelectableNodeWrapper)e.nextElement();
                result.addAll(this.recGetAllMarkedForExport(nextNode));
            }
        }
        return result;
    }

    private Vector<DefaultMutableTreeNode> recGetAllMarkedForExport(SelectableNodeWrapper currentNode) {
        Vector<DefaultMutableTreeNode> result = new Vector<DefaultMutableTreeNode>();
        if (currentNode.markedForExport) {
            result.add(currentNode.wrappedNode);
            Enumeration<TreeNode> e = currentNode.children();
            while (e.hasMoreElements()) {
                SelectableNodeWrapper nextNode = (SelectableNodeWrapper)e.nextElement();
                result.addAll(this.recGetAllMarkedForExport(nextNode));
            }
        }
        return result;
    }

    public SelectableNodeWrapper getNode(String nodeName) {
        SelectableNodeWrapper rootNode = (SelectableNodeWrapper)this.getRoot();
        return this.findNode(nodeName, rootNode);
    }

    private SelectableNodeWrapper findNode(String nodeName, SelectableNodeWrapper node) {
        SelectableNodeWrapper returnNode = null;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            SelectableNodeWrapper nextNode = (SelectableNodeWrapper)e.nextElement();
            if (((ElementTreeNode)nextNode.wrappedNode).elementLabel.equals(nodeName)) {
                return nextNode;
            }
            returnNode = this.findNode(nodeName, nextNode);
            if (returnNode == null) continue;
            return returnNode;
        }
        return null;
    }

    public void markNodeForImport(SelectableNodeWrapper n) {
        n.markedForExport = true;
        for (SelectableNodeWrapper parent = (SelectableNodeWrapper)n.getParent(); parent != null; parent = (SelectableNodeWrapper)parent.getParent()) {
            parent.markedForExport = true;
        }
    }
}

