/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.wizard;

import com.ericsson.ere.gui.wizard.WizardDialog;
import com.ericsson.ere.gui.wizard.panels.DefaultWizardPanel;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.xml.EreXmlException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;

public class WizardState
implements Observer {
    private WizardMode myWizardMode = WizardMode.STANDARD;
    public JButton backButton = null;
    public JButton nextButton = null;
    public JButton cancelButton = null;
    public WizardDialog dialog = null;
    public int currentPanel = 0;
    private boolean hasSwitchedPanel = true;
    public Vector<PanelInfo> panels = new Vector();

    public WizardState(WizardDialog dialog, JButton backButton, JButton nextButton, JButton cancelButton) {
        this.dialog = dialog;
        this.backButton = backButton;
        this.nextButton = nextButton;
        this.cancelButton = cancelButton;
        this.cancelButton.setName("WizardState.JButton.cancelAndFinishButton");
        this.registerButtons();
    }

    private void registerButtons() {
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WizardState.this.showNextPanel();
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WizardState.this.showPrevPanel();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WizardState.this.cancelAllPanels();
                if (WizardState.this.cancelButton.getText().equalsIgnoreCase("cancel")) {
                    WizardState.this.dialog.cancel();
                }
                WizardState.this.dialog.dispose();
            }
        });
    }

    private void showNextPanel() {
        for (int nextPanel = this.currentPanel + 1; nextPanel < this.panels.size(); ++nextPanel) {
            if (this.getPanelForNr(nextPanel).skipThisPanel()) {
                continue;
            }
            this.getPanelForNr(this.currentPanel).nextButtonIsPressed();
            this.currentPanel = nextPanel;
            this.hasSwitchedPanel = true;
            this.showCurrentPanel();
            return;
        }
    }

    private void showPrevPanel() {
        for (int prevPanel = this.currentPanel - 1; prevPanel >= 0; --prevPanel) {
            if (this.getPanelForNr(prevPanel).skipThisPanel()) {
                continue;
            }
            this.getPanelForNr(this.currentPanel).nextButtonIsPressed();
            this.currentPanel = prevPanel;
            this.hasSwitchedPanel = true;
            this.showCurrentPanel();
            return;
        }
    }

    private void showCurrentPanel() {
        try {
            CardLayout tLayout = (CardLayout)this.dialog.middlePanel.getLayout();
            DefaultWizardPanel tPanel = this.getPanelForNr(this.currentPanel);
            tLayout.show(this.dialog.middlePanel, tPanel.getPanelIdentifier());
            this.dialog.instructionsArea.setText(tPanel.getPanelDescription());
            if (this.hasSwitchedPanel) {
                tPanel.panelIsVisible();
                this.hasSwitchedPanel = false;
            }
            this.nextButton.setEnabled(tPanel.hasNeededData());
            if (this.currentPanel == 0) {
                this.backButton.setEnabled(false);
            } else {
                this.backButton.setEnabled(true);
            }
            this.cancelButton.setEnabled(true);
        }
        catch (EreXmlException e) {
            DialogFactory.getErrorDialog("Import file error.", "The file you wish to import contains error(s):\nFile is not valid\n" + e.getMessage());
            this.cancelAllPanels();
            this.dialog.dispose();
        }
    }

    public void register(DefaultWizardPanel somePanel) {
        somePanel.addObserver(this);
        this.panels.add(new PanelInfo(somePanel.getPanelIdentifier(), somePanel));
        this.dialog.middlePanel.add((Component)somePanel, somePanel.getPanelIdentifier());
        this.showCurrentPanel();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.showCurrentPanel();
    }

    private DefaultWizardPanel getPanelForNr(int panelNr) {
        return this.panels.get((int)panelNr).value;
    }

    public void disableAllButtons() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardState.this.backButton.setEnabled(false);
                WizardState.this.nextButton.setEnabled(false);
                WizardState.this.cancelButton.setEnabled(false);
            }
        });
    }

    public void setFinishMode() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardState.this.backButton.setEnabled(false);
                WizardState.this.nextButton.setEnabled(false);
                WizardState.this.cancelButton.setEnabled(true);
                WizardState.this.cancelButton.setText("Finish");
            }
        });
        this.myWizardMode = WizardMode.FINISHED;
    }

    public void setStopMode() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardState.this.backButton.setEnabled(false);
                WizardState.this.nextButton.setEnabled(false);
                WizardState.this.cancelButton.setEnabled(true);
                WizardState.this.cancelButton.setText("Stop");
            }
        });
        this.myWizardMode = WizardMode.STOP;
    }

    public void setStandardMode() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardState.this.backButton.setEnabled(false);
                WizardState.this.nextButton.setEnabled(false);
                WizardState.this.cancelButton.setEnabled(true);
                WizardState.this.cancelButton.setText("Cancel");
            }
        });
        this.myWizardMode = WizardMode.STOP;
    }

    public boolean isFinishedMode() {
        return this.myWizardMode == WizardMode.FINISHED;
    }

    public void cancelAllPanels() {
        for (PanelInfo panel : this.panels) {
            panel.value.wizardCanceled();
        }
    }

    private class PanelInfo {
        public String key;
        public DefaultWizardPanel value;

        public PanelInfo(String key, DefaultWizardPanel value) {
            this.key = key;
            this.value = value;
        }
    }

    private static enum WizardMode {
        STANDARD,
        STOP,
        FINISHED;

    }
}

