/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util.datepicker.models;

import com.ericsson.ere.gui.util.datepicker.models.DatePickerModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;

public class DatePickerTableModel
extends AbstractTableModel {
    private DatePickerModel myDatePickerModel = null;
    private DateFormatSymbols myDateFormatSymbols = null;
    private int myNumberOfRows = 0;
    private int myFirstColumn = 0;
    private List<Integer> myDaysOfMonth = new ArrayList<Integer>();

    public DatePickerTableModel(DatePickerModel datePickerModel, Locale parLocale) {
        this.myDatePickerModel = datePickerModel;
        this.myDateFormatSymbols = new DateFormatSymbols(parLocale);
        this.myDatePickerModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("DAY_OF_MONTH") || e.getActionCommand().equals("ALL")) {
                    DatePickerTableModel.this.update();
                }
            }
        });
        this.update();
    }

    public void setLocale(Locale parLocale) {
        this.myDateFormatSymbols = new DateFormatSymbols(parLocale);
        this.update();
    }

    public void update() {
        ArrayList<Integer> theDaysOfMonth = new ArrayList<Integer>();
        int theMinDayOfMonth = this.myDatePickerModel.getCalendar().getActualMinimum(5);
        int theMaxDayOfMonth = this.myDatePickerModel.getCalendar().getActualMaximum(5);
        Calendar theCalendar = (Calendar)this.myDatePickerModel.getCalendar().clone();
        theCalendar.set(5, theMinDayOfMonth);
        int theFirstColumn = DatePickerTableModel.getColumnFromDayOfWeek(theCalendar, theCalendar.get(7));
        for (int theDayOfMonth = theMinDayOfMonth; theDayOfMonth <= theMaxDayOfMonth; ++theDayOfMonth) {
            theDaysOfMonth.add(new Integer(theDayOfMonth));
        }
        this.myDaysOfMonth = theDaysOfMonth;
        this.myFirstColumn = theFirstColumn;
        this.myNumberOfRows = (this.myFirstColumn + (theMaxDayOfMonth - theMinDayOfMonth + 1)) / 7;
        if ((this.myFirstColumn + (theMaxDayOfMonth - theMinDayOfMonth + 1)) % 7 != 0) {
            ++this.myNumberOfRows;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return 6;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int theIndex = rowIndex * 7 + columnIndex - this.myFirstColumn;
        if (theIndex >= 0 && theIndex < this.myDaysOfMonth.size()) {
            return this.myDaysOfMonth.get(theIndex);
        }
        return null;
    }

    @Override
    public String getColumnName(int parColumn) {
        String[] theColumnNames = this.myDateFormatSymbols.getShortWeekdays();
        return theColumnNames[DatePickerTableModel.getDayOfWeekFromColumn(this.myDatePickerModel.getCalendar(), parColumn)];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Integer.class;
    }

    private static int getDayOfWeekFromColumn(Calendar parCalendar, int parColumn) {
        if (parCalendar.getFirstDayOfWeek() == 1) {
            switch (parColumn) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return 7;
                }
            }
        } else {
            switch (parColumn) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 6;
                }
                case 5: {
                    return 7;
                }
                case 6: {
                    return 1;
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private static int getColumnFromDayOfWeek(Calendar parCalendar, int parDayOfWeek) {
        if (parCalendar.getFirstDayOfWeek() == 1) {
            switch (parDayOfWeek) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 5;
                }
                case 7: {
                    return 6;
                }
            }
        } else {
            switch (parDayOfWeek) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
                case 6: {
                    return 4;
                }
                case 7: {
                    return 5;
                }
                case 1: {
                    return 6;
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public int getColumnForSelectedDay() {
        return DatePickerTableModel.getColumnFromDayOfWeek(this.myDatePickerModel.getCalendar(), this.myDatePickerModel.getCalendar().get(7));
    }

    public int getRowForSelectedDay() {
        return (this.myDatePickerModel.getCalendar().get(5) + 5 - this.getColumnForSelectedDay()) / 7;
    }
}

