/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ScrollablePopupMenu
extends JPopupMenu
implements MouseListener {
    private int myWidth = 0;
    protected int myMenuCapacity;
    public static final int DEFAULT_MENU_CAPACITY = 10;
    protected int myScrollSpeed;
    protected int myScrollFastSpeed;
    public static final int DEFAULT_SCROLL_SPEED = 100;
    public static final ImageIcon DEFAULT_SCROLL_UP_FAST_INDICATOR = RmaDefs.getImageIcon("navigate_up2_16.png");
    public static final ImageIcon DEFAULT_SCROLL_UP_INDICATOR = RmaDefs.getImageIcon("navigate_up16.png");
    public static final ImageIcon DEFAULT_SCROLL_DOWN_INDICATOR = RmaDefs.getImageIcon("navigate_down16.png");
    public static final ImageIcon DEFAULT_SCROLL_DOWN_FAST_INDICATOR = RmaDefs.getImageIcon("navigate_down2_16.png");
    protected int myTopItem;
    protected List<Component> myAllMenuItems = null;
    protected List<Component> myFilteredItems = new ArrayList<Component>();
    protected JMenuItem myScrollUpItem;
    protected JMenuItem myScrollDownItem;
    protected JMenuItem myScrollDownFastItem;
    protected JMenuItem myScrollUpFastItem;
    protected JPanel myFilterPanel;
    protected JTextField myFilterTextField;
    protected ScrollThread scrollThread;

    public ScrollablePopupMenu() {
        this(10, 100, 33, DEFAULT_SCROLL_UP_INDICATOR, DEFAULT_SCROLL_UP_FAST_INDICATOR, DEFAULT_SCROLL_DOWN_INDICATOR, DEFAULT_SCROLL_DOWN_FAST_INDICATOR);
    }

    public ScrollablePopupMenu(int menuCapacity, int scrollSpeed, int scrollFastSpeed, Icon upIndicator, Icon upFastIndicator, Icon downIndicator, Icon downFastIndicator) {
        this.myMenuCapacity = menuCapacity;
        this.myScrollSpeed = scrollSpeed;
        this.myScrollFastSpeed = scrollFastSpeed;
        this.myScrollUpFastItem = new JMenuItem(upFastIndicator);
        this.myScrollUpItem = new JMenuItem(upIndicator);
        this.myScrollDownItem = new JMenuItem(downIndicator);
        this.myScrollDownFastItem = new JMenuItem(downFastIndicator);
        this.myScrollUpFastItem.addMouseListener(this);
        this.myScrollUpItem.addMouseListener(this);
        this.myScrollDownItem.addMouseListener(this);
        this.myScrollDownFastItem.addMouseListener(this);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (this.myFilteredItems.size() == 0) {
            this.getFilterTextField().setText("");
        }
        this.createMenu();
        super.show(invoker, x, y);
    }

    protected void fillMenu() {
        List<Component> menuItems = this.getMenuItems();
        for (int i = this.myTopItem; i < this.myMenuCapacity && i < menuItems.size(); ++i) {
            this.add(menuItems.get(i));
        }
    }

    protected void createMenu() {
        List<Component> menuItems = this.getMenuItems();
        this.myTopItem = 0;
        this.removeAll();
        this.fillMenu();
        if (menuItems.size() > this.myMenuCapacity) {
            this.add((Component)this.myScrollUpItem, 0);
            this.add((Component)this.myScrollUpFastItem, 0);
            this.add((Component)this.myScrollDownItem, -1);
            this.add((Component)this.myScrollDownFastItem, -1);
        }
        this.myFilterPanel = new JPanel(new GridBagLayout());
        JLabel filterLabel = new JLabel("Search filter");
        this.myFilterPanel.add((Component)filterLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.myFilterPanel.add((Component)this.getFilterTextField(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.myFilterPanel, 0);
        this.setSize(this.getPreferredSize());
        this.revalidate();
        this.repaint();
        GuiServiceCenter.getInstance().getMainWindow().getGlassPane().repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension();
        List<Component> menuItems = this.getMenuItems();
        for (int i = 0; i < this.myMenuCapacity && i < menuItems.size(); ++i) {
            preferredSize.height += menuItems.get((int)i).getPreferredSize().height;
        }
        preferredSize.width = Math.max(this.myWidth, this.myFilterPanel.getPreferredSize().width);
        preferredSize.height += this.myFilterPanel.getPreferredSize().height;
        if (menuItems.size() > this.myMenuCapacity) {
            preferredSize.height += this.myScrollUpItem.getPreferredSize().height * 4;
        }
        return preferredSize;
    }

    protected JTextField getFilterTextField() {
        if (this.myFilterTextField == null) {
            this.myFilterTextField = new JTextField();
            this.myFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void filter() {
                    String filterString = ScrollablePopupMenu.this.myFilterTextField.getText();
                    ScrollablePopupMenu.this.myFilteredItems = new ArrayList<Component>();
                    for (Component o : ScrollablePopupMenu.this.myAllMenuItems) {
                        if (!((JMenuItem)o).getText().toUpperCase().contains(filterString.toUpperCase())) continue;
                        ScrollablePopupMenu.this.myFilteredItems.add(o);
                    }
                    ScrollablePopupMenu.this.createMenu();
                    ScrollablePopupMenu.this.myFilterTextField.requestFocus();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.filter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.filter();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.filter();
                }
            });
        }
        return this.myFilterTextField;
    }

    protected List<Component> getMenuItems() {
        if (this.getFilterTextField().getText().length() > 0) {
            return this.myFilteredItems;
        }
        if (this.myAllMenuItems == null) {
            this.myAllMenuItems = Arrays.asList(this.getComponents());
            for (int i = 0; i < this.myAllMenuItems.size(); ++i) {
                this.myWidth = Math.max(this.myAllMenuItems.get((int)i).getPreferredSize().width, this.myWidth);
            }
        }
        return this.myAllMenuItems;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.myScrollUpFastItem) {
            this.scrollThread = new ScrollThread(0, 3);
        } else if (e.getSource() == this.myScrollUpItem) {
            this.scrollThread = new ScrollThread(0, 2);
        } else if (e.getSource() == this.myScrollDownItem) {
            this.scrollThread = new ScrollThread(1, 2);
        } else if (e.getSource() == this.myScrollDownFastItem) {
            this.scrollThread = new ScrollThread(1, 3);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.scrollThread.stopScrolling();
        this.scrollThread = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected class ScrollThread
    extends Thread {
        private int myScrollDirection;
        public static final int DIRECTION_UP = 0;
        public static final int DIRECTION_DOWN = 1;
        private int mySpeed;
        public static final int SPEED_SLOW = 2;
        public static final int SPEED_FAST = 3;
        public int myScrollableItemsTopIndex = 3;
        private boolean scrolling;

        public ScrollThread(int direction, int speed) {
            this.myScrollDirection = direction;
            this.mySpeed = speed;
            this.start();
        }

        @Override
        public void run() {
            try {
                this.scrolling = true;
                List<Component> menuItems = ScrollablePopupMenu.this.getMenuItems();
                if (this.myScrollDirection == 0) {
                    do {
                        if (ScrollablePopupMenu.this.myTopItem == 0) {
                            this.scrolling = false;
                            return;
                        }
                        --ScrollablePopupMenu.this.myTopItem;
                        ScrollablePopupMenu.this.remove(menuItems.get(ScrollablePopupMenu.this.myTopItem + ScrollablePopupMenu.this.myMenuCapacity));
                        ScrollablePopupMenu.this.add(menuItems.get(ScrollablePopupMenu.this.myTopItem), this.myScrollableItemsTopIndex);
                        ScrollablePopupMenu.this.validate();
                        if (this.mySpeed == 2) {
                            Thread.sleep(ScrollablePopupMenu.this.myScrollSpeed);
                            continue;
                        }
                        if (this.mySpeed != 3) continue;
                        Thread.sleep(ScrollablePopupMenu.this.myScrollFastSpeed);
                    } while (this.scrolling);
                } else if (this.myScrollDirection == 1) {
                    do {
                        if (ScrollablePopupMenu.this.myTopItem == menuItems.size() - ScrollablePopupMenu.this.myMenuCapacity) {
                            this.scrolling = false;
                            return;
                        }
                        ScrollablePopupMenu.this.remove(menuItems.get(ScrollablePopupMenu.this.myTopItem));
                        ScrollablePopupMenu.this.add(menuItems.get(ScrollablePopupMenu.this.myTopItem + ScrollablePopupMenu.this.myMenuCapacity), ScrollablePopupMenu.this.myMenuCapacity + 1);
                        ++ScrollablePopupMenu.this.myTopItem;
                        ScrollablePopupMenu.this.validate();
                        if (this.mySpeed == 2) {
                            Thread.sleep(ScrollablePopupMenu.this.myScrollSpeed);
                            continue;
                        }
                        if (this.mySpeed != 3) continue;
                        Thread.sleep(ScrollablePopupMenu.this.myScrollFastSpeed);
                    } while (this.scrolling);
                }
            }
            catch (InterruptedException x) {
                this.scrolling = false;
            }
        }

        public void stopScrolling() {
            this.scrolling = false;
        }
    }
}

