/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.gui.util.RelativeDialog;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;

public abstract class RelativePanel
extends AbstractPanelVariableEditor
implements ActionListener {
    private static final long serialVersionUID = 8408292951419948149L;
    protected JTextField myTextField;
    protected JButton myButton;
    protected List<FieldDefinition> myApplicableFields;
    protected String myExpression;
    protected ClassRepository myRep;
    private DataType myType;
    protected FieldDefinition myField;

    public RelativePanel(DataType aType, String anExpression, List<FieldDefinition> applicableFields, ClassRepository aRep, ValueClassFactory aFactory, FieldDefinition field) {
        this.myField = field;
        this.myType = aType;
        this.myRep = aRep;
        this.myExpression = anExpression;
        this.myApplicableFields = applicableFields;
        this.initPanel();
    }

    protected void initPanel() {
        this.setName("Relative" + this.myType.getTypeName() + "Panel");
        this.setLayout(new GridBagLayout());
        this.myTextField = new JTextField();
        this.myTextField.setName("Relative" + this.myType.getTypeName() + "InputTextField");
        this.myTextField.setHorizontalAlignment(4);
        this.myTextField.setEditable(false);
        String expressionString = ExpressionParser.convertExpressionToDisplayableString(this.myExpression, this.myRep);
        expressionString = ExpressionParser.replaceDateConstants(this.myField, expressionString);
        this.myTextField.setText(expressionString);
        this.add((Component)this.myTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myButton = new JButton(RmaDefs.getImageIcon("date-time16.png"));
        this.myButton.setName("RelativeDateButton");
        this.myButton.setPreferredSize(new Dimension(24, 24));
        this.myButton.setSize(new Dimension(24, 24));
        this.myButton.setMaximumSize(new Dimension(24, 24));
        this.myButton.addActionListener(this);
        this.add((Component)this.myButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 13, 3, new Insets(0, 1, 0, 1), 0, 0));
    }

    @Override
    public Object getEditorValue() {
        return this.myExpression;
    }

    @Override
    public boolean isEditorValueValid() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Window owner = GuiUtil.getClosestWindowParent(this);
        String[] theArray = new String[]{};
        if (this.myApplicableFields != null) {
            theArray = FieldDefinitionHelper.extractFieldNameList(this.myApplicableFields).toArray(new String[0]);
        }
        RelativeDialog dialog = this.createRelativeDialog(owner, theArray);
        dialog.setVisible(true);
        if (dialog.isChanged()) {
            this.myExpression = dialog.getExpression();
            String expressionString = ExpressionParser.convertExpressionToDisplayableString(this.myExpression, this.myRep);
            expressionString = ExpressionParser.replaceDateConstants(this.myField, expressionString);
            this.myTextField.setText(expressionString);
            this.fireDataChanged();
        }
    }

    public abstract RelativeDialog createRelativeDialog(Window var1, String[] var2);

    public void setEditorBackground(boolean valid) {
        if (valid) {
            this.myTextField.setBackground(null);
        } else {
            this.myTextField.setBackground(Color.RED);
        }
    }

    public void setTextIndication(String message) {
        this.myTextField.setText(message);
    }
}

