/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.expression.BinaryDateOperator;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.gui.util.RelativeDialog;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.DateUtil;
import ericsson.vareditor.components.SelectableMultipler;
import java.awt.Window;

public class RelativeDateDialog
extends RelativeDialog {
    private static final long serialVersionUID = -608303148833728255L;
    private static final Unit[] DATE_UNITS = new Unit[]{BinaryDateOperator.DateUnit.DAYS, BinaryDateOperator.DateUnit.MONTHS, BinaryDateOperator.DateUnit.YEARS};

    public RelativeDateDialog(Window parent, String aValue, String[] possibleFields, ClassRepository aRep, FieldDefinition field) {
        super(parent, DataType.DATE, aValue, possibleFields, DATE_UNITS, aRep, field);
    }

    @Override
    protected void setDefault() {
        String dateStr = DateUtil.formatISODate(EREDateFactory.today());
        this.myFirstField = ValueFieldCompositeObject.createForValue(dateStr, DataType.DATE);
        this.mySecondValue = 0;
        this.myOperation = "ADD";
        this.myUnit = BinaryDateOperator.DateUnit.DAYS;
    }

    public static String convertExpressionToDisplayableString(String anExpression, ClassRepository aRep) {
        return ExpressionParser.convertExpressionToDisplayableString(anExpression, aRep);
    }

    @Override
    protected SelectableMultipler[] createUnitOptions() {
        SelectableMultipler[] options = new SelectableMultipler[this.myUnits.length];
        for (int i = 0; i < this.myUnits.length; ++i) {
            BinaryDateOperator.DateUnit du = (BinaryDateOperator.DateUnit)this.myUnits[i];
            options[i] = new SelectableMultipler(du.toString(), Long.valueOf(i));
        }
        return options;
    }
}

