/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class CustomArrayBorder
extends TitledBorder {
    private Point textLoc = new Point();
    private int myWidth;
    private boolean myAdaptBorderToText;

    public CustomArrayBorder(int width) {
        super("");
        this.myWidth = width;
    }

    public CustomArrayBorder(boolean adaptToText) {
        super("");
        this.myAdaptBorderToText = adaptToText;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int width, int height) {
        Insets insets;
        Border myBorder = this.getBorder();
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        int descent = 3;
        int ascent = 13;
        if (myBorder != null) {
            insets = myBorder.getBorderInsets(component);
            insets.top += ascent + descent + 2;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.myAdaptBorderToText) {
            int diff = ascent + descent + (Math.max(2, 4) - 2);
            grooveRect.y += diff;
            grooveRect.height -= diff;
            this.textLoc.y = grooveRect.y - (descent + 2);
        } else {
            int diff = Math.max(0, ascent / 2 + 2 - 2);
            grooveRect.y += diff;
            grooveRect.height -= diff;
            this.textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
        }
        this.textLoc.x = grooveRect.x + 5 + insets.left;
        if (myBorder != null) {
            Rectangle clipRect = new Rectangle();
            Rectangle saveClip = g.getClipBounds();
            clipRect.setBounds(saveClip);
            if (this.computeIntersection(clipRect, x, y, this.textLoc.x - 1 - x, height)) {
                g.setClip(clipRect);
                myBorder.paintBorder(component, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
            clipRect.setBounds(saveClip);
            if (this.computeIntersection(clipRect, this.textLoc.x + this.myWidth + 1, y, x + width - (this.textLoc.x + this.myWidth + 1), height)) {
                g.setClip(clipRect);
                myBorder.paintBorder(component, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
            clipRect.setBounds(saveClip);
            if (this.computeIntersection(clipRect, this.textLoc.x - 1, this.textLoc.y + descent, this.myWidth + 2, y + height - this.textLoc.y - descent)) {
                g.setClip(clipRect);
                myBorder.paintBorder(component, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
            g.setClip(saveClip);
        } else {
            myBorder.paintBorder(component, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
        }
    }

    private boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }
}

