/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.util.ArrayEditPanelBuilder;
import com.ericsson.ere.variable.DefaultVariableProducer;
import com.ericsson.ere.variable.VariableProducer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.RowIndexRenderer;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class ArrayEditPanel
extends JPanel
implements MouseWheelListener,
ListSelectionListener {
    private static final int ENUM_NAME_MAX_WIDTH = 50;
    private JToolBar myToolbar;
    private static final String ACTION_ADD = "Add";
    private static final String ACTION_INSERT = "Insert";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_COMMIT = "Commit";
    private static final String ACTION_CANCEL = "Cancel";
    private static final String LBL_EDIT_VALUE_FMT = "Editing row #%s:";
    private static final String LBL_EDIT_ENTRY = "Editing entry";
    private static final String[] VALUE_LIST_COLUMN_NAMES = new String[]{"Index", "Value"};
    private static final String[] ENUM_COLUMN_NAMES = new String[]{"Name", "Value"};
    private Action myAddAction = new AddAction();
    private Action myInsertAction = new InsertAction();
    private Action myDeleteAction = new DeleteAction();
    private Action myCommitAction = new CommitEditAction();
    private Action myCancelAction = new CancelEditAction();
    private JScrollPane myScrollWrapperPanel;
    private ArrayVariable.EditMode myEditMode = ArrayVariable.EditMode.ALLOW_EDIT;
    private JLabel myEditorLabel;
    private int myEditingRowIndex = -1;
    private Dimension myMinSize = new Dimension(200, 100);
    private JTable myArrayTable;
    private Component myFocusOwner;
    private ValueResolver myValueResolver;
    private int myProtectedRangeHigh;
    private JLabel myEditModeLabel;
    private Variable myEditorVariable;
    private Object myDefaultVariableValue;
    private JTextField myKeyField;
    private JPanel myValueEditorPanel;
    private KeyRestriction myKeyRestriction;
    private Mode myMode;
    private final VariableProducer myVariableProducer;
    private Component myAliasEditComponent;

    @Deprecated
    public ArrayEditPanel(ArrayModel model, String dataType, Component focusOwner) {
        this(model, DataType.lookup(dataType), focusOwner);
    }

    @Deprecated
    public ArrayEditPanel(ArrayModel model, DataType dataType, Component focusOwner) {
        this(model, dataType);
        this.myFocusOwner = focusOwner;
    }

    @Deprecated
    public ArrayEditPanel(ArrayModel model, String dataType) {
        this(model, DataType.lookup(dataType));
    }

    @Deprecated
    public ArrayEditPanel(ArrayModel model, DataType dataType) {
        this(model, (ValueResolver)dataType, false);
    }

    public ArrayEditPanel(ArrayModel model, ValueResolver valueResolver, boolean forceEditArray) {
        this(model, valueResolver, forceEditArray, null, null);
    }

    public ArrayEditPanel(ArrayModel model, ValueResolver valueResolver, boolean forceEditArray, VariableProducer varProducer, ArrayVariable.ObjectLabeler objectLabeler) {
        this(ArrayEditPanelBuilder.useModel(model).withValueResolver(valueResolver).withObjectLabeler(objectLabeler).forceArrayEdit(forceEditArray).withVariableProducer(varProducer));
    }

    ArrayEditPanel(ArrayEditPanelBuilder creator) {
        super(new GridBagLayout());
        VariableProducer producer = creator.getVariableProducer();
        if (producer == null) {
            producer = new DefaultVariableProducer(null);
        }
        this.myVariableProducer = producer;
        this.myValueResolver = creator.getValueResolver();
        if (this.myValueResolver == null) {
            throw new IllegalArgumentException("Missing value resolver, cannot be null.");
        }
        ArrayModel model = creator.getModel();
        if (model.getColumnCount() < 1 || model.getColumnCount() > 2) {
            throw new IllegalArgumentException("Invalid column count in model, expecting 1 or 2.");
        }
        this.myMode = this.getKeyMode(model, creator.getForceEditArray(), creator.getActAsSetEditor());
        this.setupUI(model);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ArrayEditPanel.this.myArrayTable.repaint();
            }
        });
    }

    private Mode getKeyMode(ArrayModel model, boolean forceEditArray, boolean actAsSetEditor) {
        Mode mode;
        if (model.getNumberOfDimensions() == 2) {
            if (forceEditArray) {
                assert (model.getColumnClass(0) == Integer.class);
                mode = Mode.ASCENDING_INDEX;
            } else {
                mode = Mode.ENUM;
            }
        } else {
            mode = actAsSetEditor ? Mode.SINGLE_SET : Mode.SINGEL;
        }
        return mode;
    }

    private void setupUI(ArrayModel model) {
        model.setColumnNames(this.myMode == Mode.ENUM ? ENUM_COLUMN_NAMES : VALUE_LIST_COLUMN_NAMES);
        this.myEditingRowIndex = -1;
        this.myScrollWrapperPanel = new JScrollPane(this.createArrayTable(model));
        this.myScrollWrapperPanel.addMouseWheelListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 11;
        gbc.fill = 1;
        if (!model.isFixedLength()) {
            this.add((Component)this.initToolbar(), gbc);
        }
        ++gbc.gridy;
        this.add((Component)this.createEditorPanel(model), gbc);
        ++gbc.gridy;
        gbc.anchor = 12;
        gbc.weighty = 1.0;
        this.add((Component)this.myScrollWrapperPanel, gbc);
        this.myEditModeLabel = new JLabel("");
        this.myEditModeLabel.setName("ArrayEditPanel.JLabel.ModeLabel");
        this.myEditModeLabel.setVisible(false);
        ++gbc.gridy;
        gbc.anchor = 15;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.myEditModeLabel, gbc);
        this.updateActions(-1);
    }

    private void updateActions(int row) {
        boolean canEdit = this.canEditRow(row);
        this.myInsertAction.setEnabled(row >= 0 && canEdit);
        this.myDeleteAction.setEnabled(row >= 0 && canEdit);
        this.myAddAction.setEnabled(this.myEditMode != ArrayVariable.EditMode.READ_ONLY);
    }

    private JTable createArrayTable(ArrayModel model) {
        this.myArrayTable = new JTable(model){

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.myArrayTable.setName("ArrayEditPanel.JTable.ArrayTable");
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.myArrayTable.getInputMap(1).getParent().remove(esc);
        this.myArrayTable.setSelectionMode(0);
        this.myArrayTable.setPreferredScrollableViewportSize(this.myMinSize);
        this.myArrayTable.getSelectionModel().addListSelectionListener(this);
        this.myArrayTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = ArrayEditPanel.this.myArrayTable.rowAtPoint(e.getPoint());
                if (row == ArrayEditPanel.this.myArrayTable.getSelectedRow() && !ArrayEditPanel.this.isEditing() && ArrayEditPanel.this.canEditRow(row)) {
                    ArrayEditPanel.this.beginNewEdit(row);
                }
            }
        });
        this.configureTableColumns();
        return this.myArrayTable;
    }

    private void configureTableColumns() {
        if (this.myMode == Mode.SINGLE_SET) {
            TableColumn column = this.myArrayTable.getColumnModel().getColumn(0);
            column.setMinWidth(0);
            column.setMaxWidth(0);
            column.setResizable(false);
            this.setRendererAsRowCounter();
        } else if (this.myMode != Mode.ENUM) {
            this.myArrayTable.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.setRendererAsRowCounter();
        }
        this.myArrayTable.getColumnModel().getColumn(1).setCellRenderer(new CustomRenderer());
    }

    public boolean isEditing() {
        return this.myEditingRowIndex >= 0;
    }

    public void setInitialState() {
        this.cancelOngoingEdit();
        this.myArrayTable.clearSelection();
        this.createOrUpdateEditorPanel();
    }

    public Component getFocusOwner() {
        return this.myFocusOwner;
    }

    public void setFocusOwner(Component c) {
        this.myFocusOwner = c;
    }

    private JComponent createEditorPanel(ArrayModel model) {
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BoxLayout(editorPanel, 2));
        this.myEditorLabel = new JLabel(this.createEditLabelText("-"));
        this.myEditorLabel.setName("ArrayEditPanel.JLabel.editlabel");
        editorPanel.add(Box.createHorizontalStrut(5));
        editorPanel.add(this.myEditorLabel);
        editorPanel.add(Box.createHorizontalStrut(5));
        if (this.myMode == Mode.ENUM || this.myMode == Mode.ASCENDING_INDEX) {
            this.myKeyField = new JTextField();
            this.myKeyField.setName("ArrayEditPanel.Component.keyField");
            this.myKeyField.addFocusListener(new InputFocusListener());
            if (this.myMode == Mode.ENUM) {
                this.myKeyRestriction = new MandatoryUniqueKeyRestriction();
            } else {
                this.myKeyField.setDocument(new OnlyDigitsDocument());
                this.myKeyRestriction = new NumberAscendingIndexRestriction();
            }
            this.myKeyField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 38: 
                        case 40: {
                            ArrayEditPanel.this.myArrayTable.dispatchEvent(e);
                            e.consume();
                        }
                    }
                }
            });
            editorPanel.add(this.myKeyField);
        }
        this.createOrUpdateEditorPanel();
        editorPanel.add(this.myValueEditorPanel);
        editorPanel.add(Box.createHorizontalStrut(4));
        editorPanel.add(this.createButtonToolBarForValueEditor());
        editorPanel.add(Box.createHorizontalStrut(1));
        ActionMap am = editorPanel.getActionMap();
        InputMap im = editorPanel.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), "enter_pressed");
        am.put("enter_pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArrayEditPanel.this.commitOngoingEdit()) {
                    int newRow = ArrayEditPanel.this.myArrayTable.getSelectedRow() + 1;
                    boolean selectNext = true;
                    if (newRow >= ArrayEditPanel.this.myArrayTable.getRowCount()) {
                        selectNext = ArrayEditPanel.this.addNewRow();
                    }
                    if (selectNext) {
                        ArrayEditPanel.this.myArrayTable.setRowSelectionInterval(newRow, newRow);
                    }
                }
            }
        });
        this.disableEditorPanel();
        return editorPanel;
    }

    private JToolBar createButtonToolBarForValueEditor() {
        JToolBar buttonBar = new JToolBar();
        buttonBar.setFloatable(false);
        buttonBar.setBorderPainted(false);
        buttonBar.setBorder(BorderFactory.createEmptyBorder());
        buttonBar.setOpaque(false);
        boolean commitCancelShouldBeVisible = this.myAliasEditComponent == null;
        JButton commitButton = buttonBar.add(this.myCommitAction);
        commitButton.setName("ArrayEditPanel.JButton.commit");
        commitButton.setVisible(commitCancelShouldBeVisible);
        JButton cancelButton = buttonBar.add(this.myCancelAction);
        cancelButton.setName("ArrayEditPanel.JButton.cancel");
        cancelButton.setVisible(commitCancelShouldBeVisible);
        return buttonBar;
    }

    private void createOrUpdateEditorPanel() {
        this.myEditorVariable = this.myVariableProducer.produceVariable(this.myValueResolver.getDataType(), null);
        this.myDefaultVariableValue = this.myEditorVariable.getValueObject();
        if (this.myDefaultVariableValue == null) {
            this.myDefaultVariableValue = this.myValueResolver.createDefaultInstance();
        }
        Component editorComponent = this.myEditorVariable.getEditor();
        editorComponent.setName("ArrayEditPanel.Component.inputField");
        Dimension editorPrefSize = editorComponent.getPreferredSize();
        if (editorPrefSize.getHeight() > 30.0) {
            this.myAliasEditComponent = editorComponent = this.createLargeEditorOpenButton(this.myEditorVariable);
        }
        editorComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: 
                    case 40: {
                        ArrayEditPanel.this.myArrayTable.dispatchEvent(e);
                        e.consume();
                    }
                }
            }
        });
        if (this.myValueEditorPanel == null) {
            this.myValueEditorPanel = new JPanel();
            this.myValueEditorPanel.setLayout(new BoxLayout(this.myValueEditorPanel, 0));
        } else {
            this.myValueEditorPanel.removeAll();
        }
        this.myValueEditorPanel.add(editorComponent);
        this.setEditorPanelEnabled(false);
    }

    private JButton createLargeEditorOpenButton(final Variable editorVariable) {
        final JButton editorButton = new JButton("Click to edit");
        editorButton.setName("ArrayEditPanel.JButton.editButton");
        editorButton.setIcon(RmaDefs.getImageIcon("new_edit.gif"));
        editorButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog editorDialog = ArrayEditPanel.this.createLargeEditorDialog(editorVariable.getEditor());
                editorDialog.setLocationRelativeTo(editorButton);
                editorDialog.setVisible(true);
            }
        });
        editorButton.setToolTipText("Open detached editor");
        return editorButton;
    }

    private JDialog createLargeEditorDialog(Component editorComponent) {
        final JDialog editorDialog = new JDialog(GuiUtil.getClosestWindowParent(this.myArrayTable), "Edit value", Dialog.ModalityType.APPLICATION_MODAL);
        editorDialog.setDefaultCloseOperation(2);
        editorDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ArrayEditPanel.this.myCancelAction.actionPerformed(new ActionEvent(editorDialog, 0, ""));
            }
        });
        editorDialog.setLayout(new BorderLayout());
        editorDialog.getContentPane().add(editorComponent, "Center");
        editorDialog.getContentPane().add((Component)this.createButtonToolBarForDetachedEditor(editorDialog), "South");
        editorDialog.pack();
        editorDialog.setMinimumSize(new Dimension(editorDialog.getWidth(), editorDialog.getHeight()));
        return editorDialog;
    }

    private JToolBar createButtonToolBarForDetachedEditor(JDialog editorDialog) {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        toolbar.setBorder(BorderFactory.createEmptyBorder());
        toolbar.setOpaque(false);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(new ActionWrapper(this.myCommitAction, editorDialog)).setName("DetachedEditPanel.JButton.commit");
        toolbar.add(new ActionWrapper(this.myCancelAction, editorDialog)).setName("DetachedEditPanel.JButton.cancel");
        return toolbar;
    }

    private void disableEditorPanel() {
        this.setEditorPanelEnabled(false);
    }

    private void enableEditorPanel() {
        this.setEditorPanelEnabled(true);
    }

    private void setEditorPanelEnabled(boolean b) {
        this.myEditorLabel.setEnabled(b);
        if (!b) {
            this.myEditorLabel.setText(this.createEditLabelText("-"));
        }
        if (this.myKeyField != null) {
            this.myKeyField.setEnabled(b);
        }
        this.myEditorVariable.setEnabled(b);
        this.myCommitAction.setEnabled(b);
        this.myCancelAction.setEnabled(b);
        if (this.myAliasEditComponent != null) {
            this.myAliasEditComponent.setEnabled(b);
        }
    }

    public JTable getTable() {
        return this.myArrayTable;
    }

    @Deprecated
    public JPanel getTablePanel() {
        return this;
    }

    public void setEditMode(ArrayVariable.EditMode mode) {
        if (mode != this.myEditMode) {
            this.myEditMode = mode;
            this.cancelOngoingEdit();
            this.myArrayTable.getSelectionModel().clearSelection();
            this.updateActions(-1);
            ((ArrayModel)this.myArrayTable.getModel()).setReadOnly(mode == ArrayVariable.EditMode.READ_ONLY);
            switch (this.myEditMode) {
                case READ_ONLY: {
                    this.myEditModeLabel.setText("Read only mode, no editing is allowed.");
                    this.myEditModeLabel.setVisible(true);
                    break;
                }
                case PROTECT_OLD: {
                    this.myProtectedRangeHigh = this.myArrayTable.getModel().getRowCount() - 1;
                    this.myEditModeLabel.setText("Limited edit mode, only new values can be added and edited.");
                    this.myEditModeLabel.setVisible(true);
                    break;
                }
                default: {
                    this.myEditModeLabel.setVisible(false);
                }
            }
        }
    }

    private void cancelOngoingEdit() {
        if (!this.isEditing()) {
            return;
        }
        this.myEditingRowIndex = -1;
        if (this.myKeyField != null) {
            this.myKeyField.setText("");
        }
        this.myEditorVariable.setValue(this.myDefaultVariableValue);
        this.disableEditorPanel();
        if (this.myMode == Mode.ENUM || this.myMode == Mode.ASCENDING_INDEX) {
            this.myKeyField.setBackground(UIManager.getColor("TextField.background"));
        }
        this.setStatusBarMessage("");
    }

    private boolean commitOngoingEdit() {
        boolean commitOk;
        if (!this.isEditing()) {
            commitOk = true;
        } else if (!this.checkKeyValidityAndUpdateStatus()) {
            commitOk = false;
        } else if (!this.myEditorVariable.isValueValid()) {
            commitOk = false;
        } else {
            ArrayModel model = (ArrayModel)this.myArrayTable.getModel();
            if (this.myMode == Mode.ENUM) {
                model.setValueAt(this.myKeyField.getText(), this.myEditingRowIndex, 0);
                this.myKeyField.setText("");
            } else if (this.myMode == Mode.ASCENDING_INDEX) {
                model.setValueAt(Integer.valueOf(this.myKeyField.getText()), this.myEditingRowIndex, 0);
                this.myKeyField.setText("0");
            }
            Object value = this.myEditorVariable.getValueObject();
            model.setValueAt(value, this.myEditingRowIndex, 1);
            this.myEditorVariable.setValue(this.myDefaultVariableValue);
            this.disableEditorPanel();
            this.myEditingRowIndex = -1;
            commitOk = true;
        }
        return commitOk;
    }

    private void beginNewEdit(int rowIndex) {
        Object value;
        this.enableEditorPanel();
        this.myEditingRowIndex = rowIndex;
        this.myEditorLabel.setText(this.createEditLabelText(rowIndex));
        if (this.myMode == Mode.ENUM || this.myMode == Mode.ASCENDING_INDEX) {
            Object key = this.myArrayTable.getValueAt(rowIndex, 0);
            String strKey = key == null ? "" : String.valueOf(key);
            this.myKeyField.setText(strKey);
        }
        if ((value = this.myArrayTable.getValueAt(rowIndex, 1)) == null) {
            value = this.myDefaultVariableValue;
        }
        this.myEditorVariable.setValue(value);
        this.setFocusOnInputEditor();
    }

    private void setFocusOnInputEditor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                if (ArrayEditPanel.this.myMode == Mode.ENUM) {
                    ArrayEditPanel.this.myKeyField.requestFocusInWindow();
                } else {
                    ArrayEditPanel.this.myValueEditorPanel.requestFocusInWindow();
                }
            }
        });
    }

    private boolean addNewRow() {
        this.cancelOngoingEdit();
        ArrayModel model = (ArrayModel)this.myArrayTable.getModel();
        if (model.getMaxNumberOfRows() > 0 && model.getRowCount() >= model.getMaxNumberOfRows()) {
            DialogFactory.getErrorDialog("Limited number of rows", "Max number of rows allowed " + model.getMaxNumberOfRows());
            return false;
        }
        model.addRow(this.getProtoRow(model));
        if (!this.isEditing()) {
            this.scrollToRow(this.myArrayTable.getRowCount() - 1);
        } else {
            this.setFocusOnInputEditor();
        }
        return true;
    }

    private Object[] getProtoRow(ArrayModel model) {
        Object[] retVal;
        Object defaultValue = this.myDefaultVariableValue;
        switch (model.getNumberOfDimensions()) {
            case 1: {
                retVal = new Object[]{defaultValue};
                break;
            }
            case 2: {
                retVal = new Object[]{this.myKeyRestriction.getDefaultKey(), defaultValue};
                break;
            }
            default: {
                throw new AssertionError((Object)"Wrong number of dimensions in array.");
            }
        }
        return retVal;
    }

    private JComponent initToolbar() {
        this.myToolbar = new JToolBar();
        this.myToolbar.setFloatable(false);
        this.myToolbar.add(this.myAddAction).setName("ArrayEditPanel.JButton.add");
        JButton insertButton = this.myToolbar.add(this.myInsertAction);
        insertButton.setName("ArrayEditPanel.JButton.insert");
        insertButton.setVisible(this.myMode != Mode.SINGLE_SET);
        this.myToolbar.add(this.myDeleteAction).setName("ArrayEditPanel.JButton.delete");
        return this.myToolbar;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar scrollBar = this.myScrollWrapperPanel.getVerticalScrollBar();
        if (!(scrollBar != null && scrollBar.isVisible() || this.myFocusOwner == null)) {
            this.dispatchEvent(SwingUtilities.convertMouseEvent(this.myScrollWrapperPanel, e, this.myFocusOwner));
        }
    }

    private void setStatusBarMessage(String message) {
        StatusPanel.getInstance().setStatusMsg(message);
    }

    private boolean canEditRow(int row) {
        switch (this.myEditMode) {
            case ALLOW_EDIT: {
                return true;
            }
            case PROTECT_OLD: {
                return row > this.myProtectedRangeHigh;
            }
            case READ_ONLY: {
                return false;
            }
        }
        return false;
    }

    public void cleanupModel(ArrayModel model) {
        DataType dt = this.myValueResolver.getDataType();
        boolean allowEmptyRows = dt.getMainTypeClass().getName().endsWith("String");
        boolean keepEmptyValueListRows = false;
        boolean userForcedDeletion = false;
        for (int i = model.getRowCount() - 1; i >= 0; --i) {
            Object name = model.getValueAt(i, 0);
            Object value = model.getValueAt(i, 1);
            if (this.isEmptyString(value) || this.myMode == Mode.ENUM && this.isEmptyString(name)) {
                if (this.myMode == Mode.ENUM || this.myMode == Mode.ASCENDING_INDEX) {
                    this.myKeyField.setText("");
                    this.myKeyField.setBackground(UIManager.getColor("TextField.background"));
                }
                if (this.isEmptyString(name)) {
                    model.removeRow(i);
                    continue;
                }
                if (!allowEmptyRows || userForcedDeletion) {
                    model.removeRow(i);
                    continue;
                }
                if (this.myMode != Mode.ENUM && !keepEmptyValueListRows) {
                    if (DialogFactory.getQuestionDialogCustomButtons(this, "Value list contains empty rows", "<html>Your value list contains empty rows.<P>Do you want to keep the empty rows?", "Yes", "No")) {
                        keepEmptyValueListRows = true;
                        continue;
                    }
                    userForcedDeletion = true;
                    model.removeRow(i);
                    continue;
                }
            }
            if (this.myMode != Mode.SINGLE_SET || !model.rowHasDuplicateInColumn(i, 1)) continue;
            model.removeRow(i);
        }
    }

    private boolean isEmptyString(Object o) {
        return o == null || "".equals(o);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selRow = this.myArrayTable.getSelectedRow();
        if (!e.getValueIsAdjusting()) {
            this.updateActions(selRow);
            if (selRow >= 0 && this.canEditRow(selRow)) {
                this.beginNewEdit(this.myArrayTable.getSelectedRow());
            } else {
                this.cancelOngoingEdit();
            }
        }
    }

    public void updatePanelWithModel(ArrayModel newModel) {
        this.myArrayTable.setModel(newModel);
        this.configureTableColumns();
    }

    private void setRendererAsRowCounter() {
        TableColumn labelCol = this.myArrayTable.getColumnModel().getColumn(0);
        labelCol.setCellRenderer(new RowIndexRenderer(this.myMode == Mode.SINGEL || this.myMode == Mode.SINGLE_SET));
        int width = GuiUtil.getMaxPreferredWidth(this.myArrayTable, 0);
        labelCol.setMinWidth(10);
        labelCol.setPreferredWidth(width);
    }

    private boolean checkKeyValidityAndUpdateStatus() {
        if (this.myKeyField == null) {
            return true;
        }
        String key = this.myKeyField.getText();
        boolean valid = this.myKeyRestriction.isStringValid(key);
        if (!valid) {
            this.setStatusBarMessage(this.myKeyRestriction.getInvalidMessage());
            this.myKeyField.setBackground(Color.RED);
        } else {
            this.setStatusBarMessage("");
            this.myKeyField.setBackground(UIManager.getColor("TextField.background"));
        }
        return valid;
    }

    private void scrollToRow(int row) {
        Rectangle rect = this.myArrayTable.getCellRect(row, row, true);
        this.myArrayTable.scrollRectToVisible(rect);
        this.myArrayTable.setRowSelectionInterval(row, row);
    }

    private JTable getArrayTable() {
        return this.myArrayTable;
    }

    private int getEditingRowIndex() {
        return this.myEditingRowIndex;
    }

    private String createEditLabelText(Object o) {
        String lableText = this.myMode == Mode.SINGLE_SET ? LBL_EDIT_ENTRY : String.format(LBL_EDIT_VALUE_FMT, String.valueOf(o));
        return lableText;
    }

    private static class ActionWrapper
    extends AbstractAction {
        private final Action myWrappedAction;
        private final JDialog myDialog;

        private ActionWrapper(Action action, JDialog dialog) {
            super((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
            this.myWrappedAction = action;
            this.myDialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myWrappedAction.actionPerformed(e);
            this.myDialog.dispose();
        }
    }

    private static class OnlyDigitsDocument
    extends PlainDocument {
        private OnlyDigitsDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            for (int i = 0; i < str.length(); ++i) {
                char s = str.charAt(i);
                if (Character.isDigit(s) || s == '-' || s == ' ' || s == ':') continue;
                StatusPanel.getInstance().setStatusMsg("Only digits 0-9 allowed");
                return;
            }
            StatusPanel.getInstance().setStatusMsg("");
            super.insertString(offs, str, a);
        }
    }

    private class MandatoryUniqueKeyRestriction
    implements KeyRestriction {
        private MandatoryUniqueKeyRestriction() {
        }

        @Override
        public String getInvalidMessage() {
            return "The enum constant name must be non-empty, unique, and at most 50 characters long.";
        }

        @Override
        public boolean isStringValid(String str) {
            boolean isValid = str != null && !"".equals(str) && ArrayEditPanel.this.isEditing() && str.length() <= 50 && !this.doesValueExistsInModel(str);
            return isValid;
        }

        private boolean doesValueExistsInModel(Object value) {
            for (int r = 0; r < ArrayEditPanel.this.myArrayTable.getRowCount(); ++r) {
                Object current = ArrayEditPanel.this.myArrayTable.getValueAt(r, 0);
                if (current == null || !current.equals(value) || r == ArrayEditPanel.this.myEditingRowIndex) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getDefaultKey() {
            return "";
        }

        @Override
        public String getDefaultInsertKey(int row) {
            return "0";
        }
    }

    protected class NumberAscendingIndexRestriction
    implements KeyRestriction {
        private String myInvalidMessage = "";

        protected NumberAscendingIndexRestriction() {
        }

        @Override
        public String getDefaultInsertKey(int row) {
            int previousRowNumber;
            JTable arrayTable = ArrayEditPanel.this.getArrayTable();
            int nextRowNumber = Integer.parseInt(arrayTable.getValueAt(row, 0).toString());
            String valueToReturn = row > 0 ? ((previousRowNumber = Integer.parseInt(arrayTable.getValueAt(row - 1, 0).toString())) + 1 != nextRowNumber ? "" + (nextRowNumber - 1) : "-1") : "" + (nextRowNumber - 1);
            return valueToReturn;
        }

        @Override
        public Object getDefaultKey() {
            Object defaultValue;
            JTable arrayTable = ArrayEditPanel.this.getArrayTable();
            int rowsInModel = arrayTable.getRowCount();
            if (rowsInModel == 0) {
                defaultValue = ArrayEditPanel.this.myMode == Mode.ASCENDING_INDEX ? Integer.valueOf(0) : "0";
            } else {
                int lastValue = Integer.parseInt(arrayTable.getValueAt(rowsInModel - 1, 0).toString());
                defaultValue = ArrayEditPanel.this.myMode == Mode.ASCENDING_INDEX ? Integer.valueOf(lastValue + 1) : String.valueOf(lastValue + 1);
            }
            return defaultValue;
        }

        @Override
        public String getInvalidMessage() {
            return this.myInvalidMessage;
        }

        @Override
        public boolean isStringValid(String str) {
            boolean isValid;
            int row;
            try {
                row = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                this.myInvalidMessage = "Input is not a number";
                return false;
            }
            if (row < 0) {
                this.myInvalidMessage = "Index must not be less than 0";
                return false;
            }
            JTable arrayTable = ArrayEditPanel.this.getArrayTable();
            int editingRow = ArrayEditPanel.this.getEditingRowIndex();
            if (editingRow == 0) {
                if (arrayTable.getRowCount() - 1 <= editingRow) {
                    return true;
                }
                int valueToCheckTowards = Integer.parseInt(arrayTable.getValueAt(editingRow + 1, 0).toString());
                if (row < valueToCheckTowards) {
                    isValid = true;
                } else {
                    this.myInvalidMessage = "Index must be smaller than " + valueToCheckTowards;
                    isValid = false;
                }
            } else if (editingRow == arrayTable.getRowCount() - 1) {
                int valueToCheckTowards = Integer.parseInt(arrayTable.getValueAt(editingRow - 1, 0).toString());
                if (row > valueToCheckTowards) {
                    isValid = true;
                } else {
                    this.myInvalidMessage = "Index must be greater than " + valueToCheckTowards;
                    isValid = false;
                }
            } else {
                int previousRowNumber = Integer.parseInt(arrayTable.getValueAt(editingRow - 1, 0).toString());
                int nextRowNumber = Integer.parseInt(arrayTable.getValueAt(editingRow + 1, 0).toString());
                if (row > previousRowNumber && row < nextRowNumber) {
                    isValid = true;
                } else {
                    this.myInvalidMessage = "Index must be in range " + (previousRowNumber + 1) + "-" + (nextRowNumber - 1);
                    isValid = false;
                    if (previousRowNumber + 1 == nextRowNumber - 1) {
                        this.myInvalidMessage = "Index must be " + (previousRowNumber + 1);
                    }
                }
            }
            return isValid;
        }
    }

    private static interface KeyRestriction {
        public boolean isStringValid(String var1);

        public String getInvalidMessage();

        public Object getDefaultKey();

        public String getDefaultInsertKey(int var1);
    }

    private class InputFocusListener
    implements FocusListener {
        private InputFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ArrayEditPanel.this.setStatusBarMessage("");
            ArrayEditPanel.this.myKeyField.setBackground(UIManager.getColor("TextField.background"));
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!(e.getOppositeComponent() instanceof JTable) && !(e.getOppositeComponent() instanceof JButton)) {
                this.checkInputValidityAndUpdateStatus();
            }
        }

        private void checkInputValidityAndUpdateStatus() {
            if (!ArrayEditPanel.this.isEditing()) {
                ArrayEditPanel.this.setStatusBarMessage("");
                ArrayEditPanel.this.myKeyField.setBackground(UIManager.getColor("TextField.background"));
                return;
            }
            ArrayEditPanel.this.checkKeyValidityAndUpdateStatus();
        }
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        protected TableCellRenderer myInnerRenderer;

        CustomRenderer() {
            Object templateObject = ArrayEditPanel.this.myDefaultVariableValue;
            Class<?> clazz = templateObject != null ? templateObject.getClass() : ArrayEditPanel.this.myValueResolver.getDataType().getMainTypeClass();
            this.myInnerRenderer = ArrayEditPanel.this.myArrayTable.getDefaultRenderer(clazz);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.myInnerRenderer != null ? this.myInnerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String displayString = ArrayEditPanel.this.myValueResolver.makeDisplayString(value);
            if (c instanceof JLabel) {
                ((JLabel)c).setText(displayString);
            } else if (c instanceof JTextComponent) {
                ((JTextComponent)c).setText(displayString);
            }
            if (ArrayEditPanel.this.myMode == Mode.SINGLE_SET) {
                ArrayModel model = (ArrayModel)table.getModel();
                if (model.rowHasDuplicateInColumn(row, 1)) {
                    c.setBackground(isSelected ? Color.ORANGE : Color.YELLOW);
                } else {
                    c.setBackground(isSelected ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("Table.background"));
                }
            }
            return c;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            super(ArrayEditPanel.ACTION_DELETE, RmaDefs.getImageIcon("new_tableDeleteRow.gif"));
            this.putValue("ActionCommandKey", ArrayEditPanel.ACTION_DELETE);
            this.putValue("ShortDescription", "Delete the selected row");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayModel model = (ArrayModel)ArrayEditPanel.this.myArrayTable.getModel();
            int selectedRow = ArrayEditPanel.this.myArrayTable.getSelectedRow();
            if (selectedRow >= 0 && ArrayEditPanel.this.canEditRow(selectedRow)) {
                model.removeRow(selectedRow);
                if (selectedRow >= ArrayEditPanel.this.myArrayTable.getRowCount()) {
                    selectedRow = ArrayEditPanel.this.myArrayTable.getRowCount() - 1;
                }
                if (selectedRow != -1) {
                    ArrayEditPanel.this.scrollToRow(selectedRow);
                }
            }
        }
    }

    private class InsertAction
    extends AbstractAction {
        InsertAction() {
            super(ArrayEditPanel.ACTION_INSERT, RmaDefs.getImageIcon("new_tableAddRowAbove.gif"));
            this.putValue("ActionCommandKey", ArrayEditPanel.ACTION_INSERT);
            this.putValue("ShortDescription", "Insert an empty row before selected row");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = ArrayEditPanel.this.myArrayTable.getSelectedRow();
            if (selectedRow >= 0 && ArrayEditPanel.this.canEditRow(selectedRow)) {
                ArrayModel model = (ArrayModel)ArrayEditPanel.this.myArrayTable.getModel();
                if (model.getMaxNumberOfRows() > 0 && model.getRowCount() >= model.getMaxNumberOfRows()) {
                    DialogFactory.getErrorDialog("Limited number of rows", "Max number of rows allowed is " + model.getMaxNumberOfRows());
                } else {
                    Object[] obj;
                    if (ArrayEditPanel.this.myMode == Mode.ASCENDING_INDEX && ArrayEditPanel.this.myKeyRestriction.getDefaultInsertKey(selectedRow).equals("-1")) {
                        ArrayEditPanel.this.setStatusBarMessage("Not allowed in insert row here");
                        return;
                    }
                    if (ArrayEditPanel.this.myMode == Mode.ASCENDING_INDEX) {
                        String defaultKey = ArrayEditPanel.this.myKeyRestriction.getDefaultInsertKey(selectedRow);
                        Integer index = Integer.valueOf(defaultKey);
                        obj = new Object[]{index, ArrayEditPanel.this.myDefaultVariableValue};
                    } else {
                        obj = ArrayEditPanel.this.getProtoRow(model);
                    }
                    model.insertRow(selectedRow, obj);
                    ArrayEditPanel.this.scrollToRow(selectedRow);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction() {
            super(ArrayEditPanel.ACTION_ADD, RmaDefs.getImageIcon("new_tableAddRowBelow.gif"));
            this.putValue("ActionCommandKey", ArrayEditPanel.ACTION_ADD);
            this.putValue("ShortDescription", "Add an empty row");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayEditPanel.this.addNewRow();
        }
    }

    private class CancelEditAction
    extends AbstractAction {
        public CancelEditAction() {
            super(ArrayEditPanel.ACTION_CANCEL, RmaDefs.getImageIcon("cancel_edit.png"));
            this.putValue("ActionCommandKey", ArrayEditPanel.ACTION_CANCEL);
            this.putValue("ShortDescription", "Cancel editing");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayEditPanel.this.cancelOngoingEdit();
        }
    }

    private class CommitEditAction
    extends AbstractAction {
        public CommitEditAction() {
            super(ArrayEditPanel.ACTION_COMMIT, RmaDefs.getImageIcon("commit_edit.png"));
            this.putValue("ActionCommandKey", ArrayEditPanel.ACTION_COMMIT);
            this.putValue("ShortDescription", "Commit the value");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayEditPanel.this.commitOngoingEdit();
        }
    }

    public static enum Mode {
        SINGEL,
        SINGLE_SET,
        ENUM,
        ASCENDING_INDEX;

    }
}

