/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.undoredo;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.gui.undoredo.UndoableTree;
import ericsson.ere.gui.ratingrules.nodes.DefaultLinkIdUpdater;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

@Deprecated
public class NodeEdit
extends AbstractUndoableEdit {
    private TreePath myPath;
    private boolean editWasCreate = false;
    private List<Variable> myOldVariables = new Vector<Variable>();
    private int index;
    private List<Variable> myNewVariables;
    private VarTableModel myTableModel;
    private UndoableTree myTree;

    public NodeEdit(UndoableTree tree, Object[] path, int index) {
        this.myPath = new TreePath(path);
        this.index = index;
        this.myTree = tree;
        this.editWasCreate = true;
    }

    public NodeEdit(UndoableTree tree, TreePath path, List<Variable> oldVariables, List<Variable> newVariables, VarTableModel model) {
        this.myOldVariables = VarListUtil.cloneVariableList(oldVariables);
        this.myNewVariables = VarListUtil.cloneVariableList(newVariables);
        this.myPath = path;
        this.myTableModel = model;
        this.myTree = tree;
    }

    @Override
    public void undo() throws CannotUndoException {
        this.myTree.setOngoingUndo(true);
        super.undo();
        if (this.editWasCreate) {
            this.myTree.getTreeModel().delete(this.myPath.getPath());
            TreePath parentPath = this.myPath.getParentPath();
            int nextRowSelection = this.myTree.getRowForPath(parentPath);
            if (nextRowSelection < 0) {
                nextRowSelection = 0;
            }
            TreePath p = this.myTree.getPathForRow(nextRowSelection);
            this.myTree.setSelectionPath(p);
            this.myTree.scrollPathToVisible(p);
            this.myTree.expandPath(parentPath);
            this.myTree.setOngoingUndo(false);
            return;
        }
        if (this.myOldVariables != null) {
            for (int i = 0; i < this.myOldVariables.size(); ++i) {
                BaseVariable oldVariable = (BaseVariable)this.myOldVariables.get(i);
                ((DataItem)this.myPath.getLastPathComponent()).setDataItem(oldVariable.getLabel(), oldVariable);
                oldVariable.setDataItem((DataItem)this.myPath.getLastPathComponent());
            }
            this.myTableModel.setData(VarListUtil.cloneVariableList(this.myOldVariables));
        }
        this.myTree.setSelectionPath(this.myPath);
        this.myTree.scrollPathToVisible(this.myPath);
        this.myTree.setOngoingUndo(false);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.myTree.setOngoingUndo(true);
        super.redo();
        if (this.editWasCreate) {
            TreePath parentPath = this.myPath.getParentPath();
            TariffStructureNode node = (TariffStructureNode)this.myPath.getLastPathComponent();
            if (node instanceof TSLink) {
                node.removeAt(0);
            }
            TariffDAGNode parent = (TariffDAGNode)parentPath.getLastPathComponent();
            this.myTree.getTreeModel().insertChildAt(parent, this.index, node);
            this.myTree.getTreeModel().resolveLink(node, Arrays.asList(parent));
            try {
                DefaultLinkIdUpdater updater = new DefaultLinkIdUpdater(this.myTree.getTreeModel());
                DAGUtil.visitPreorder(this.myTree.getTop(), updater);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.myNewVariables.size(); ++i) {
                BaseVariable newVariable = (BaseVariable)this.myNewVariables.get(i);
                ((DataItem)this.myPath.getLastPathComponent()).setDataItem(newVariable.getLabel(), newVariable);
            }
            this.myTableModel.setData(VarListUtil.cloneVariableList(this.myNewVariables));
        }
        this.myTree.setSelectionPath(this.myPath);
        this.myTree.scrollPathToVisible(this.myPath);
        this.myTree.setOngoingUndo(false);
    }

    public void setNewVariables(List<Variable> newVariables) {
        this.myNewVariables = newVariables;
    }

    public boolean isRedundant() {
        return VarListUtil.equalsVariableList(this.myOldVariables, this.myNewVariables);
    }

    public TariffDAGNode getNode() {
        return (TariffDAGNode)this.myPath.getLastPathComponent();
    }

    public boolean hasVariableBeenChanged(DataItem item, String label) {
        if (item != this.myPath.getLastPathComponent()) {
            return false;
        }
        Variable oldVar = VarListUtil.getVariableForKey(this.myOldVariables, label);
        Variable newVar = VarListUtil.getVariableForKey(this.myNewVariables, label);
        if (oldVar != null && newVar != null) {
            return !oldVar.getValueString().equals(newVar.getValueString());
        }
        return oldVar != null || newVar != null;
    }

    @Override
    public String toString() {
        return this.myOldVariables + "," + this.myNewVariables;
    }
}

