/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.undoredo;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.gui.undoredo.UndoableTree;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.List;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

@Deprecated
public class ChangeNodeEdit
extends AbstractUndoableEdit {
    private TreePath myPath;
    private List<Variable> myOldVariables;
    private List<Variable> myNewVariables;
    private VarTableModel myTableModel;
    private UndoableTree myTree;

    public ChangeNodeEdit(UndoableTree tree, TreePath path, List<Variable> oldVariables, List<Variable> newVariables, VarTableModel model) {
        this.myOldVariables = VarListUtil.cloneVariableList(oldVariables);
        this.myNewVariables = VarListUtil.cloneVariableList(newVariables);
        this.myPath = path;
        this.myTableModel = model;
        this.myTree = tree;
    }

    @Override
    public void undo() throws CannotUndoException {
        this.myTree.setOngoingUndo(true);
        super.undo();
        for (int i = 0; i < this.myOldVariables.size(); ++i) {
            BaseVariable oldVariable = (BaseVariable)this.myOldVariables.get(i);
            ((DataItem)this.myPath.getLastPathComponent()).setDataItem(oldVariable.getLabel(), oldVariable);
            oldVariable.setDataItem((DataItem)this.myPath.getLastPathComponent());
        }
        this.myTableModel.setData(VarListUtil.cloneVariableList(this.myOldVariables));
        this.myTree.setSelectionPath(this.myPath);
        this.myTree.scrollPathToVisible(this.myPath);
        this.myTree.setOngoingUndo(false);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.myTree.setOngoingUndo(true);
        super.redo();
        for (int i = 0; i < this.myNewVariables.size(); ++i) {
            BaseVariable newVariable = (BaseVariable)this.myNewVariables.get(i);
            ((DataItem)this.myPath.getLastPathComponent()).setDataItem(newVariable.getLabel(), newVariable);
        }
        this.myTableModel.setData(VarListUtil.cloneVariableList(this.myNewVariables));
        this.myTree.setSelectionPath(this.myPath);
        this.myTree.scrollPathToVisible(this.myPath);
        this.myTree.setOngoingUndo(false);
    }

    public void setNewVariables(List<Variable> newVariables) {
        this.myNewVariables = newVariables;
    }

    public boolean isRedundant() {
        return VarListUtil.equalsVariableList(this.myOldVariables, this.myNewVariables);
    }

    public TariffDAGNode getNode() {
        return (TariffDAGNode)this.myPath.getLastPathComponent();
    }

    public boolean hasVariableBeenChanged(DataItem item, String label) {
        if (item != this.myPath.getLastPathComponent()) {
            return false;
        }
        Variable oldVar = VarListUtil.getVariableForKey(this.myOldVariables, label);
        Variable newVar = VarListUtil.getVariableForKey(this.myNewVariables, label);
        if (oldVar != null && newVar != null) {
            return !oldVar.getValueString().equals(newVar.getValueString());
        }
        return oldVar != null || newVar != null;
    }

    @Override
    public String toString() {
        return this.myOldVariables + "," + this.myNewVariables;
    }
}

