/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.tree;

import com.ericsson.ere.gui.simulator.tree.TraceTreeNode;
import ericsson.ere.gui.ratingrules.nodes.TariffCellRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TraceTreeRenderer
extends DefaultTreeCellRenderer {
    private String composeTraceTreeNodeLabel(TraceTreeNode traceNode) {
        boolean isExecutedModifier;
        StringBuilder theString = new StringBuilder(traceNode.getLabel());
        if (traceNode.getException() != null) {
            theString.insert(0, "<font color=\"#FF0000\">").append("</font>");
        } else if (!traceNode.isExecuted()) {
            theString.insert(0, "<font color=\"#BFBFBF\">").append("</font>");
        }
        boolean bl = isExecutedModifier = traceNode.getType() == TraceTreeNode.TraceNodeType.MODIFIER && traceNode.isExecuted();
        if (isExecutedModifier) {
            theString.insert(0, "<b>").append("</b>");
        }
        theString.insert(0, "<html><body>").append("</body></html>");
        return theString.toString();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        JLabel theComponent = (JLabel)super.getTreeCellRendererComponent(tree, "", sel, expanded, leaf, row, focus);
        if (value != null) {
            TraceTreeNode traceNode = (TraceTreeNode)value;
            theComponent.setText(this.composeTraceTreeNodeLabel(traceNode));
            if (focus) {
                if (traceNode.getNumberOfTracePoints() > 0) {
                    theComponent.setToolTipText(traceNode.getTooltip());
                } else {
                    theComponent.setToolTipText("<html><body><i>Not executed</i></body></html>");
                }
            } else {
                theComponent.setToolTipText(null);
            }
            theComponent.setEnabled(traceNode.isExecuted());
            theComponent.setIcon(TraceTreeRenderer.getIconForValue(traceNode));
        }
        return theComponent;
    }

    public static Icon getIconForValue(TraceTreeNode node) {
        Icon icon = node.getType() == TraceTreeNode.TraceNodeType.DEFINITION ? TariffCellRenderer.DEFS_NODE_ICON : TariffCellRenderer.ICONS[0][0][node.getType().ordinal()];
        return icon;
    }
}

