/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.tree;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.gui.simulator.tree.TraceTreeNode;
import com.ericsson.ere.trace.TraceNodeCondition;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeInterfaceV2;
import com.ericsson.ere.trace.TraceNodeModifier;
import com.ericsson.ere.trace.TraceNodeStatement;
import com.ericsson.ere.trace.TraceTreeInfo;

public class TraceNodeInterfaceBasedTraceTreeNode
extends TraceTreeNode {
    private TraceNodeInterfaceV2 myTraceNode;

    public TraceNodeInterfaceBasedTraceTreeNode(TraceNodeInterfaceV2 oldTraceNode) {
        this.myTraceNode = oldTraceNode;
        this.myExecuted = this.myTraceNode.getExecuted();
        this.myException = this.myTraceNode.getException();
        this.myLabel = this.myTraceNode.getNodeLabel();
        this.checkType();
        if (this.myTraceNode.getChildren() != null) {
            for (TraceNodeInterface child : this.myTraceNode.getChildren()) {
                this.add(new TraceNodeInterfaceBasedTraceTreeNode((TraceNodeInterfaceV2)child));
            }
        }
    }

    private void checkType() {
        this.myType = this.myTraceNode instanceof TraceNodeCondition ? TraceTreeNode.TraceNodeType.CONDITION : (this.myTraceNode instanceof TraceNodeModifier ? TraceTreeNode.TraceNodeType.MODIFIER : (this.myTraceNode instanceof TraceNodeStatement ? TraceTreeNode.TraceNodeType.STATEMENT : TraceTreeNode.TraceNodeType.TARIFFSTRUCTURE));
    }

    @Override
    public String getTraceString(int index) {
        return this.myTraceNode.getTraceInfo(index);
    }

    @Override
    public String getFullTrace(DataSet pre, DataSet post) {
        TraceTreeInfo info = new TraceTreeInfo(null, pre, post);
        return info.getTraceAsString(0);
    }

    @Override
    public int getNumberOfTracePoints() {
        return this.myTraceNode.getNumberOfTracePoints();
    }

    @Override
    public String getTooltip() {
        return "<html><body>" + this.myLabel + ", number of executions: " + this.getNumberOfTracePoints() + "</html></body>";
    }
}

