/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.testgenerator;

import com.ericsson.ere.gui.simulator.SimulationCaseSelectedFields;
import com.ericsson.ere.gui.simulator.SimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.SimulationField;
import com.ericsson.ere.gui.simulator.SimulationSet;
import com.ericsson.ere.gui.simulator.SimulatorPanel;
import com.ericsson.ere.gui.simulator.testgenerator.GenerationDataModel;
import com.ericsson.ere.gui.simulator.testgenerator.GenerationPathGotoModifier;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionExtendedInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationDefs;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationModifierInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationNamingPanel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationProgressPanel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationWizardOptions;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.selectiontree.conditions.logic.CompoundBooleanConditionProfile;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public class TestCaseGenerator {
    TestCaseGenerationProgressPanel myProgressPanel;
    private TestCaseGenerationWizardOptions myWizardOptions;
    private SimulatorPanel mySimPanel;
    private HashMap<String, List<Integer>> mySimFieldsIndexMap;
    private int myTitleColumnIndex;
    private String myTestCaseName;
    private GenerationDataModel myModel;
    private HashMap<TSCondition, List<Integer>> myFaultyConditionRowsInModel;

    public TestCaseGenerator(TestCaseGenerationProgressPanel progressPanel, TestCaseGenerationWizardOptions wizardOptions) {
        this.myProgressPanel = progressPanel;
        this.myWizardOptions = wizardOptions;
        this.mySimPanel = this.myWizardOptions.mySimPanel;
    }

    public void generate() throws Exception {
        this.myTestCaseName = TestCaseGenerationNamingPanel.getTestCaseName(this.myWizardOptions.myModifierPath[0], this.myWizardOptions.myNamingSettings);
        SimulationDataPanel simCasePanel = this.myWizardOptions.myDefaultPanel;
        List<SimulationField> simFieldsList = simCasePanel.getSimulationDataVariables();
        this.mySimFieldsIndexMap = this.getFieldsIndexMap(simFieldsList);
        Object[] simCaseData = SimulationDataTableModel.getPanelData(simCasePanel);
        this.myWizardOptions.myCurrentSimSet = new SimulationSet(this.myWizardOptions.myNamingSettings.simulationSetName, this.mySimPanel, false);
        SimulationDataTableModel model = new SimulationDataTableModel(this.mySimPanel.getSimulationFactory(), this.mySimPanel.getServiceAndContext(), this.myWizardOptions.myCurrentSimSet);
        SimulationCaseSelectedFields defaultSelection = new SimulationCaseSelectedFields(simCasePanel);
        simCaseData = model.addSpecialFields(simCaseData, defaultSelection);
        model.addRow(simCaseData);
        this.myModel = new GenerationDataModel(model.getDataVector(), this.myWizardOptions);
        this.myFaultyConditionRowsInModel = new HashMap();
        this.myTitleColumnIndex = model.getColumnForName(model.getTitleColumn(), true);
        this.analyzeNode((TSNode)this.myWizardOptions.myModifierPath[0].getPath()[1]);
        for (int i = 0; i < this.myModel.getRowCount(); ++i) {
            this.myModel.setValueAt(this.myTestCaseName + " " + (i + 1), i, this.myTitleColumnIndex);
        }
        model.setDataVector(this.myModel.getData(), model.getColumnIdentifiers());
        this.myWizardOptions.myCurrentSimSet.setModel(model);
        this.myProgressPanel.setGenerationFinished();
    }

    private TariffDAGNode getNextNodeInPath(TreePath treePath, TariffDAGNode node) {
        Object[] path = treePath.getPath();
        for (int i = 0; i < path.length - 1; ++i) {
            if (path[i] != node) continue;
            TariffDAGNode nextNode = (TariffDAGNode)path[i + 1];
            if (nextNode instanceof TSLink) {
                return (TariffDAGNode)nextNode.getChildAt(0);
            }
            return nextNode;
        }
        return null;
    }

    private void analyzeNode(TariffDAGNode node) throws Exception {
        ArrayList<TSCondition> conditions = new ArrayList<TSCondition>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChildAt(i) instanceof TSCondition) {
                conditions.add((TSCondition)node.getChildAt(i));
                continue;
            }
            if (!(node.getChildAt(i) instanceof TSLink) || ((TSLink)node.getChildAt(i)).getNodeType() != 2) continue;
            conditions.add((TSCondition)((TSLink)node.getChildAt(i)).getChildAt(0));
        }
        for (int con = 0; con < conditions.size(); ++con) {
            TSCondition condition = (TSCondition)conditions.get(con);
            if (TestCaseGenerator.isCompoundBooleanCondition(condition)) {
                this.analyzeNode(condition);
            } else {
                this.analyzeCondition(condition);
            }
            if (this.myProgressPanel == null) continue;
            this.myProgressPanel.setProgress(this.myModel.getRowCount());
        }
        if (!this.myWizardOptions.mySingleTestCase) {
            ArrayList<List<Integer>> faultyConditionRows = new ArrayList<List<Integer>>(conditions.size());
            for (TSCondition condition : conditions) {
                List<Integer> rows = this.myFaultyConditionRowsInModel.get(condition);
                if (rows == null) continue;
                faultyConditionRows.add(rows);
            }
            BooleanOperation operation = TestCaseGenerator.isCompoundBooleanCondition(node) ? TestCaseGenerator.getBooleanOperation((TSCondition)node) : BooleanOperation.OR;
            List<Integer> makesNodeEvaluateFalse = this.mergeFaultyRows(faultyConditionRows, operation);
            for (TSCondition condition : conditions) {
                this.myFaultyConditionRowsInModel.remove(condition);
            }
            if (TestCaseGenerator.isCompoundBooleanCondition(node)) {
                this.myFaultyConditionRowsInModel.put((TSCondition)node, makesNodeEvaluateFalse);
            } else if (!this.myWizardOptions.mySingleTestCase && node instanceof TSNode) {
                Collections.sort(makesNodeEvaluateFalse);
                for (int i = 0; i < makesNodeEvaluateFalse.size(); ++i) {
                    this.myModel.removeRow(makesNodeEvaluateFalse.get(i) - i);
                }
                if (this.myProgressPanel != null) {
                    this.myProgressPanel.setProgress(this.myModel.getRowCount());
                }
            }
        }
        if (!TestCaseGenerator.isCompoundBooleanCondition(node)) {
            TariffDAGNode nextNode = this.getNextNodeInPath(this.myWizardOptions.myModifierPath[0], node);
            if (nextNode instanceof TSNode || nextNode instanceof GenerationPathGotoModifier || nextNode instanceof TSTariffStructure) {
                this.analyzeNode(nextNode);
            } else if (nextNode instanceof TSModifier && TestCaseGenerator.supportsTestCaseGeneration(nextNode)) {
                this.analyzeModifier((TSModifier)nextNode);
            }
        }
    }

    private void analyzeCondition(TSCondition condition) {
        Map<String, Object> faultyValues;
        Iterator<String> faultyValuesIterator;
        if (!TestCaseGenerator.supportsTestCaseGeneration(condition)) {
            return;
        }
        if (TestCaseGenerator.isInversed(condition)) {
            return;
        }
        GenerationDataModel faultyModel = this.myModel.cloneModel();
        Map<String, Object> testCaseFieldInformation = this.myWizardOptions.mySingleTestCase ? this.myWizardOptions.myConditionSingleTestCaseFieldInformation.get(condition) : this.myWizardOptions.myConditionTestCaseFieldInformation.get(condition);
        for (String field : testCaseFieldInformation.keySet()) {
            Object value = testCaseFieldInformation.get(field);
            Object[] values = value.getClass().isArray() ? (Object[])value : new Object[]{value};
            int initialModelSize = this.myModel.getRowCount();
            this.myModel = this.combineValues(this.myModel, field, values, condition);
            if (this.myWizardOptions.mySingleTestCase) continue;
            HashMap faultyConditionRows = new HashMap(this.myFaultyConditionRowsInModel.size());
            for (TSCondition c : this.myFaultyConditionRowsInModel.keySet()) {
                ArrayList<Integer> rows = new ArrayList<Integer>(this.myFaultyConditionRowsInModel.get(c).size() * values.length);
                for (Integer row : this.myFaultyConditionRowsInModel.get(c)) {
                    for (int i = 0; i <= values.length; ++i) {
                        rows.add(row + i * initialModelSize);
                    }
                }
                faultyConditionRows.put(c, rows);
            }
            this.myFaultyConditionRowsInModel = faultyConditionRows;
        }
        if (!this.myWizardOptions.mySingleTestCase && (faultyValuesIterator = (faultyValues = this.myWizardOptions.myFaultyTestCaseFieldInformation.get(condition)).keySet().iterator()).hasNext()) {
            String fieldName = faultyValuesIterator.next();
            faultyModel = this.combineValues(faultyModel, fieldName, new Object[]{faultyValues.get(fieldName)}, condition);
            ArrayList<Integer> faultyRows = new ArrayList<Integer>();
            int start = this.myModel.getRowCount();
            int end = start + faultyModel.getRowCount();
            for (int i = start; i < end; ++i) {
                faultyRows.add(i);
            }
            this.myFaultyConditionRowsInModel.put(condition, faultyRows);
            this.myModel = GenerationDataModel.mergeModels(new GenerationDataModel[]{this.myModel, faultyModel});
        }
    }

    private void analyzeModifier(TSModifier modifier) {
        Map<String, Object> values = this.myWizardOptions.myModifierTestCaseFieldInformation.get(modifier);
        for (String fieldName : values.keySet()) {
            if (this.myWizardOptions.mySelectedValidationFields.get(fieldName) == null || !this.myWizardOptions.mySelectedValidationFields.get(fieldName).booleanValue()) continue;
            this.combineValues(this.myModel, fieldName, new Object[]{values.get(fieldName)}, modifier);
        }
    }

    private GenerationDataModel combineValues(GenerationDataModel model, String fieldName, Object[] values, TariffDAGNode theNode) {
        List<Integer> fieldIndexes = this.mySimFieldsIndexMap.get(fieldName);
        if (values.length == 1) {
            for (int row = 0; row < model.getRowCount(); ++row) {
                SimulationCaseSelectedFields selectedFields = new SimulationCaseSelectedFields((String)model.getValueAt(row, SimulationDataTableModel.INDEX_OF_SELECTED));
                for (Integer fieldIndex : fieldIndexes) {
                    if (values[0] != TestCaseGenerationDefs.USE_SIMULATION_FIELD && values[0] != TestCaseGenerationDefs.DONT_USE_SIMULATION_FIELD) {
                        if (TestCaseGenerator.supportsExtendedTestCaseGeneration(theNode)) {
                            ((TestCaseGenerationConditionExtendedInterface)((Object)((TSCondition)theNode).getConditionProfile())).combineFieldValues(model, values[0], row, fieldIndex);
                        } else {
                            model.setValueAt(values[0], row, fieldIndex);
                        }
                        selectedFields.setFieldSelected(fieldIndex - SimulationDataTableModel.SPECIAL_FIELDS.length, true);
                    } else if (values[0] == TestCaseGenerationDefs.DONT_USE_SIMULATION_FIELD) {
                        selectedFields.setFieldSelected(fieldIndex - SimulationDataTableModel.SPECIAL_FIELDS.length, false);
                    } else if (values[0] == TestCaseGenerationDefs.USE_SIMULATION_FIELD) {
                        selectedFields.setFieldSelected(fieldIndex - SimulationDataTableModel.SPECIAL_FIELDS.length, true);
                    }
                    model.setValueAt(selectedFields.getFieldsString(), row, SimulationDataTableModel.INDEX_OF_SELECTED);
                }
            }
        } else {
            int interval = model.getRowCount();
            model = model.cloneModel(values.length, true).get(0);
            for (int val = 0; val < values.length; ++val) {
                for (int row = val * interval; row < interval * val + interval; ++row) {
                    SimulationCaseSelectedFields selectedFields = new SimulationCaseSelectedFields((String)model.getValueAt(row, SimulationDataTableModel.INDEX_OF_SELECTED));
                    for (Integer fieldIndex : fieldIndexes) {
                        if (theNode instanceof TSCondition && ((TSCondition)theNode).getConditionProfile() instanceof TestCaseGenerationConditionExtendedInterface) {
                            ((TestCaseGenerationConditionExtendedInterface)((Object)((TSCondition)theNode).getConditionProfile())).combineFieldValues(model, values[val], row, fieldIndex);
                        } else {
                            model.setValueAt(values[val], row, fieldIndex);
                        }
                        selectedFields.setFieldSelected(fieldIndex - SimulationDataTableModel.SPECIAL_FIELDS.length, true);
                        model.setValueAt(selectedFields.getFieldsString(), row, SimulationDataTableModel.INDEX_OF_SELECTED);
                    }
                }
            }
        }
        return model;
    }

    private HashMap<String, List<Integer>> getFieldsIndexMap(List<SimulationField> fields) {
        HashMap<String, List<Integer>> fieldsIndexMap = new HashMap<String, List<Integer>>();
        for (int i = 0; i < fields.size(); ++i) {
            String name = fields.get(i).getName();
            if (name.contains("%")) {
                name = name.substring(name.indexOf("%") + 1, name.length());
            } else if (name.endsWith(" (IN)")) {
                name = name.substring(0, name.indexOf(" (IN)"));
            } else if (name.endsWith(" (OUT)")) {
                name = name.substring(0, name.indexOf(" (OUT)"));
            }
            List<Integer> indexList = fieldsIndexMap.get(name);
            if (indexList == null) {
                indexList = new ArrayList<Integer>();
            }
            indexList.add(i + SimulationDataTableModel.SPECIAL_FIELDS.length);
            fieldsIndexMap.put(name, indexList);
        }
        return fieldsIndexMap;
    }

    private List<Integer> mergeFaultyRows(List<List<Integer>> faultyConditionRows, BooleanOperation booleanOperation) {
        ArrayList<Integer> makesConditionEvaluateFalse = new ArrayList<Integer>();
        for (int i = 0; i < faultyConditionRows.size(); ++i) {
            List<Integer> rows = faultyConditionRows.get(i);
            for (Integer row : rows) {
                boolean faultyInAllConditions = true;
                for (int j = 0; j < faultyConditionRows.size(); ++j) {
                    if (faultyConditionRows.get(j) == faultyConditionRows.get(i) || faultyConditionRows.get(j).contains(row)) continue;
                    faultyInAllConditions = false;
                }
                if ((booleanOperation != BooleanOperation.OR || !faultyInAllConditions) && booleanOperation != BooleanOperation.AND || makesConditionEvaluateFalse.contains(row)) continue;
                makesConditionEvaluateFalse.add(row);
            }
        }
        return makesConditionEvaluateFalse;
    }

    static boolean supportsTestCaseGeneration(TariffDAGNode node) {
        return node instanceof TSCondition && ((TSCondition)node).getConditionProfile() instanceof TestCaseGenerationConditionInterface || node instanceof TSModifier && ((TSModifier)node).getProfile() instanceof TestCaseGenerationModifierInterface;
    }

    static boolean supportsExtendedTestCaseGeneration(TariffDAGNode node) {
        return node instanceof TSCondition && ((TSCondition)node).getConditionProfile() instanceof TestCaseGenerationConditionExtendedInterface;
    }

    static boolean isCompoundBooleanCondition(TariffDAGNode node) {
        return node instanceof TSCondition && ((TSCondition)node).getConditionProfile() instanceof CompoundBooleanConditionProfile;
    }

    static boolean isConditionLink(TariffDAGNode node) {
        return node instanceof TSLink && ((TSLink)node).getNodeType() == 2;
    }

    static boolean isNodeLink(TariffDAGNode node) {
        return node instanceof TSLink && ((TSLink)node).getNodeType() == 1;
    }

    static BooleanOperation getBooleanOperation(TSCondition compoundBooleanCondition) {
        BooleanOperation operation = BooleanOperation.OR;
        try {
            Element conditionSettings = XMLUtil.buildDocumentFromString(compoundBooleanCondition.getXMLConfig()).getDocumentElement();
            List<Variable> variables = ((CompoundBooleanConditionProfile)compoundBooleanCondition.getConditionProfile()).getVariables(conditionSettings);
            String operator = VarListUtil.getValueStringForName(variables, "Operation");
            if (operator.equals(CompoundBooleanConditionProfile.OPERATORS[0])) {
                operation = BooleanOperation.AND;
            } else if (operator.equals(CompoundBooleanConditionProfile.OPERATORS[1])) {
                operation = BooleanOperation.OR;
            } else if (operator.equals(CompoundBooleanConditionProfile.OPERATORS[2])) {
                operation = BooleanOperation.NOT;
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "generation", 2, "Failure in test case generator wizard!", true);
        }
        return operation;
    }

    static boolean isInversed(TSCondition condition) {
        TariffDAGNode parent = (TariffDAGNode)condition.getParent();
        if (parent instanceof TSNode) {
            List<Variable> variables = parent.getVariablesForEditing(null);
            Boolean invertedValue = VarListUtil.getBooleanValueForName(variables, "Inverted");
            return invertedValue != null && invertedValue != false;
        }
        if (TestCaseGenerator.isCompoundBooleanCondition(parent)) {
            if (TestCaseGenerator.getBooleanOperation((TSCondition)parent) == BooleanOperation.NOT) {
                return true;
            }
            return TestCaseGenerator.isInversed((TSCondition)parent);
        }
        return false;
    }

    static enum BooleanOperation {
        AND,
        OR,
        NOT;

    }
}

