/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.testgenerator;

import com.ericsson.ere.gui.simulator.testgenerator.NodeConfigurationPanel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationDefs;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationModifierInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationSetupPanel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationWizardOptions;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.ConditionProfile;
import ericsson.ere.interfaces.ModifierProfile;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class GenerationPathTree
extends JTree
implements TreeSelectionListener {
    private VarTable2 myTable;
    private VarTableModel myTableModel;
    private TestCaseGenerationSetupPanel myParentPanel;
    private TariffDAGModel myTreeModel;
    private TestCaseGenerationWizardOptions myWizardOptions;

    public GenerationPathTree(TestCaseGenerationSetupPanel panel, TSTariffStructure rootNode, NodeConfigurationPanel configPanel, TestCaseGenerationWizardOptions wizardOptions) {
        this.myWizardOptions = wizardOptions;
        this.myParentPanel = panel;
        this.myTable = configPanel.getTable();
        this.myTableModel = this.myTable.getTableModel();
        this.myTreeModel = new TariffDAGModel(this, rootNode);
        this.setModel(this.myTreeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addTreeSelectionListener(this);
    }

    TariffDAGModel getTreeModel() {
        return this.myTreeModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selectedPath = this.getSelectionPath();
        if (selectedPath != null && selectedPath.getLastPathComponent() != null) {
            TariffDAGNode selectedNode = (TariffDAGNode)selectedPath.getLastPathComponent();
            if (selectedNode instanceof TSCondition) {
                ConditionProfile selectedProfile = ((TSCondition)selectedNode).getConditionProfile();
                if (selectedProfile instanceof TestCaseGenerationConditionInterface) {
                    List<Variable> varList = ((TestCaseGenerationConditionInterface)((Object)selectedProfile)).getTestVariables(TestCaseGenerationSetupPanel.getVariableValueForNode((TSCondition)selectedNode), this.myParentPanel.getTestSettingsForElement(selectedNode));
                    if (varList == null) {
                        varList = TestCaseGenerationDefs.getDefaultTestVariables();
                    }
                    for (int i = 0; i < varList.size(); ++i) {
                        varList.get(i).setDataItem(this.myParentPanel);
                    }
                    this.myTable.useSelectable(false);
                    this.myTableModel.setData(varList);
                } else {
                    this.myTableModel.setData(new ArrayList<Variable>(1));
                }
            } else if (selectedNode instanceof TSModifier) {
                ModifierProfile selectedProfile = ((TSModifier)selectedNode).getProfile();
                if (selectedProfile instanceof TestCaseGenerationModifierInterface) {
                    int i;
                    List<Variable> varList = ((TestCaseGenerationModifierInterface)((Object)selectedProfile)).getTestVariables(this.myWizardOptions.myElementConfigXML.get(selectedNode), this.myParentPanel.getTestSettingsForElement(selectedNode));
                    for (i = 0; i < varList.size(); ++i) {
                        varList.get(i).setDataItem(this.myParentPanel);
                    }
                    for (i = 0; i < varList.size(); ++i) {
                        varList.get(i).addSelectedActionListener(this.myParentPanel);
                    }
                    if (((TestCaseGenerationModifierInterface)((Object)selectedProfile)).isManualValidationPossible(this.myWizardOptions.myElementConfigXML.get(selectedNode))) {
                        this.myTable.useSelectable(true);
                        for (Variable var : varList) {
                            Boolean selected = this.myWizardOptions.mySelectedValidationFields.get(var.getLabel());
                            if (selected != null && !selected.booleanValue()) continue;
                            var.setSelected(true);
                        }
                    } else {
                        this.myTable.useSelectable(false);
                    }
                    this.myTableModel.setData(varList);
                } else {
                    this.myTableModel.setData(new ArrayList<Variable>(1));
                }
            } else {
                this.myTableModel.setData(new ArrayList<Variable>(1));
            }
            this.myParentPanel.updateTestCount();
        }
    }
}

