/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.search;

import com.ericsson.ere.gui.simulator.SimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.SimulationSet;
import com.ericsson.ere.gui.simulator.SimulatorPanel;
import com.ericsson.ere.gui.simulator.input.db.DatabaseAccess;
import com.ericsson.ere.gui.simulator.input.db.DatabaseConfig;
import com.ericsson.ere.gui.simulator.input.db.DatabaseSimulationSource;
import com.ericsson.ere.gui.simulator.search.QueryBuilder;
import com.ericsson.ere.gui.simulator.search.QueryWriter;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.FrameOpener;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class SQLSimulationTool
extends RmaFrameSupport {
    private static final String RESULT_LABEL_TEXT = "Found simulation cases: ";
    private DatabaseSimulationSource mySimulationDataSource;
    private SimulationDataTableModel mySimulationDataTableModel;
    private static final String FIELD_TYPE_COMMON = "Common";
    private static final String FIELD_TYPE_INPUT = "Input";
    private static final String FIELD_TYPE_OUTPUT = "Output";
    String[] FIELD_TYPES = new String[]{"Common", "Input", "Output"};
    private List<Variable> myCommonVariables;
    private List<Variable> myInputVariables;
    private List<Variable> myOutputVariables;
    HashMap<String, List<Variable>> myVariableSections = new HashMap();
    private SimulatorPanel mySimulatorPanel;
    private QueryBuilder mySqlBuilderPanel;
    private QueryWriter mySqlWriterPanel;
    private JTabbedPane myTabbedPane;
    private JButton myCreateSimSetButton;
    private JLabel myResultCounterLable;
    private ResultSet myLatestResultSet = null;
    private int myNumberOfCases = 0;

    public SQLSimulationTool(SimulationDataTableModel simulationDataTableModel, SimulatorPanel aSimPanel) {
        this.mySimulatorPanel = aSimPanel;
        this.mySimulationDataTableModel = simulationDataTableModel;
        this.init();
    }

    public SQLSimulationTool(DatabaseSimulationSource simulationDataSource, SimulationDataTableModel simulationDataTableModel, SimulatorPanel aSimPanel) {
        this.mySimulatorPanel = aSimPanel;
        this.mySimulationDataSource = simulationDataSource;
        this.mySimulationDataTableModel = simulationDataTableModel;
        this.init();
    }

    private void init() {
        SimulationDataPanel temp = this.mySimulationDataTableModel.getTemporarySimulationDataPanel();
        this.myCommonVariables = temp.getCommonParameters();
        this.myInputVariables = temp.getInputParameters();
        this.myOutputVariables = temp.getOutputParameters();
        this.myVariableSections.put(FIELD_TYPE_COMMON, this.myCommonVariables);
        this.myVariableSections.put(FIELD_TYPE_INPUT, this.myInputVariables);
        this.myVariableSections.put(FIELD_TYPE_OUTPUT, this.myOutputVariables);
        this.initComponents();
        this.setTitle("SQL Tool");
        this.setFrameIcon(RmaDefs.getImageIcon("data_find16.png"));
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setSize(530, 300);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        new FrameOpener(this).open();
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
    }

    private Map<String, String> createFieldNameColumnNameMapping() {
        List<String> myColumnNameList;
        List<String> myRealColumnNameList;
        DatabaseConfig currentDatabaseConfig = this.mySimulationDataSource.getCurrentDatabaseConfig();
        try {
            myRealColumnNameList = DatabaseAccess.getTableColumns(currentDatabaseConfig, currentDatabaseConfig.get("Table"), true);
            myColumnNameList = DatabaseAccess.getTableColumns(currentDatabaseConfig, currentDatabaseConfig.get("Table"), false);
        }
        catch (Exception e) {
            Logger.getLogger("rma").warning(e.getMessage());
            myRealColumnNameList = new ArrayList<String>();
            myColumnNameList = new ArrayList<String>();
        }
        HashMap<String, String> fieldColumnMap = new HashMap<String, String>();
        for (int i = 0; i < myColumnNameList.size(); ++i) {
            fieldColumnMap.put(myRealColumnNameList.get(i), myColumnNameList.get(i));
        }
        return fieldColumnMap;
    }

    private void initComponents() {
        this.mySqlBuilderPanel = new QueryBuilder(this.myVariableSections, this.mySimulatorPanel.getClassRepository(), this.createFieldNameColumnNameMapping(), this.fetchNameOfSelectedTable(this.mySimulationDataSource.getCurrentDatabaseConfig()));
        this.mySqlWriterPanel = new QueryWriter(this.mySqlBuilderPanel, this.mySimulationDataSource);
        this.myTabbedPane = new JTabbedPane();
        this.myTabbedPane.addTab("Query Builder", this.mySqlBuilderPanel);
        this.myTabbedPane.addTab("Query Writer", this.mySqlWriterPanel);
        JButton closeButton = new JButton("Close", RmaDefs.getImageIcon("door2_16.png"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SQLSimulationTool.this.setClosed(true);
                }
                catch (Exception ex) {
                    SQLSimulationTool.this.dispose();
                }
            }
        });
        JButton executeButton = new JButton("Execute query", RmaDefs.getImageIcon("data_find16.png"));
        executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLSimulationTool.this.execute();
            }
        });
        this.myResultCounterLable = new JLabel("Found simulation cases: -");
        this.myCreateSimSetButton = new JButton("Create simulation set");
        this.myCreateSimSetButton.setEnabled(false);
        this.myCreateSimSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DatabaseConfig config = SQLSimulationTool.this.mySimulationDataSource.getCurrentDatabaseConfig();
                    SimulationSet newSimSet = new SimulationSet(config.get("Table"), SQLSimulationTool.this.mySimulatorPanel, false);
                    newSimSet.switchDataSourceAction(null);
                    ((DatabaseSimulationSource)newSimSet.getDataSource()).setSelectedTable(config);
                    ((DatabaseSimulationSource)newSimSet.getDataSource()).loadResultSet(config, SQLSimulationTool.this.myLatestResultSet);
                    SQLSimulationTool.this.myLatestResultSet = null;
                    SQLSimulationTool.this.myNumberOfCases = 0;
                    SQLSimulationTool.this.myResultCounterLable.setText("Found simulation cases: 0");
                    SQLSimulationTool.this.myCreateSimSetButton.setEnabled(false);
                    SQLSimulationTool.this.mySimulatorPanel.addSimulationSet(newSimSet);
                    SQLSimulationTool.this.mySimulatorPanel.selectLastSet();
                }
                catch (Exception e1) {
                    DialogFactory.getErrorDialog("SQL Tool", "There was a problem when creating the simulation set\n" + e1.getMessage());
                }
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.myTabbedPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 0, 8), 0, 0));
        this.getContentPane().add((Component)this.myResultCounterLable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(8, 8, 8, 8), 0, 0));
        this.getContentPane().add((Component)this.myCreateSimSetButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 8, 0, 8), 0, 0));
        this.getContentPane().add((Component)closeButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(8, 8, 8, 8), 0, 0));
        this.getContentPane().add((Component)executeButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
    }

    private String fetchNameOfSelectedTable(DatabaseConfig currentDatabaseConfig) {
        return currentDatabaseConfig.get("Table");
    }

    private void execute() {
        try {
            String sql = "";
            if (this.myTabbedPane.getSelectedComponent() == this.mySqlBuilderPanel) {
                sql = this.mySqlBuilderPanel.buildAndReturnSQLQuery();
            } else if (this.myTabbedPane.getSelectedComponent() == this.mySqlWriterPanel) {
                sql = this.mySqlWriterPanel.getQuery();
            }
            this.myLatestResultSet = DatabaseAccess.executeQuery(this.mySimulationDataSource.getCurrentDatabaseConfig(), sql);
            if (this.myLatestResultSet != null) {
                this.myLatestResultSet.last();
                this.myNumberOfCases = this.myLatestResultSet.getRow();
                this.myLatestResultSet.beforeFirst();
            } else {
                this.myNumberOfCases = 0;
            }
            if (this.myNumberOfCases > 0) {
                this.myResultCounterLable.setText(RESULT_LABEL_TEXT + this.myNumberOfCases);
                this.myCreateSimSetButton.setEnabled(true);
            } else {
                this.myResultCounterLable.setText("Found simulation cases: 0");
                this.myCreateSimSetButton.setEnabled(false);
            }
        }
        catch (Exception ex) {
            DialogFactory.getErrorDialog("SQL Tool", "The query couldn't be executed!\n" + ex.getMessage());
        }
    }
}

