/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.search;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class FieldChooserTool
extends JDialog
implements TableModelListener {
    private DefaultTableModel myHeaderModel;
    private HashMap<String, Boolean> myCompleteModel;
    private JTextField myFilterTextField;
    private String myTitleColumn;
    private TableModelListener myAdditionalTableModelListener = null;

    public FieldChooserTool(List<String> columns, String titleColumn, String windowTitle, String describingText, String firstColumnName) {
        super(GuiServiceCenter.getInstance().getMainWindow(), windowTitle, true);
        this.setLayout(new GridBagLayout());
        this.setIconImage(RmaDefs.getImageIcon("column_preferences16.png").getImage());
        this.myTitleColumn = titleColumn;
        this.myHeaderModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 1) {
                    return false;
                }
                return !((String)FieldChooserTool.this.myHeaderModel.getValueAt(row, 1)).equals(FieldChooserTool.this.myTitleColumn);
            }
        };
        this.myHeaderModel.addColumn(firstColumnName);
        this.myHeaderModel.addColumn("Name");
        this.myCompleteModel = new HashMap();
        for (String column : columns) {
            if (column.equals(this.myTitleColumn)) {
                this.myCompleteModel.put(column, true);
                continue;
            }
            this.myCompleteModel.put(column, false);
        }
        JLabel columnsLabel = new JLabel(describingText);
        JTable columnsList = new JTable(this.myHeaderModel);
        columnsList.getTableHeader().setReorderingAllowed(false);
        JScrollPane columnsScrollPane = new JScrollPane(columnsList);
        columnsList.getColumn(firstColumnName).setMaxWidth(45);
        columnsList.getColumn(firstColumnName).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        columnsList.getColumn(firstColumnName).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected((Boolean)value);
                if (((String)FieldChooserTool.this.myHeaderModel.getValueAt(row, 1)).equals(FieldChooserTool.this.myTitleColumn)) {
                    checkBox.setEnabled(false);
                }
                return checkBox;
            }
        });
        this.myFilterTextField = new JTextField();
        this.fillListModel();
        this.myHeaderModel.addTableModelListener(this);
        JLabel filterLabel = new JLabel("Search");
        this.myFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FieldChooserTool.this.fillListModel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FieldChooserTool.this.fillListModel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FieldChooserTool.this.fillListModel();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.setIcon(RmaDefs.getImageIcon("door2_16.png"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldChooserTool.this.setVisible(false);
            }
        });
        this.add((Component)columnsLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.add((Component)filterLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 8, 8), 0, 0));
        this.add((Component)this.myFilterTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.add((Component)columnsScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.add((Component)closeButton, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(8, 8, 8, 8), 0, 0));
        this.setSize(new Dimension(300, 300));
        this.setLocationRelativeTo(GuiServiceCenter.getInstance().getMainWindow());
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.fillListModel();
        }
        super.setVisible(b);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            String name = (String)this.myHeaderModel.getValueAt(row, 1);
            boolean value = (Boolean)this.myHeaderModel.getValueAt(row, 0);
            if (value) {
                this.myCompleteModel.put(name, value);
            } else {
                this.myCompleteModel.put(name, value);
            }
        }
    }

    private void fillListModel() {
        String filterString = this.myFilterTextField.getText();
        if (filterString.contains("*")) {
            filterString = filterString.replaceAll("\\*", ".*");
        }
        filterString = ".*" + filterString + ".*";
        ArrayList<String> filteredColumns = new ArrayList<String>();
        for (String column : this.myCompleteModel.keySet()) {
            if (!column.toUpperCase().matches(filterString.toUpperCase())) continue;
            filteredColumns.add(column);
        }
        List<String> selectedFields = this.getSelectedFields();
        List<String> deselectedFields = this.getDeselectedFields();
        Collections.sort(selectedFields);
        Collections.sort(deselectedFields);
        this.myHeaderModel.removeTableModelListener(this);
        if (this.myAdditionalTableModelListener != null) {
            this.myHeaderModel.removeTableModelListener(this.myAdditionalTableModelListener);
        }
        while (this.myHeaderModel.getRowCount() > 0) {
            this.myHeaderModel.removeRow(0);
        }
        for (String column : selectedFields) {
            if (!filteredColumns.contains(column)) continue;
            this.myHeaderModel.addRow(new Object[]{true, column});
        }
        for (String column : deselectedFields) {
            if (!filteredColumns.contains(column)) continue;
            this.myHeaderModel.addRow(new Object[]{false, column});
        }
        this.myHeaderModel.addTableModelListener(this);
        if (this.myAdditionalTableModelListener != null) {
            this.myHeaderModel.addTableModelListener(this.myAdditionalTableModelListener);
        }
    }

    private List<String> getSelectedFields() {
        ArrayList<String> selectedFields = new ArrayList<String>();
        for (String column : this.myCompleteModel.keySet()) {
            if (!this.myCompleteModel.get(column).booleanValue()) continue;
            selectedFields.add(column);
        }
        return selectedFields;
    }

    public List<String> getDeselectedFields() {
        ArrayList<String> deselectedFields = new ArrayList<String>();
        for (String column : this.myCompleteModel.keySet()) {
            if (this.myCompleteModel.get(column).booleanValue()) continue;
            deselectedFields.add(column);
        }
        return deselectedFields;
    }

    public void setNewData(List<String> newColumns) {
        HashMap<String, Boolean> newModel = new HashMap<String, Boolean>();
        for (String column : newColumns) {
            Boolean selected = this.myCompleteModel.get(column);
            if (selected != null) {
                newModel.put(column, selected);
                continue;
            }
            newModel.put(column, false);
        }
        this.myCompleteModel = newModel;
    }

    public void setAdditionalTableModelListener(TableModelListener newListener) {
        this.myAdditionalTableModelListener = newListener;
        this.myHeaderModel.addTableModelListener(this.myAdditionalTableModelListener);
    }

    public String getNameOnFieldOnRow(int row) {
        return (String)this.myHeaderModel.getValueAt(row, 1);
    }

    public Boolean getSelectedOnFieldOnRow(int row) {
        return (Boolean)this.myHeaderModel.getValueAt(row, 0);
    }

    public DefaultTableModel getTableModel() {
        return this.myHeaderModel;
    }
}

