/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.jump.JumpContext;
import com.ericsson.ere.dataset.jump.JumperSupport;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.simulator.CreateSimulationSetDialog;
import com.ericsson.ere.gui.simulator.RenameSimulationSetDialog;
import com.ericsson.ere.gui.simulator.SimulationDataTable;
import com.ericsson.ere.gui.simulator.SimulationExecutionEvent;
import com.ericsson.ere.gui.simulator.SimulationExecutionListener;
import com.ericsson.ere.gui.simulator.SimulationFactory;
import com.ericsson.ere.gui.simulator.SimulationSet;
import com.ericsson.ere.gui.simulator.SimulatorPanelInterface;
import com.ericsson.ere.gui.simulator.SimulatorTreeOwner;
import com.ericsson.ere.gui.simulator.input.FileSimulationSource;
import com.ericsson.ere.gui.simulator.tree.TraceTreeGUI;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.FileUtil;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.ServiceCache;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.trace.TraceTreeInfo;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.help.HelpSystem;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.RmaAction;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.ere.xml.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;

public class SimulatorPanel
extends JPanel
implements SimulatorPanelInterface,
ListSelectionListener,
ChangeListener,
DropTargetListener {
    static final Color BG_COLOR_FAILED = Color.RED;
    static final Color BG_COLOR_ERROR = Color.RED.darker();
    static final Color FG_COLOR_FAILED = Color.RED.brighter();
    static final Color FG_COLOR_ERROR = Color.RED;
    private ContextAwareServiceContainer myServiceContainer;
    private JTextArea myTraceDestination;
    private SimulatorTreeOwner myTreeOwner;
    private SimulationFactory mySimulationFactory;
    private TraceTreeInfo myTraceTreeInfo;
    private TraceTreeGUI myTraceTreeGUI;
    private JTabbedPane mySimulationSetTabs;
    private int myTemplateSimulationSetIndex = -1;
    private List<SimulationSet> mySimulationSets = new ArrayList<SimulationSet>();
    private JLabel myDebugModeLabel;
    private RmaAction myToggleDebugModeAction = null;
    private static final String DEBUG_MODE_TEXT_FMT = "<html><center>Warning! %s</center></html>";
    private static final String DEFAULT_DEBUG_MODE_TEXT = "Simulation is in debug mode.";
    private SimulationView myView;
    private List<SimulationExecutionListener> mySimulationExecutionListeners = new ArrayList<SimulationExecutionListener>();
    private SimulationExecutionListener mySimulationExecutionEventDispatcher = new SimulationExecutionEventDispatcher();
    private static final String DEFAULT_SET_NAME = "Set";

    public SimulatorPanel(ContextAwareServiceContainer serviceContainer, JTextArea trace, TraceTreeGUI traceTreeGUI, SimulatorTreeOwner theTreeOwner) {
        super(new GridBagLayout());
        this.myServiceContainer = serviceContainer;
        ClassRepository repository = this.myServiceContainer.getClassRepository();
        this.myTraceDestination = trace;
        this.myTraceTreeGUI = traceTreeGUI;
        this.myTreeOwner = theTreeOwner;
        if (this.supportsDebugMode()) {
            this.myToggleDebugModeAction = new RmaAction(this, "toggleDebugMode", "ToggleDebug", "bug_red24.png", "bug_red16.png", "Toggle debug mode", null);
            this.myToggleDebugModeAction.putValue("SwingSelectedKey", Boolean.FALSE);
        }
        this.myTraceDestination.setBorder(new EmptyBorder(8, 8, 8, 8));
        Object simFactory = repository.getSimulationFactory();
        if (simFactory != null && simFactory instanceof SimulationFactory) {
            this.mySimulationFactory = (SimulationFactory)simFactory;
        } else if (simFactory != null) {
            DialogFactory.getErrorDialog("Simulation", "The simulation factory is not set.\nNo simulations can be done for this tree structure.");
        } else {
            DialogFactory.getErrorDialog("Simulation", "The supplied simulation class is not of the type SimulationFactory.\nNo simulations can be done for this tree structure.");
        }
        this.mySimulationSetTabs = new JTabbedPane(3);
        this.mySimulationSetTabs.setName("SimulatorPanel.JTabbedPane.SimulationSetTabs");
        this.mySimulationSetTabs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SimulatorPanel.this.showSimulationSetPopup(e.getX(), e.getY());
                }
            }
        });
        this.mySimulationSetTabs.setTabLayoutPolicy(1);
        this.mySimulationSetTabs.addChangeListener(this);
        String view = RmaDefs.getInstance().properties.getProperty("Rma." + RmaDefs.PROP_SIMULATOR + ".view", "VIEW_SPLIT");
        this.myView = view.equals("VIEW_FULL") ? SimulationView.VIEW_FULL : SimulationView.VIEW_SPLIT;
        this.myDebugModeLabel = new JLabel(RmaDefs.getImageIcon("warning16.png"));
        this.myDebugModeLabel.setVisible(false);
        this.addComponents();
        HelpSystem.getInstance().enableHelpKey(this, this.getClass().toString());
        DropTarget dropTarget = new DropTarget(this, this);
        dropTarget.setActive(true);
        this.updateJumperForDebugMode(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof SimulationSet) {
            SimulationSet simulationSet = (SimulationSet)e.getSource();
            String name = simulationSet.getName();
            if (this.mySimulationSets.indexOf(simulationSet) != -1) {
                this.mySimulationSetTabs.setTitleAt(this.mySimulationSets.indexOf(simulationSet), name);
                for (SimulationSet set : this.mySimulationSets) {
                    this.mySimulationSetTabs.setForegroundAt(this.mySimulationSets.indexOf(set), set.isSetDataValid() ? Color.BLACK : SimulationDataTable.COLOR_INVALID);
                }
            }
        } else {
            SimulationSet selectedSet;
            JTabbedPane tabbedPane;
            if (this.myView == SimulationView.VIEW_SPLIT) {
                JSplitPane splitPane;
                if (this.myTemplateSimulationSetIndex != -1 && this.myTemplateSimulationSetIndex < this.mySimulationSetTabs.getTabCount() && this.mySimulationSetTabs.getComponentAt(this.myTemplateSimulationSetIndex) instanceof JSplitPane && (splitPane = (JSplitPane)this.mySimulationSetTabs.getComponentAt(this.myTemplateSimulationSetIndex)) != null && this.mySimulationSetTabs.getSelectedComponent() != null) {
                    int dividerLocation = splitPane.getDividerLocation();
                    ((JSplitPane)this.mySimulationSetTabs.getSelectedComponent()).setDividerLocation(dividerLocation);
                }
            } else if (this.myView == SimulationView.VIEW_FULL && this.myTemplateSimulationSetIndex != -1 && this.myTemplateSimulationSetIndex < this.mySimulationSetTabs.getTabCount() && this.mySimulationSetTabs.getComponentAt(this.myTemplateSimulationSetIndex) instanceof JTabbedPane && (tabbedPane = (JTabbedPane)this.mySimulationSetTabs.getComponentAt(this.myTemplateSimulationSetIndex)) != null && this.mySimulationSetTabs.getSelectedComponent() != null) {
                int selectedIndex = tabbedPane.getSelectedIndex();
                ((JTabbedPane)this.mySimulationSetTabs.getSelectedComponent()).setSelectedIndex(selectedIndex);
            }
            this.updateSimulationSets(true);
            this.myTemplateSimulationSetIndex = this.mySimulationSetTabs.getSelectedIndex();
            if (this.myTemplateSimulationSetIndex >= 0 && this.mySimulationSets.size() > this.myTemplateSimulationSetIndex && (selectedSet = this.mySimulationSets.get(this.myTemplateSimulationSetIndex)).getSimulationDataTable().getSelectedRowCount() == 0) {
                JPanel selectedPanel = selectedSet.loadSelectedSimulationCase();
                this.updateSimulationSetPanel(selectedPanel);
            }
        }
    }

    private JPanel getSimulatorPanel() {
        JPanel simulatorPanel = new JPanel(new GridBagLayout());
        int selectedTab = this.mySimulationSetTabs.getSelectedIndex();
        this.mySimulationSetTabs.removeAll();
        for (SimulationSet simulationSet : this.mySimulationSets) {
            Component simulationSetPanel = this.getSimulationViewComponent(simulationSet);
            this.mySimulationSetTabs.addTab(simulationSet.getName(), simulationSetPanel);
        }
        this.myTemplateSimulationSetIndex = selectedTab;
        this.mySimulationSetTabs.setSelectedIndex(selectedTab);
        simulatorPanel.add((Component)this.mySimulationSetTabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return simulatorPanel;
    }

    public Action getToggleDebugModeAction() {
        return this.myToggleDebugModeAction;
    }

    private Component getSimulationViewComponent(SimulationSet simulationSet) {
        JComponent simulationViewPanel = null;
        JPanel simulationSetPanel = this.getSimulationSetPanel(simulationSet);
        JPanel selectedSimulationDataPanel = simulationSet.loadSelectedSimulationCase();
        if (this.myView == SimulationView.VIEW_SPLIT) {
            JSplitPane splitPane = new JSplitPane(0);
            splitPane.setOneTouchExpandable(true);
            splitPane.setLeftComponent(simulationSetPanel);
            splitPane.setRightComponent(selectedSimulationDataPanel);
            splitPane.setResizeWeight(0.0);
            Component currentSet = this.mySimulationSetTabs.getSelectedComponent();
            if (currentSet != null) {
                splitPane.setDividerLocation(((JSplitPane)currentSet).getDividerLocation());
            } else {
                splitPane.setDividerLocation((int)simulationSetPanel.getPreferredSize().getHeight());
            }
            simulationViewPanel = splitPane;
        } else if (this.myView == SimulationView.VIEW_FULL) {
            JTabbedPane tabbedPane = new JTabbedPane(1);
            tabbedPane.addTab("Cases", simulationSetPanel);
            tabbedPane.addTab("Details", selectedSimulationDataPanel);
            tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SimulatorPanel.this.updateSimulationSets(true);
                }
            });
            simulationViewPanel = tabbedPane;
        }
        return simulationViewPanel;
    }

    private JPanel getSimulationSetPanel(SimulationSet simulationSet) {
        SimulationDataTable simulationDataTable = simulationSet.getSimulationDataTable();
        JPanel simulationSetPanel = new JPanel(new GridBagLayout());
        final JToolBar[] toolbars = simulationSet.getToolBars(this.myView);
        if (this.myView == SimulationView.VIEW_SPLIT) {
            simulationSetPanel.setLayout(new BorderLayout());
            simulationSetPanel.add((Component)toolbars[0], "South");
            simulationSetPanel.add((Component)new JScrollPane(simulationDataTable), "Center");
            simulationSetPanel.add((Component)toolbars[1], "North");
            simulationSetPanel.setPreferredSize(new Dimension(0, toolbars[0].getPreferredSize().height + toolbars[1].getPreferredSize().height + simulationDataTable.getRowHeight() * 4));
        } else if (this.myView == SimulationView.VIEW_FULL) {
            simulationSetPanel.setLayout(new BorderLayout());
            JPanel toolBarPanel = new JPanel(new GridBagLayout());
            final JScrollPane scroll = new JScrollPane(toolbars[0]);
            scroll.setVerticalScrollBarPolicy(21);
            scroll.setHorizontalScrollBarPolicy(31);
            final JButton scrollUpButton = new JButton(RmaDefs.getImageIcon("navigate_up16.png"));
            final JButton scrollDownButton = new JButton(RmaDefs.getImageIcon("navigate_down16.png"));
            scrollUpButton.setVisible(SimulatorPanel.showScrollUpButton(toolbars[0]));
            scrollDownButton.setVisible(SimulatorPanel.showScrollDownButton(toolbars[0]));
            scrollUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Rectangle visibleRect = toolbars[0].getVisibleRect();
                    scroll.getViewport().setViewPosition(new Point(0, Math.max(0, visibleRect.y - visibleRect.height)));
                    scrollUpButton.setVisible(SimulatorPanel.showScrollUpButton(toolbars[0]));
                    scrollDownButton.setVisible(SimulatorPanel.showScrollDownButton(toolbars[0]));
                }
            });
            scrollDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Rectangle visibleRect = toolbars[0].getVisibleRect();
                    int y = visibleRect.y + visibleRect.height >= toolbars[0].getSize().height ? toolbars[0].getSize().height - visibleRect.height : visibleRect.y + visibleRect.height;
                    scroll.getViewport().setViewPosition(new Point(0, y));
                    scrollUpButton.setVisible(SimulatorPanel.showScrollUpButton(toolbars[0]));
                    scrollDownButton.setVisible(SimulatorPanel.showScrollDownButton(toolbars[0]));
                }
            });
            toolBarPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    super.componentResized(e);
                    scrollUpButton.setVisible(SimulatorPanel.showScrollUpButton(toolbars[0]));
                    scrollDownButton.setVisible(SimulatorPanel.showScrollDownButton(toolbars[0]));
                }
            });
            toolBarPanel.add((Component)scrollUpButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            toolBarPanel.add((Component)scroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            toolBarPanel.add((Component)scrollDownButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            simulationSetPanel.add((Component)toolBarPanel, "West");
            simulationSetPanel.add((Component)new JScrollPane(simulationDataTable), "Center");
        }
        return simulationSetPanel;
    }

    private static boolean showScrollUpButton(JToolBar toolBar) {
        Rectangle visibleRect = toolBar.getVisibleRect();
        if (toolBar.getPreferredSize().height < visibleRect.getSize().height) {
            return false;
        }
        return visibleRect.y > 0;
    }

    private static boolean showScrollDownButton(JToolBar toolBar) {
        Rectangle visibleRect = toolBar.getVisibleRect();
        if (toolBar.getPreferredSize().height < visibleRect.getSize().height) {
            return false;
        }
        return visibleRect.y + visibleRect.height < toolBar.getSize().height;
    }

    private void setView(SimulationView view) {
        RmaDefs.getInstance().properties.setProperty("Rma." + RmaDefs.PROP_SIMULATOR + ".view", view == SimulationView.VIEW_FULL ? "VIEW_FULL" : "VIEW_SPLIT");
        this.myView = view;
        this.removeAll();
        this.addComponents();
        this.validate();
    }

    private void addComponents() {
        this.add((Component)this.myDebugModeLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.getSimulatorPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void switchViewAction(ActionEvent e) {
        this.updateSimulationSets(true);
        if (this.myView == SimulationView.VIEW_FULL) {
            this.setView(SimulationView.VIEW_SPLIT);
        } else {
            this.setView(SimulationView.VIEW_FULL);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listselectionevent) {
        if (listselectionevent.getValueIsAdjusting()) {
            return;
        }
        SimulationSet selectedSet = null;
        int selectedTabIndex = this.mySimulationSetTabs.getSelectedIndex();
        if (this.mySimulationSets.size() > 0 && selectedTabIndex > -1) {
            selectedSet = this.mySimulationSets.get(selectedTabIndex);
            JPanel selectedPanel = selectedSet.loadSelectedSimulationCase();
            this.updateSimulationSetPanel(selectedPanel);
        }
    }

    private void updateSimulationSetPanel(final JPanel selectedPanel) {
        final JComponent simulationViewComponent = (JComponent)this.mySimulationSetTabs.getSelectedComponent();
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                if (simulationViewComponent instanceof JSplitPane) {
                    int dividerLocation = ((JSplitPane)simulationViewComponent).getDividerLocation();
                    ((JSplitPane)simulationViewComponent).setRightComponent(selectedPanel);
                    ((JSplitPane)simulationViewComponent).setDividerLocation(dividerLocation);
                } else if (simulationViewComponent instanceof JTabbedPane) {
                    int selectedIndex = ((JTabbedPane)simulationViewComponent).getSelectedIndex();
                    ((JTabbedPane)simulationViewComponent).remove(1);
                    ((JTabbedPane)simulationViewComponent).addTab("Details", selectedPanel);
                    ((JTabbedPane)simulationViewComponent).setSelectedIndex(selectedIndex);
                }
            }
        });
        simulationViewComponent.revalidate();
        simulationViewComponent.repaint();
    }

    @Override
    public SimulationFactory getSimulationFactory() {
        return this.mySimulationFactory;
    }

    public Service getService() {
        return this.myServiceContainer.getService();
    }

    public ContextAwareServiceContainer getServiceAndContext() {
        return this.myServiceContainer;
    }

    SimulatorTreeOwner getTreeOwner() {
        return this.myTreeOwner;
    }

    public ClassRepository getClassRepository() {
        return this.myServiceContainer.getClassRepository();
    }

    JTextArea getTraceDestination() {
        return this.myTraceDestination;
    }

    TraceTreeGUI getTraceTreeGUI() {
        return this.myTraceTreeGUI;
    }

    TraceTreeInfo getTraceTreeInfo() {
        return this.myTraceTreeInfo;
    }

    SimulationSet getSelectedSimulationSet() {
        int index = this.mySimulationSetTabs.getSelectedIndex() != -1 ? this.mySimulationSetTabs.getSelectedIndex() : 0;
        return this.mySimulationSets.get(index);
    }

    public void addSimulationExecutionListener(SimulationExecutionListener listener) {
        if (!this.mySimulationExecutionListeners.contains(listener)) {
            this.mySimulationExecutionListeners.add(listener);
        }
    }

    public void removeSimulationExecutionListener(SimulationExecutionListener listener) {
        this.mySimulationExecutionListeners.remove(listener);
    }

    public void addSimulationSet(SimulationSet simulationSet) {
        this.mySimulationSetTabs.addTab(simulationSet.getName(), this.getSimulationViewComponent(simulationSet));
        this.mySimulationSetTabs.setSelectedIndex(this.mySimulationSetTabs.getTabCount() - 1);
        this.mySimulationSets.add(simulationSet);
        simulationSet.addSimulationExecutionListener(this.mySimulationExecutionEventDispatcher);
        simulationSet.getSimulationDataTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseevent) {
                if (mouseevent.getClickCount() == 2 && SimulatorPanel.this.myView == SimulationView.VIEW_FULL) {
                    JTabbedPane simulationViewComponent = (JTabbedPane)SimulatorPanel.this.mySimulationSetTabs.getSelectedComponent();
                    simulationViewComponent.setSelectedIndex(1);
                }
            }
        });
    }

    private void removeSimulationSet(int index) {
        SimulationSet simulationSet = this.mySimulationSets.get(index);
        if (this.mySimulationSets.size() == 1) {
            SimulationSet newSet = new SimulationSet("Set 1", this, false);
            this.addSimulationSet(newSet);
        }
        int indexOfSimulationSet = this.mySimulationSets.indexOf(simulationSet);
        this.mySimulationSets.remove(simulationSet);
        this.mySimulationSetTabs.remove(indexOfSimulationSet);
        simulationSet.removeSimulationExecutionListener(this.mySimulationExecutionEventDispatcher);
    }

    public void createSetAction(ActionEvent e) {
        this.updateSimulationSets(true);
        ArrayList<String> setNames = new ArrayList<String>();
        for (SimulationSet simulationSet : this.mySimulationSets) {
            setNames.add(simulationSet.getName());
        }
        int index = 2;
        while (true) {
            boolean freeIndex = true;
            for (String name : setNames) {
                if (!name.equals("Set " + index)) continue;
                freeIndex = false;
            }
            if (freeIndex) break;
            ++index;
        }
        CreateSimulationSetDialog simulationDialog = new CreateSimulationSetDialog(this, this.mySimulationSets, "Set " + index);
        simulationDialog.setVisible(true);
    }

    public void closeSetAction(ActionEvent e) {
        int selectedSimulationSet = this.mySimulationSetTabs.getSelectedIndex();
        SimulationSet simulationSet = this.mySimulationSets.get(selectedSimulationSet);
        boolean close = true;
        if (simulationSet.isModified()) {
            int dialogResult = DialogFactory.getQuestionDialogWithCancel(this, "RMA Simulation", "'" + simulationSet.getName() + "' has been modified. Would you like to save it before closing?");
            if (dialogResult == 0) {
                close = simulationSet.save();
            } else if (dialogResult == 1) {
                close = true;
            } else {
                return;
            }
        }
        if (close) {
            this.removeSimulationSet(selectedSimulationSet);
        }
    }

    public void toggleDebugMode(ActionEvent e) {
        boolean state = (Boolean)this.myToggleDebugModeAction.getValue("SwingSelectedKey");
        this.updateJumperForDebugMode(state);
        this.updateUIForDebugMode(state);
    }

    private void updateUIForDebugMode(boolean state) {
        if (state) {
            String debugText = this.getDebugState().getInfoText();
            if (debugText == null) {
                debugText = DEFAULT_DEBUG_MODE_TEXT;
            }
            this.myDebugModeLabel.setText(String.format(DEBUG_MODE_TEXT_FMT, debugText));
        }
        this.myDebugModeLabel.setVisible(state);
        this.myTreeOwner.indicateDebugMode(state);
    }

    private void updateJumperForDebugMode(boolean state) {
        JumperSupport currentJumper = this.getClassRepository().getJumperSupport();
        if (currentJumper != null) {
            SimulatorJumpContext jctx = new SimulatorJumpContext(state);
            jctx.setService(this.myServiceContainer.getService());
            currentJumper.setJumpContext(jctx);
        }
    }

    protected boolean supportsDebugMode() {
        return FunctionState.State.ON == this.getDebugState().getState();
    }

    private FunctionState getDebugState() {
        RatingPeriodProxy proxy = this.myTreeOwner.getRatingPeriodProxy();
        if (proxy == null) {
            return FunctionState.createFunctionState(FunctionState.State.OFF);
        }
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionState state = mgr.getStateForFunction(FunctionToken.DEBUG, FunctionContext.build().withProxy(proxy).get());
        return state;
    }

    public void selectSet(String setName) {
        for (SimulationSet set : this.mySimulationSets) {
            if (!set.getName().equals(setName)) continue;
            this.mySimulationSetTabs.setSelectedIndex(this.mySimulationSets.indexOf(set));
            break;
        }
    }

    public void selectLastSet() {
        this.mySimulationSetTabs.setSelectedIndex(this.mySimulationSets.size() - 1);
    }

    private void showSimulationSetPopup(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        popup.setName("SimulatorPanel.JPopupMenu.SimulationPopup");
        AbstractAction closeAllAction = new AbstractAction("Close all Sets"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean modifiedSets = false;
                for (SimulationSet set : SimulatorPanel.this.mySimulationSets) {
                    if (!set.isModified()) continue;
                    modifiedSets = true;
                }
                if (modifiedSets && !DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA", "You have open simulation sets that needs to be saved before closing. Any unsaved changes will be lost if you continue.Would you like to continue?")) {
                    return;
                }
                int size = SimulatorPanel.this.mySimulationSets.size();
                for (int i = 0; i < size; ++i) {
                    SimulatorPanel.this.removeSimulationSet(0);
                }
            }
        };
        AbstractAction closeAction = new AbstractAction("Close Set"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulatorPanel.this.closeSetAction(e);
            }
        };
        AbstractAction renameAction = new AbstractAction("Rename Set"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameSimulationSetDialog dialog = new RenameSimulationSetDialog((SimulationSet)SimulatorPanel.this.mySimulationSets.get(SimulatorPanel.this.mySimulationSetTabs.getSelectedIndex()));
                dialog.setVisible(true);
            }
        };
        popup.add(closeAction).setName("SimulatorPanel.MenuItem.Close");
        popup.add(closeAllAction).setName("SimulatorPanel.MenuItem.CloseAll");
        popup.add(renameAction).setName("SimulatorPanel.MenuItem.Rename");
        popup.show(this.mySimulationSetTabs, x, y);
    }

    @Override
    public void saveAction(ActionEvent event) {
        for (SimulationSet simulationSet : this.mySimulationSets) {
            simulationSet.save();
        }
    }

    @Override
    public boolean isModified() {
        for (SimulationSet simulationSet : this.mySimulationSets) {
            if (!simulationSet.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveAllowed() {
        for (SimulationSet simulationSet : this.mySimulationSets) {
            if (simulationSet.canSave()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void focusGained() {
        if (this.mySimulationSets.size() == 0) {
            SimulationSet initialSet = new SimulationSet("Set 1", this, false);
            this.addSimulationSet(initialSet);
        }
        this.updateSimulationSets(true);
    }

    public boolean updateSimulationSets(boolean showDialog) {
        boolean changedFields = false;
        boolean areCreatedCases = false;
        for (SimulationSet set : this.mySimulationSets) {
            if (!set.isEmptySet()) {
                areCreatedCases = true;
            }
            if (!set.updateTreeDefinedFields()) continue;
            changedFields = true;
        }
        if (changedFields && areCreatedCases && showDialog) {
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA - Simulation panel reload", "Changes in the Tree Defined Fields editor forces the simulator to reload the simulation fields.");
        }
        return changedFields;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(dtde.getDropAction());
                List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : fileList) {
                    Document simDocument = XMLUtil.buildDocumentFromFile(file);
                    if (simDocument.getDocumentElement().getNodeName().equals("SimulationSuite")) {
                        SimulationSet newSet = new SimulationSet(FileUtil.getFileName(file), this, false);
                        ((FileSimulationSource)newSet.getDataSource()).setFilePath(file);
                        ((FileSimulationSource)newSet.getDataSource()).loadDocument(simDocument);
                        this.addSimulationSet(newSet);
                        if (newSet.getSimulationDataTable().getRowCount() <= 0) continue;
                        newSet.getSimulationDataTable().setSelectedRow(0);
                        continue;
                    }
                    DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Faulty simulation file", "The dropped file '" + file.getName() + "' is not a simulation file.");
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "simulation", 0, "The object that you dropped can not be imported here.", true);
        }
        dtde.dropComplete(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private class SimulationExecutionEventDispatcher
    implements SimulationExecutionListener {
        private SimulationExecutionEventDispatcher() {
        }

        @Override
        public void simulationFailed(SimulationExecutionEvent.SimulationFailedEvent e) {
            for (SimulationExecutionListener l : SimulatorPanel.this.mySimulationExecutionListeners) {
                l.simulationFailed(e);
            }
        }

        @Override
        public void simulationFinished(SimulationExecutionEvent.SimulationFinishedEvent e) {
            for (SimulationExecutionListener l : SimulatorPanel.this.mySimulationExecutionListeners) {
                l.simulationFinished(e);
            }
        }

        @Override
        public void simulationStarting(SimulationExecutionEvent.SimulationStartingEvent e) {
            for (SimulationExecutionListener l : SimulatorPanel.this.mySimulationExecutionListeners) {
                l.simulationStarting(e);
            }
        }
    }

    private static class SimulatorJumpContext
    implements JumpContext,
    ServiceCache {
        private boolean myIsDebugMode;
        private HashMap<String, Service> myServices = new HashMap();

        private SimulatorJumpContext(boolean b) {
            this.myIsDebugMode = b;
        }

        @Override
        public boolean isDebugMode() {
            return this.myIsDebugMode;
        }

        @Override
        public void setDebugMode(boolean b) {
            this.myIsDebugMode = b;
        }

        @Override
        public Service getService(String serviceName) {
            return this.myServices.get(serviceName);
        }

        @Override
        public void setService(Service service) {
            if (service != null) {
                this.myServices.put(service.getId(), service);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myIsDebugMode ? 1231 : 1237);
            result = 31 * result + (this.myServices == null ? 0 : this.myServices.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimulatorJumpContext other = (SimulatorJumpContext)obj;
            if (this.myIsDebugMode != other.myIsDebugMode) {
                return false;
            }
            return !(this.myServices == null ? other.myServices != null : !this.myServices.equals(other.myServices));
        }
    }

    public static enum SimulationView {
        VIEW_SPLIT,
        VIEW_FULL;

    }
}

