/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.gui.simulator.AbstractGroupedSimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationPanelSearcher;
import com.ericsson.ere.gui.util.ClosableVarPanel;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.components.GroupedArrayPanel;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.GroupedObjectArrayEditor;
import ericsson.vareditor.variable.array.GroupedObjectArrayVariable;
import ericsson.vareditor.variable.bitpatternutils.BitPatternInputVariablePanel;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SimulationParameterFilterer
implements SimulationPanelSearcher {
    private String mySearchText;
    private String myPreviousSearchText = "";
    private Map<String, Boolean> myUnfilteredState = new HashMap<String, Boolean>();
    private boolean mySaveGroupState;
    private AbstractGroupedSimulationDataPanel myPanel;

    public SimulationParameterFilterer(AbstractGroupedSimulationDataPanel panel) {
        this.myPanel = panel;
    }

    @Override
    public void performSearch(String searchText) {
        this.mySearchText = searchText;
        boolean bl = this.mySaveGroupState = this.myPreviousSearchText.isEmpty() && !this.mySearchText.isEmpty();
        if (!this.mySearchText.equals(this.myPreviousSearchText)) {
            this.filterSimulation(this.myPanel.getAllInputParameters());
            this.filterSimulation(this.myPanel.getAllOutputParameters());
            this.filterSimulation(this.myPanel.getCommonParameters());
            this.visitComponents();
        }
        this.myPreviousSearchText = this.mySearchText;
    }

    private void filterSimulation(List<Variable> variables) {
        for (Variable var : variables) {
            if (var instanceof GroupedObjectArrayVariable) continue;
            var.getEditor().setVisible(this.mySearchText.isEmpty() || var.getLabel().toLowerCase().contains(this.mySearchText.toLowerCase()));
        }
    }

    private void visitComponents() {
        for (JComponent myComponent : this.myPanel.getComponentList()) {
            this.visitComponent(myComponent, false);
        }
    }

    private boolean visitComponent(Component component, boolean groupMatch) {
        int visibleCount = 0;
        visibleCount = component instanceof VarTable2 ? this.visitVarTable2(component, groupMatch) : (component instanceof GroupedObjectArrayEditor ? this.visitGroupedObjectArrayEditor(component, groupMatch) : (component instanceof BitPatternInputVariablePanel ? this.visitBitPatternInputVariablePanel(component, groupMatch) : (component instanceof GroupedArrayPanel ? this.visitGroupedArrayPanel(component, groupMatch) : (component instanceof ClosableVarPanel ? this.visitClosableVarPanel(component, groupMatch) : (component instanceof JPanel ? this.visitJPanel(component, groupMatch) : ++visibleCount)))));
        return visibleCount != 0;
    }

    private int visitVarTable2(Component component, boolean groupMatch) {
        int visibleCount = 0;
        VarTable2 table = (VarTable2)component;
        List<Variable> variableList = table.getTableModel().getData();
        for (Variable v : variableList) {
            visibleCount += v.getEditor().isVisible() ? 1 : 0;
            if (!groupMatch) continue;
            v.getEditor().setVisible(true);
        }
        table.updateTable();
        return visibleCount;
    }

    private int visitGroupedObjectArrayEditor(Component component, boolean groupMatch) {
        int visibleCount = 0;
        GroupedObjectArrayEditor comp = (GroupedObjectArrayEditor)component;
        for (int i = 0; i < comp.getModel().getColumnCount() && visibleCount == 0; ++i) {
            boolean textMatch;
            boolean bl = textMatch = !this.mySearchText.isEmpty() && comp.getModel().getColumnName(i).toLowerCase().contains(this.mySearchText.toLowerCase());
            if (!this.mySearchText.isEmpty() && !textMatch) continue;
            ++visibleCount;
        }
        return visibleCount;
    }

    private int visitBitPatternInputVariablePanel(Component component, boolean groupMatch) {
        int visibleCount = 0;
        Component[] children = ((JComponent)component).getComponents();
        for (int i = 0; i < children.length; ++i) {
            this.visitComponent(children[i], groupMatch);
        }
        if (groupMatch) {
            component.setVisible(true);
        }
        return visibleCount += component.isVisible() ? 1 : 0;
    }

    private int visitGroupedArrayPanel(Component component, boolean groupMatch) {
        return this.visitBitPatternInputVariablePanel(component, groupMatch);
    }

    private int visitClosableVarPanel(Component component, boolean groupMatch) {
        int i;
        int visibleCount = 0;
        ClosableVarPanel comp = (ClosableVarPanel)component;
        boolean groupMatchLocal = groupMatch;
        boolean groupMatchOnThisPanel = false;
        boolean textMatch = comp.getGroupName().toLowerCase().contains(this.mySearchText.toLowerCase());
        if (!this.mySearchText.isEmpty() && textMatch) {
            groupMatchLocal = true;
            groupMatchOnThisPanel = true;
        }
        List<JComponent> children = comp.getClosableComponents();
        boolean[] visibleChild = new boolean[children.size()];
        for (i = 0; i < children.size(); ++i) {
            visibleChild[i] = this.visitComponent(children.get(i), groupMatchLocal);
            visibleCount += visibleChild[i] ? 1 : 0;
        }
        comp.setVisible(visibleCount != 0 || groupMatchLocal);
        if (this.mySaveGroupState) {
            this.myUnfilteredState.put(comp.getName(), comp.isFolded());
        } else if (this.mySearchText.isEmpty()) {
            if (this.myUnfilteredState.containsKey(comp.getName())) {
                comp.setFoldedState(this.myUnfilteredState.get(comp.getName()));
            } else {
                comp.setFoldedState(true);
            }
        }
        if (!this.mySearchText.isEmpty()) {
            comp.setFoldedState(visibleCount == 0);
            if (groupMatchOnThisPanel) {
                comp.setFoldedState(false);
            } else if (comp.getParent() instanceof BitPatternInputVariablePanel || comp.getParent() instanceof GroupedArrayPanel) {
                comp.setFoldedState(true);
            }
        }
        if (!groupMatchOnThisPanel) {
            for (i = 0; i < children.size(); ++i) {
                if (!(children.get(i) instanceof ClosableVarPanel) || visibleChild[i]) continue;
                children.get(i).setVisible(visibleChild[i]);
            }
        }
        return visibleCount += groupMatchOnThisPanel ? 1 : 0;
    }

    private int visitJPanel(Component component, boolean groupMatch) {
        int visibleCount = 0;
        Component[] children = ((JPanel)component).getComponents();
        for (int i = 0; i < children.length; ++i) {
            visibleCount += this.visitComponent(children[i], groupMatch) ? 1 : 0;
        }
        return visibleCount;
    }
}

