/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.search.FieldChooserTool;
import ericsson.ere.defs.RmaDefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SimulationDataTable
extends JTable
implements MouseListener,
MouseMotionListener,
TableModelListener {
    static final Color COLOR_INVALID = new Color(239, 89, 63);
    private static final ImageIcon ICON_SUCCESS = RmaDefs.getImageIcon("simulation_ok16.png");
    private static final ImageIcon ICON_FAILURE = RmaDefs.getImageIcon("simulation_warning16.png");
    private static final ImageIcon ICON_ERROR = RmaDefs.getImageIcon("simulation_error16.png");
    private static final ImageIcon ICON_NORMAL = RmaDefs.getImageIcon("simulation_normal16.png");
    SimulationDataTableModel myModel;
    FieldChooserTool myHeaderDialog;
    private TableColumn myTitleColumn;
    private SimulationDataTableTitleColumnRenderer myTitlerenderer;
    private int mySortingColumn;
    private boolean mySortingIsAscending;

    public SimulationDataTable(SimulationDataTableModel model) {
        super(model);
        this.myModel = model;
        this.setSelectionMode(2);
        this.myTitleColumn = this.getColumn(this.myModel.getTitleColumn());
        this.myTitlerenderer = new SimulationDataTableTitleColumnRenderer();
        this.myTitleColumn.setCellRenderer(this.myTitlerenderer);
        this.getTableHeader().addMouseListener(this);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().addMouseMotionListener(this);
        this.setAutoCreateRowSorter(true);
        this.initColumnsVisibility();
        this.setColumnsResizable();
    }

    private void initColumnsVisibility() {
        for (String columnName : this.myModel.getColumnNames(true)) {
            this.hideColumn(columnName);
        }
        List<String> fieldDefinitions = this.myModel.getColumnNamesForPrintableFields();
        this.myHeaderDialog = new FieldChooserTool(fieldDefinitions, this.myModel.getTitleColumn(), "Simulation table preferences", "Show/Hide Simulation table columns", "Visible");
        this.myHeaderDialog.setAdditionalTableModelListener(this);
        for (int i = 0; i < fieldDefinitions.size(); ++i) {
            if (!fieldDefinitions.get(i).equals(this.myModel.getTitleColumn())) continue;
            this.showColumn(fieldDefinitions.get(i));
        }
    }

    @Override
    public void setModel(TableModel model) {
        if (model instanceof SimulationDataTableModel) {
            this.myModel = (SimulationDataTableModel)model;
            super.setModel(this.myModel);
            this.initColumnsVisibility();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.myHeaderDialog != null && e.getSource() == this.myHeaderDialog.getTableModel()) {
            if (e.getType() == 0) {
                int row = e.getFirstRow();
                String name = this.myHeaderDialog.getNameOnFieldOnRow(row);
                boolean value = this.myHeaderDialog.getSelectedOnFieldOnRow(row);
                if (value) {
                    this.showColumn(name);
                } else {
                    this.hideColumn(name);
                }
                this.setColumnsResizable();
            }
        } else {
            super.tableChanged(e);
            if (this.myModel != null) {
                this.myTitleColumn = this.getColumn(this.myModel.getTitleColumn());
                if (this.myTitleColumn != null) {
                    this.myTitleColumn.setCellRenderer(this.myTitlerenderer);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        String column = this.getColumnName(this.getTableHeader().columnAtPoint(e.getPoint()));
        this.getTableHeader().setToolTipText(column);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
        if (mouseevent.isPopupTrigger()) {
            this.myHeaderDialog.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
        if (mouseevent.isPopupTrigger()) {
            this.myHeaderDialog.setVisible(true);
        }
    }

    public void openSimulationColumnDialog(ActionEvent e) {
        this.myHeaderDialog.setVisible(true);
    }

    void simulationDataChanged(List<String> newData) {
        for (String specialField : SimulationDataTableModel.SPECIAL_FIELDS) {
            this.hideColumn(specialField);
        }
        this.myHeaderDialog.setNewData(newData);
        for (String field : this.myHeaderDialog.getDeselectedFields()) {
            this.hideColumn(field);
        }
    }

    public void hideColumn(String columnName) {
        this.getColumn(columnName).setResizable(false);
        this.getColumn(columnName).setMaxWidth(0);
        this.getColumn(columnName).setMinWidth(0);
        this.getColumn(columnName).setWidth(0);
        this.getColumn(columnName).setPreferredWidth(0);
    }

    public void showColumn(String columnName) {
        this.getColumn(columnName).setResizable(true);
        this.getColumn(columnName).setMaxWidth(Integer.MAX_VALUE);
        this.getColumn(columnName).setMinWidth(15);
        this.getColumn(columnName).setWidth(Integer.MAX_VALUE);
    }

    private void setColumnsResizable() {
        int lastVisible = 0;
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            if (column.getWidth() == 0) continue;
            this.getColumnModel().getColumn(i).setResizable(true);
            lastVisible = i;
        }
        this.getColumnModel().getColumn(lastVisible).setResizable(false);
    }

    private void sortColumn(int column) {
        this.mySortingIsAscending = this.mySortingColumn != column ? true : !this.mySortingIsAscending;
        this.mySortingColumn = column;
        this.getTableHeader().validate();
        this.getTableHeader().repaint();
    }

    @Override
    public boolean isCellEditable(int i, int j) {
        return false;
    }

    public void setSelectedRow(int row) {
        this.getSelectionModel().setSelectionInterval(row, row);
    }

    private class SimulationDataTableTitleColumnRenderer
    extends DefaultTableCellRenderer {
        private SimulationDataTableTitleColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (SimulationDataTable.this.getColumnName(column).equals(SimulationDataTable.this.myModel.getTitleColumn()) && SimulationDataTable.this.myModel.hasSimulated()) {
                int actualRow = SimulationDataTable.this.convertRowIndexToModel(row);
                if (SimulationDataTable.this.myModel.getSimulationStatus(actualRow) == SimulationDataTableModel.SimulationStatus.STATUS_SUCCESS) {
                    c.setIcon(ICON_SUCCESS);
                } else if (SimulationDataTable.this.myModel.getSimulationStatus(actualRow) == SimulationDataTableModel.SimulationStatus.STATUS_FAILED) {
                    c.setIcon(ICON_FAILURE);
                } else if (SimulationDataTable.this.myModel.getSimulationStatus(actualRow) == SimulationDataTableModel.SimulationStatus.STATUS_ERRONEOUS) {
                    c.setIcon(ICON_ERROR);
                } else {
                    c.setIcon(ICON_NORMAL);
                }
            }
            if (isSelected) {
                c.setBackground(SimulationDataTable.this.getSelectionBackground());
            } else {
                c.setBackground(Color.WHITE);
            }
            if (!SimulationDataTable.this.myModel.getDataValidity(SimulationDataTable.this.convertRowIndexToModel(row))) {
                c.setBackground(isSelected ? COLOR_INVALID.darker() : COLOR_INVALID);
            }
            if (value != null) {
                c.setToolTipText(value.toString());
            } else {
                c.setToolTipText(null);
            }
            return c;
        }
    }
}

