/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import java.util.List;

public class SimulationDataDiff {
    public static final int NO_DIFF = 0;
    public static final int REMOVED = 1;
    public static final int ADDED = 2;
    public static final int TYPE_CHANGE = 3;
    public static final int VALUE_CHANGE = 4;
    private final int myChange;
    private final String myLabel;
    private final Object myValue;

    public SimulationDataDiff(int change, String label, Object value) {
        this.myChange = change;
        this.myLabel = label;
        this.myValue = value;
    }

    public String getMessage() {
        String msg = null;
        switch (this.myChange) {
            case 0: {
                msg = "";
                break;
            }
            case 1: {
                msg = "The parameter \"" + this.myLabel + "\" was removed since it is no longer in use.";
                break;
            }
            case 2: {
                msg = "The parameter \"" + this.myLabel + "\" has been added to the service.";
                if (this.myValue == null) break;
                msg = msg + "Default value: " + this.myValue;
                break;
            }
            case 3: {
                msg = "The parameter \"" + this.myLabel + "\" has changed type. ";
                if (this.myValue == null) break;
                msg = msg + "Data may have been lost, new value is: " + this.myValue;
                break;
            }
            case 4: {
                msg = "The parameter \"" + this.myLabel + "\" has changed type and value.";
                if (this.myValue == null) break;
                msg = msg + "New value is: " + this.myValue;
                break;
            }
            default: {
                msg = "Unknown diff type: " + this.myChange;
            }
        }
        return msg;
    }

    public int getDiffType() {
        return this.myChange;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public Object getValue() {
        return this.myValue;
    }

    public static String getDiffMessage(List<SimulationDataDiff> diffLists, boolean showAdded, boolean showDeleted, boolean showDatatypeChanges) {
        if (diffLists == null || diffLists.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("The following parameters are changed:\n");
        for (SimulationDataDiff diff : diffLists) {
            if (!(diff.getDiffType() == 2 && showAdded || diff.getDiffType() == 1 && showDeleted) && (diff.getDiffType() != 3 || !showDatatypeChanges)) continue;
            buf.append(diff.getMessage());
            buf.append("\n");
        }
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.myChange;
        result = 31 * result + (this.myLabel == null ? 0 : this.myLabel.hashCode());
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimulationDataDiff other = (SimulationDataDiff)obj;
        if (this.myChange != other.myChange) {
            return false;
        }
        if (this.myLabel == null ? other.myLabel != null : !this.myLabel.equals(other.myLabel)) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }
}

