/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.task.ContinuousMillisecondTimeTask;
import com.ericsson.ere.dataset.task.ContinuousTimeTask;
import com.ericsson.ere.dataset.task.TimeBasedTask;
import com.ericsson.ere.gui.simulator.GroupedRatingDataSetSimulationPanel;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.vareditor.variable.RatingDecimalVariable;
import ericsson.vareditor.variable.Variable;

public class GroupedMillisecondAllocatableRatingDataSetSimulationPanel
extends GroupedRatingDataSetSimulationPanel {
    private static final int MILLIS_PER_SECOND = 1000;

    public GroupedMillisecondAllocatableRatingDataSetSimulationPanel(ContextAwareServiceContainer serviceContainer) {
        super(serviceContainer);
    }

    public GroupedMillisecondAllocatableRatingDataSetSimulationPanel(Service service) {
        super(service);
    }

    @Override
    protected Variable createDurationVariable() {
        return new RatingDecimalVariable("Duration", new RatingDecimal(60.0));
    }

    @Override
    protected Variable createExpectedDurationVariable() {
        return new RatingDecimalVariable("Expected duration", new RatingDecimal(0.0));
    }

    @Override
    protected ContinuousTimeTask createContinuousTimeTask(Variable durationVariable) {
        RatingDecimal durationInMillis = ((RatingDecimal)durationVariable.getValueObject()).multiply(new RatingDecimal(1000.0));
        return new ContinuousMillisecondTimeTask(durationInMillis.longValue());
    }

    @Override
    protected Object getAllocatedDurationFromTimeTask(TimeBasedTask timeTask) {
        RatingDecimal durationInMillis = new RatingDecimal(timeTask.getAllocatedDuration(), 1L);
        return durationInMillis.divide(new RatingDecimal(1000L, 1L));
    }
}

