/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DefaultDataSetAccessor;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.defs.RMAClassRepositoryWithContext;
import com.ericsson.ere.util.Location;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepository;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.ObjectArrayDescription;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FieldContextDataModel
extends ObjectArrayModel
implements VariableChangeListener {
    private static final long serialVersionUID = -8502547516368838164L;
    public static final String SERVICE_PROVIDER_LABEL = "Service Provider";
    public static final String USE_RATING_PLAN_LABEL = "Use Rating Plan";
    public static final String RATING_PLAN_LABEL = "Rating Plan";
    public static final String FIELD_NAME_LABEL = "Field Name";
    public static final String VALUE_LABEL = "Value";
    public static final String SERVICE_PROVIDER_ATTRIBUTE = "serviceProvider";
    public static final String USE_RATING_PLAN_ATTRIBUTE = "useRatingPlan";
    public static final String RATING_PLAN_ATTRIBUTE = "ratingPlan";
    public static final String FIELD_NAME_ATTRIBUTE = "fieldName";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final int SERVICE_PROVIDER_INDEX = 0;
    public static final int USE_RATING_PLAN_INDEX = 1;
    public static final int RATING_PLAN_INDEX = 2;
    public static final int FIELD_NAME_INDEX = 3;
    public static final int VALUE_INDEX = 4;
    public static final String XML_TAG = "FieldContextField";
    private static final Variable DUMMY_SERVICE_PROVIDER_VARIABLE = new StringVariable("Service Provider");
    private static final Variable DUMMY_USE_RATING_PLAN_VARIABLE = new BoolVariable("Use Rating Plan", false);
    private static final Variable DUMMY_RATING_PLAN_VARIABLE = new StringVariable("Rating Plan");
    private static final Variable DUMMY_RATING_PLAN_VARIABLE_VALID = new StringVariable("Rating Plan");
    private static final Variable DUMMY_FIELD_NAME_VARIABLE = new StringVariable("Field Name");
    private static final Variable DUMMY_VALUE_VARIABLE = new StringVariable("Value");
    protected final RMAClassRepositoryWithContext myClassRepository;
    protected VarTableModel myVarTableModel;

    public FieldContextDataModel(RMAClassRepositoryWithContext repository) {
        super(XML_TAG, XML_TAG, new ArrayList<Object[]>(), (ObjectArrayDescription)new FieldContextObjectArrayDescription());
        this.myClassRepository = repository;
        this.setUniqueColumns(new int[]{3});
    }

    @Override
    public VarTableModel createVarTableModel(Object[] values) {
        String serviceProviderString = (String)values[0];
        Boolean useRatingPlan = (Boolean)values[1];
        String ratingPlanString = (String)values[2];
        String fieldNameString = (String)values[3];
        Object value = values[4];
        this.myVarTableModel = new VarTableModel(new ArrayList<Variable>());
        List<String> serviceProviders = this.myClassRepository.getFieldContextServiceProviders();
        if (!serviceProviders.isEmpty()) {
            DropDownVariable serviceProviderVariable = new DropDownVariable(SERVICE_PROVIDER_LABEL, serviceProviders.toArray());
            ((Variable)serviceProviderVariable).setValue(serviceProviderString);
            this.myVarTableModel.getData().add(serviceProviderVariable);
            BoolVariable useRatingPlanVariable = new BoolVariable(USE_RATING_PLAN_LABEL, useRatingPlan);
            this.myVarTableModel.getData().add(useRatingPlanVariable);
            if (useRatingPlan.booleanValue()) {
                this.addVariablesForRatingPlanAndFieldAndValue(serviceProviderString, ratingPlanString, fieldNameString, value);
            } else {
                this.myVarTableModel.getData().add(DUMMY_RATING_PLAN_VARIABLE_VALID);
                FieldRepository fieldRepository = this.myClassRepository.getFieldContextFieldRepository(serviceProviderString);
                this.addVariablesForFieldAndValue(fieldRepository, fieldNameString, value);
            }
        } else {
            this.myVarTableModel.getData().add(DUMMY_SERVICE_PROVIDER_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_USE_RATING_PLAN_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_RATING_PLAN_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_FIELD_NAME_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_VALUE_VARIABLE);
        }
        this.addVariableChangeListener();
        return this.myVarTableModel;
    }

    protected void addVariableChangeListener() {
        for (Variable vara : this.myVarTableModel.getData()) {
            vara.addVariableChangeListener(this);
        }
    }

    protected void addVariableForValue(FieldRepository fieldRepository, Object value) {
        Variable valueVariable = this.createVariableFromField((FieldDefinition)fieldRepository.getFieldByName(VarListUtil.getValueStringForName(this.myVarTableModel.getData(), FIELD_NAME_LABEL)), value);
        valueVariable.setLabel(VALUE_LABEL);
        this.myVarTableModel.getData().add(valueVariable);
    }

    protected void addVariablesForFieldAndValue(FieldRepository fieldRepository, String fieldName, Object value) {
        List<String> fieldNames = this.getAllInputFieldNames(fieldRepository);
        if (!fieldNames.isEmpty()) {
            DropDownVariable fieldNameVariable = new DropDownVariable(FIELD_NAME_LABEL, fieldNames.toArray());
            if (fieldName != null) {
                ((Variable)fieldNameVariable).setValue(fieldName);
            }
            this.myVarTableModel.getData().add(fieldNameVariable);
            this.addVariableForValue(fieldRepository, value);
        } else {
            this.myVarTableModel.getData().add(DUMMY_FIELD_NAME_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_VALUE_VARIABLE);
        }
    }

    protected void addVariablesForRatingPlanAndFieldAndValue(String serviceProvider, String ratingPlan, String fieldName, Object value) {
        List<String> ratingPlans = this.myClassRepository.getFieldContextRatingPlans(serviceProvider);
        if (!ratingPlans.isEmpty()) {
            FieldRepository fieldRepository;
            DropDownVariable ratingPlanVariable = new DropDownVariable(RATING_PLAN_LABEL, ratingPlans.toArray());
            if (ratingPlan == null) {
                fieldRepository = this.myClassRepository.getFieldContextFieldRepository(serviceProvider, ((Variable)ratingPlanVariable).getValueString());
            } else {
                ((Variable)ratingPlanVariable).setValue(ratingPlan);
                fieldRepository = this.myClassRepository.getFieldContextFieldRepository(serviceProvider, ratingPlan);
            }
            this.myVarTableModel.getData().add(ratingPlanVariable);
            this.addVariablesForFieldAndValue(fieldRepository, fieldName, value);
        } else {
            this.myVarTableModel.getData().add(DUMMY_RATING_PLAN_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_FIELD_NAME_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_VALUE_VARIABLE);
        }
    }

    @Override
    public VarTableModel createVarTableModel() {
        this.myVarTableModel = new VarTableModel(new ArrayList<Variable>());
        List<String> serviceProviders = this.myClassRepository.getFieldContextServiceProviders();
        if (!serviceProviders.isEmpty()) {
            DropDownVariable serviceProviderVariable = new DropDownVariable(SERVICE_PROVIDER_LABEL, serviceProviders.toArray());
            String serviceProviderString = ((Variable)serviceProviderVariable).getValueString();
            this.myVarTableModel.getData().add(serviceProviderVariable);
            BoolVariable useRatingPlanVariable = new BoolVariable(USE_RATING_PLAN_LABEL, true);
            this.myVarTableModel.getData().add(useRatingPlanVariable);
            this.addVariablesForRatingPlanAndFieldAndValue(serviceProviderString, null, null, null);
        } else {
            this.myVarTableModel.getData().add(DUMMY_SERVICE_PROVIDER_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_USE_RATING_PLAN_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_RATING_PLAN_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_FIELD_NAME_VARIABLE);
            this.myVarTableModel.getData().add(DUMMY_VALUE_VARIABLE);
        }
        this.addVariableChangeListener();
        return this.myVarTableModel;
    }

    @Override
    public void valueChanged(VariableChangeEvent event) {
        for (Variable var : this.myVarTableModel.getData()) {
            var.removeVariableChangeListener(this);
        }
        Variable var = event.getVariable();
        String label = var.getLabel();
        this.removeAllAfter(var);
        if (SERVICE_PROVIDER_LABEL.equals(label)) {
            this.myVarTableModel.getData().add(new BoolVariable(USE_RATING_PLAN_LABEL, true));
            this.addVariablesForRatingPlanAndFieldAndValue(var.getValueString(), null, null, null);
            this.myVarTableModel.fireTableDataChanged();
        } else if (USE_RATING_PLAN_LABEL.equals(label)) {
            Boolean useRatingPlan = Boolean.valueOf(VarListUtil.getValueStringForName(this.myVarTableModel.getData(), USE_RATING_PLAN_LABEL));
            if (useRatingPlan.booleanValue()) {
                String serviceProvider = VarListUtil.getValueStringForName(this.myVarTableModel.getData(), SERVICE_PROVIDER_LABEL);
                this.addVariablesForRatingPlanAndFieldAndValue(serviceProvider, null, null, null);
            } else {
                this.myVarTableModel.getData().add(DUMMY_RATING_PLAN_VARIABLE_VALID);
                String serviceProvider = VarListUtil.getValueStringForName(this.myVarTableModel.getData(), SERVICE_PROVIDER_LABEL);
                FieldRepository fieldRepository = this.myClassRepository.getFieldContextFieldRepository(serviceProvider);
                this.addVariablesForFieldAndValue(fieldRepository, null, null);
            }
            this.myVarTableModel.fireTableDataChanged();
        } else if (RATING_PLAN_LABEL.equals(label)) {
            FieldRepository fieldRepository = this.myClassRepository.getFieldContextFieldRepository(VarListUtil.getValueStringForName(this.myVarTableModel.getData(), SERVICE_PROVIDER_LABEL), VarListUtil.getValueStringForName(this.myVarTableModel.getData(), RATING_PLAN_LABEL));
            this.addVariablesForFieldAndValue(fieldRepository, null, null);
            this.myVarTableModel.fireTableDataChanged();
        } else if (FIELD_NAME_LABEL.equals(label)) {
            FieldRepository fieldRepository = this.myClassRepository.getFieldContextFieldRepository(VarListUtil.getValueStringForName(this.myVarTableModel.getData(), SERVICE_PROVIDER_LABEL), VarListUtil.getValueStringForName(this.myVarTableModel.getData(), RATING_PLAN_LABEL));
            this.addVariableForValue(fieldRepository, null);
            this.myVarTableModel.fireTableDataChanged();
        }
        this.addVariableChangeListener();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void fillDataSet(DataSet data, ClassRepository myClassRepository) {
        DefaultDataSetAccessor dataSetAccessor = new DefaultDataSetAccessor((AbstractDataSet)data);
        try {
            Document document = XMLUtil.buildDocumentFromString("<Root>" + this.getXml() + "</Root>");
            List<Object[]> rows = this.extractListFromElement(document.getDocumentElement());
            for (Object[] row : rows) {
                Object value;
                FieldContextValueInformation valueInformation = new FieldContextValueInformation(new Vector<Object>(Arrays.asList(row)));
                if (valueInformation.getCollectionType() != FieldHierarchyNode.ComplexType.NONE) {
                    if (valueInformation.getCollectionType() != FieldHierarchyNode.ComplexType.ARRAY && valueInformation.getCollectionType() != FieldHierarchyNode.ComplexType.SET) throw new AssertionError((Object)("Unsupported collection type(" + (Object)((Object)valueInformation.getCollectionType()) + ")!"));
                    value = this.convertArrayModelToDataSetValue((ArrayModel)valueInformation.getValue(), valueInformation.getFieldDefinition());
                } else {
                    value = valueInformation.getValue();
                }
                dataSetAccessor.setValue(valueInformation.getFieldDefinition(), null, null, value);
            }
            return;
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Could not build XML document!");
        }
    }

    protected Object convertArrayModelToDataSetValue(ArrayModel model, FieldHierarchyNode field) {
        Object valueObject;
        if (model.possibleToConvertToOneDimensionalArray()) {
            valueObject = model.toOneDimensionalArray();
            if (field.getComplexType() == FieldHierarchyNode.ComplexType.SET) {
                valueObject = new LinkedHashSet<Object>(Arrays.asList(valueObject));
            }
        } else {
            valueObject = model.toMap();
        }
        return valueObject;
    }

    protected void removeAllAfter(Variable var) {
        int index = this.myVarTableModel.getData().indexOf(var);
        while (index < this.myVarTableModel.getData().size() - 1) {
            this.myVarTableModel.getData().remove(this.myVarTableModel.getData().size() - 1);
        }
    }

    private List<String> getAllInputFieldNames(FieldRepository repository) {
        ArrayList<String> fields = new ArrayList<String>();
        List<FieldHierarchyNode> allFields = repository.getAllFields();
        for (FieldHierarchyNode field : allFields) {
            String parameterType;
            if (!this.isTopLevelField(field) || !field.isLeaf() || !"IN".equals(parameterType = ((FieldDefinition)field).getParameterType())) continue;
            fields.add(field.getCanonicalName());
        }
        return fields;
    }

    private boolean isTopLevelField(FieldHierarchyNode node) {
        return node != null && node.getParent() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Variable createVariableFromField(FieldDefinition field, Object value) {
        Variable var = null;
        String label = field.getCanonicalName();
        if (field.isComplexType()) {
            if (field.isArray()) {
                ArrayModel model = (ArrayModel)value;
                if (model != null) {
                    model.removeTableModelListeners();
                    return new ArrayVariable(label, model, field.getTypedDataType()){

                        @Override
                        public Object getValueObject() {
                            return super.getArrayModel();
                        }

                        @Override
                        protected boolean getForceArrayEdit() {
                            return true;
                        }
                    };
                } else {
                    model = new ArrayModel(new Object[0], new String[]{"Data"});
                }
                return new /* invalid duplicate definition of identical inner class */;
            }
            if (!field.isSet()) throw new AssertionError((Object)"Unsupported complex type!");
            ArrayModel model = (ArrayModel)value;
            if (model != null) {
                model.removeTableModelListeners();
            } else {
                model = new ArrayModel(new Object[0], new String[]{"Data"});
            }
            var = new ArrayVariable(label, model, field.getTypedDataType()){

                @Override
                public Object getValueObject() {
                    return super.getArrayModel();
                }
            };
            ((ArrayVariable)var).actAsSetEditor(true);
            return var;
        }
        try {
            var = VariableFactory.createInputVariable(label, null, field, this.myClassRepository, "", Location.SIMULATION_PANEL);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Could not create input variable! : " + e.getMessage()));
        }
        if (value == null) return var;
        var.setValue(value);
        return var;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 4) {
            return new FieldContextValueInformation((String)super.getValueAt(row, 0), (Boolean)super.getValueAt(row, 1), (String)super.getValueAt(row, 2), (String)super.getValueAt(row, 3), super.getValueAt(row, 4));
        }
        return super.getValueAt(row, column);
    }

    @Override
    public String getXml() {
        Object[] data;
        StringBuilder builder = new StringBuilder("");
        for (Object row : data = this.getDataVector().toArray()) {
            Vector vectorRow = (Vector)row;
            if (vectorRow == null) continue;
            FieldContextValueInformation fieldContextValueInformation = new FieldContextValueInformation(vectorRow);
            FieldHierarchyNode.ComplexType collectionType = fieldContextValueInformation.getCollectionType();
            FieldContextObjectArrayDescription fieldContextDescription = (FieldContextObjectArrayDescription)this.myDescription;
            fieldContextDescription.setColumnCollectionType(4, collectionType);
            boolean containsCollection = collectionType != FieldHierarchyNode.ComplexType.NONE;
            builder.append("<");
            builder.append(XML_TAG);
            builder.append(" ");
            for (int column = 0; column < this.myDescription.getNumberOfColumns(); ++column) {
                if (this.myDescription.getColumnCollectionType(column) != FieldHierarchyNode.ComplexType.NONE) continue;
                builder.append(this.myDescription.getAttribute(column));
                builder.append("=\"");
                String attributeValue = this.myDescription.toXmlAttributeValue(column, vectorRow.get(column));
                builder.append(XMLUtil.escape(attributeValue));
                builder.append("\" ");
            }
            builder.append("ComplexType='").append((Object)collectionType).append("' ");
            builder.append("DataType='").append(fieldContextValueInformation.getDataType()).append("' ");
            if (containsCollection) {
                builder.append(">\n");
                this.printCollectionData(vectorRow, builder);
                builder.append("</").append(XML_TAG).append(">\n");
                continue;
            }
            builder.append("/>\n");
        }
        return builder.toString();
    }

    @Override
    protected List<Object[]> extractListFromElement(Element iterator) {
        ArrayList<Object[]> datalist = new ArrayList<Object[]>();
        NodeList elements = iterator.getElementsByTagName(XML_TAG);
        for (int rowIndex = 0; rowIndex < elements.getLength(); ++rowIndex) {
            Element element = (Element)elements.item(rowIndex);
            Object[] valueArray = new Object[this.myDescription.getNumberOfColumns()];
            String serviceProvider = element.getAttribute(this.myDescription.getAttribute(0));
            Boolean useRatingPlan = Boolean.valueOf(element.getAttribute(this.myDescription.getAttribute(1)));
            String ratingPlan = element.getAttribute(this.myDescription.getAttribute(2));
            String field = element.getAttribute(this.myDescription.getAttribute(3));
            String value = element.getAttribute(this.myDescription.getAttribute(4));
            FieldContextValueInformation fieldContextValueInformation = new FieldContextValueInformation(serviceProvider, useRatingPlan, ratingPlan, field, value);
            FieldContextObjectArrayDescription fieldContextDescription = (FieldContextObjectArrayDescription)this.myDescription;
            fieldContextDescription.setColumnCollectionType(4, fieldContextValueInformation.getCollectionType());
            fieldContextDescription.setValueResolver(4, fieldContextValueInformation.getDataType());
            for (int columnIndex = 0; columnIndex < this.myDescription.getNumberOfColumns(); ++columnIndex) {
                ValueResolver resolver = this.myDescription.getValueResolver(columnIndex);
                Object valueObj = null;
                if (this.myDescription.getColumnCollectionType(columnIndex) == FieldHierarchyNode.ComplexType.NONE) {
                    String attrName = this.myDescription.getAttribute(columnIndex);
                    String valueString = element.hasAttribute(attrName) ? element.getAttribute(attrName) : null;
                    valueObj = this.parseValue(valueString, resolver, columnIndex, rowIndex);
                } else {
                    valueObj = this.parseCollection(element, resolver, columnIndex, rowIndex);
                }
                valueArray[columnIndex] = this.myDescription.convertValueFromXml(columnIndex, valueObj);
            }
            datalist.add(valueArray);
        }
        return datalist;
    }

    static {
        DUMMY_SERVICE_PROVIDER_VARIABLE.setAllowEdit(false);
        DUMMY_USE_RATING_PLAN_VARIABLE.setAllowEdit(false);
        DUMMY_RATING_PLAN_VARIABLE.setAllowEdit(false);
        DUMMY_RATING_PLAN_VARIABLE_VALID.setAllowEdit(false);
        DUMMY_RATING_PLAN_VARIABLE_VALID.setValue("");
        DUMMY_FIELD_NAME_VARIABLE.setAllowEdit(false);
        DUMMY_VALUE_VARIABLE.setAllowEdit(false);
    }

    private class FieldContextValueInformation {
        private final FieldDefinition myFieldDefinition;
        private final Object myValue;

        FieldContextValueInformation(Vector<?> vectorRow) {
            String serviceProvider = (String)vectorRow.get(0);
            Boolean useRatingPlan = (Boolean)vectorRow.get(1);
            String ratingPlan = (String)vectorRow.get(2);
            String field = (String)vectorRow.get(3);
            this.myValue = vectorRow.get(4);
            this.myFieldDefinition = this.createFieldDefinition(serviceProvider, useRatingPlan, ratingPlan, field);
        }

        FieldHierarchyNode getFieldDefinition() {
            return this.myFieldDefinition;
        }

        FieldContextValueInformation(String serviceProvider, Boolean useRatingPlan, String ratingPlan, String field, Object value) {
            this.myValue = value;
            this.myFieldDefinition = this.createFieldDefinition(serviceProvider, useRatingPlan, ratingPlan, field);
        }

        private FieldDefinition createFieldDefinition(String serviceProvider, Boolean useRatingPlan, String ratingPlan, String field) {
            FieldRepository fieldRepository = useRatingPlan != false ? FieldContextDataModel.this.myClassRepository.getFieldContextFieldRepository(serviceProvider, ratingPlan) : FieldContextDataModel.this.myClassRepository.getFieldContextFieldRepository(serviceProvider);
            FieldDefinition fd = (FieldDefinition)fieldRepository.getFieldByName(field);
            if (fd == null) {
                throw new AssertionError((Object)("Field(" + field + ") was not found"));
            }
            return fd;
        }

        DataType getDataType() {
            return this.myFieldDefinition.getTypedDataType();
        }

        Object getValue() {
            return this.myValue;
        }

        FieldHierarchyNode.ComplexType getCollectionType() {
            return this.myFieldDefinition.getComplexType();
        }
    }

    private static class FieldContextTableCellRenderer
    extends DefaultTableCellRenderer {
        private FieldContextTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object informationValue;
            String text = value instanceof FieldContextValueInformation ? ((informationValue = ((FieldContextValueInformation)value).getValue()) instanceof ArrayModel ? "{...}" : String.valueOf(informationValue)) : String.valueOf(value);
            return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        }
    }

    private static class FieldContextObjectArrayDescription
    extends ObjectArrayDescription {
        private static final List<String> ATTRIBUTES = Arrays.asList("serviceProvider", "useRatingPlan", "ratingPlan", "fieldName", "value");
        private static final List<String> LABELS = Arrays.asList("Service Provider", "Use Rating Plan", "Rating Plan", "Field Name", "Value");
        private static final int NR_OF_COLUMNS = 5;
        private static final TableCellRenderer CELL_RENDERER = new FieldContextTableCellRenderer();
        private List<FieldHierarchyNode.ComplexType> myCollectionTypes = new ArrayList<FieldHierarchyNode.ComplexType>(Arrays.asList(FieldHierarchyNode.ComplexType.NONE, FieldHierarchyNode.ComplexType.NONE, FieldHierarchyNode.ComplexType.NONE, FieldHierarchyNode.ComplexType.NONE, FieldHierarchyNode.ComplexType.NONE));
        private List<ValueResolver> myValueResolvers = new ArrayList<DataType>(Arrays.asList(DataType.STRING, DataType.BOOLEAN, DataType.STRING, DataType.STRING, DataType.OBJECT));

        private FieldContextObjectArrayDescription() {
        }

        @Override
        public int getNumberOfColumns() {
            return 5;
        }

        @Override
        public String getAttribute(int col) {
            return ATTRIBUTES.get(col);
        }

        @Override
        public String getLabel(int column) {
            return LABELS.get(column);
        }

        @Override
        public ValueResolver getValueResolver(int column) {
            return this.myValueResolvers.get(column);
        }

        @Override
        public TableCellRenderer getTableCellRenderer(int col) {
            return CELL_RENDERER;
        }

        @Override
        public String toXmlAttributeValue(int col, Object value) {
            String xml;
            if (value instanceof FieldContextValueInformation) {
                FieldContextValueInformation information = (FieldContextValueInformation)value;
                Object informationValue = information.getValue();
                DataType dt = information.getDataType();
                xml = dt.makeValueString(informationValue);
            } else {
                xml = String.valueOf(value);
            }
            return xml;
        }

        @Override
        public Object convertValueFromXml(int col, Object value) {
            return value;
        }

        @Override
        public FieldHierarchyNode.ComplexType getColumnCollectionType(int index) {
            return this.myCollectionTypes.get(index);
        }

        void setColumnCollectionType(int index, FieldHierarchyNode.ComplexType type) {
            this.myCollectionTypes.set(index, type);
        }

        void setValueResolver(int index, ValueResolver resolver) {
            this.myValueResolvers.set(index, resolver);
        }
    }
}

