/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.gui.simulator.SimulationSet;
import com.ericsson.ere.gui.simulator.SimulatorPanel;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CreateSimulationSetDialog
extends JDialog {
    private SimulatorPanel mySimulatorPanel;
    private List<SimulationSet> mySimulationSets;
    private static final String NO_OTHER_SETS_EXIST = "You only have one set!";

    public CreateSimulationSetDialog(SimulatorPanel simulatorPanel, List<SimulationSet> simulationSets, String defaultName) {
        super(GuiServiceCenter.getInstance().getMainWindow(), "Create Simulation Set", true);
        this.mySimulatorPanel = simulatorPanel;
        this.mySimulationSets = simulationSets;
        this.initComponents(defaultName);
        this.setIconImage(RmaDefs.getImageIcon("index_add16.png").getImage());
        this.setSize(300, 280);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
    }

    public void initComponents(String defaultName) {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel("Name");
        final JTextField nameField = new JTextField(defaultName);
        nameField.setName("CreateSimulationSet.JLabel.Name");
        final JRadioButton emptySetButton = new JRadioButton("Create empty set", true);
        final JRadioButton fillSetButton = new JRadioButton("Fill set with cases from");
        fillSetButton.setOpaque(true);
        JPanel fillPanel = new JPanel(new GridBagLayout());
        fillPanel.setOpaque(false);
        fillPanel.setBorder(BorderFactory.createEtchedBorder());
        JCheckBox currentSetBox = new JCheckBox("The current set (" + this.mySimulatorPanel.getSelectedSimulationSet().getName() + ")", true);
        final JCheckBox otherSetButton = new JCheckBox("Other set");
        final JComboBox otherSetField = new JComboBox(this.getComboBoxModel());
        final JCheckBox useSelected = new JCheckBox("Only fill with selected cases");
        currentSetBox.setEnabled(false);
        fillSetButton.setSelected(false);
        otherSetButton.setEnabled(false);
        otherSetField.setEnabled(false);
        useSelected.setEnabled(false);
        emptySetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                emptySetButton.setSelected(true);
                fillSetButton.setSelected(false);
                otherSetButton.setEnabled(false);
                otherSetField.setEnabled(false);
                useSelected.setEnabled(false);
            }
        });
        fillSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fillSetButton.setSelected(true);
                emptySetButton.setSelected(false);
                otherSetButton.setEnabled(CreateSimulationSetDialog.this.mySimulationSets.size() > 1);
                otherSetField.setEnabled(otherSetButton.isSelected());
                useSelected.setEnabled(true);
            }
        });
        otherSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                otherSetField.setEnabled(otherSetButton.isSelected());
            }
        });
        JButton mergeButton = new JButton("Create", RmaDefs.getImageIcon("index_add16.png"));
        mergeButton.setName("CreateSimulationSet.JButton.Create");
        mergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationSet newSet = new SimulationSet(nameField.getText(), CreateSimulationSetDialog.this.mySimulatorPanel, false);
                if (fillSetButton.isSelected()) {
                    newSet.mergeWithSimulationSet(CreateSimulationSetDialog.this.mySimulatorPanel.getSelectedSimulationSet(), useSelected.isSelected());
                    if (otherSetButton.isSelected() && otherSetField.getSelectedItem() != CreateSimulationSetDialog.NO_OTHER_SETS_EXIST) {
                        newSet.mergeWithSimulationSet((SimulationSet)otherSetField.getSelectedItem(), useSelected.isSelected());
                    }
                }
                CreateSimulationSetDialog.this.mySimulatorPanel.addSimulationSet(newSet);
                CreateSimulationSetDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton("Cancel", RmaDefs.getImageIcon("door2_16.png"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateSimulationSetDialog.this.dispose();
            }
        });
        JPanel borderPanel = new JPanel(new GridBagLayout());
        borderPanel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 10, 8, 8), 0, 0));
        borderPanel.add((Component)nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 8, 8, 8), 0, 0));
        borderPanel.add((Component)emptySetButton, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 13, 2, 0), 0, 0));
        borderPanel.add((Component)fillSetButton, new GridBagConstraints(0, 2, 2, 1, 0.5, 0.0, 18, 0, new Insets(0, 12, 8, 8), 0, 0));
        borderPanel.add((Component)fillPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(11, 8, 0, 8), 0, 0));
        fillPanel.add((Component)currentSetBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 8, 0, 8), 0, 0));
        fillPanel.add((Component)otherSetButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 8, 8, 8), 0, 0));
        fillPanel.add(otherSetField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 8, 8, 8), 0, 0));
        fillPanel.add((Component)useSelected, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(8, 8, 8, 8), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)cancelButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 8), 0, 0));
        buttonPanel.add((Component)mergeButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 8), 0, 0));
        borderPanel.add((Component)buttonPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)borderPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ComboBoxModel getComboBoxModel() {
        ArrayList<SimulationSet> sets = new ArrayList<SimulationSet>(this.mySimulationSets.size() - 1);
        if (this.mySimulationSets.size() == 1) {
            return new DefaultComboBoxModel<String>(new String[]{NO_OTHER_SETS_EXIST});
        }
        for (SimulationSet set : this.mySimulationSets) {
            if (set == this.mySimulatorPanel.getSelectedSimulationSet()) continue;
            sets.add(set);
        }
        return new DefaultComboBoxModel<SimulationSet>(sets.toArray(new SimulationSet[0]));
    }
}

