/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search.presenter;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.gui.search.presenter.AbstractTypeSpecificFilterEditPresenter;
import com.ericsson.ere.gui.search.presenter.BranchSearchDataDescriber;
import com.ericsson.ere.gui.search.view.InvalidViewDataException;
import com.ericsson.ere.gui.search.view.SimulationBasedFilterEditView;
import com.ericsson.ere.gui.simulator.AbstractGroupedSimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationFactory;
import com.ericsson.ere.selectiontree.search.VariableHelper;
import com.ericsson.ere.selectiontree.search.filter.BranchFilter;
import com.ericsson.ere.selectiontree.search.filter.SimulationBasedParameterBranchFilter;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.ArrayListModel;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimulationBasedFilterEditPresenter
extends AbstractTypeSpecificFilterEditPresenter {
    public static final String CONTEXT_FIELD_DELIMITER = ">";
    private SimulationBasedFilterEditView myView;
    private ArrayListModel<Parameter> myParameterModel;
    private ContextAwareServiceContainer myServiceContainer;
    private Map<String, String> myInitialSimulationDataByIdentity;
    private Map<String, Variable> myVariablesByIdentity;
    private BranchSearchDataDescriber myDataDescriber;

    public SimulationBasedFilterEditPresenter(SimulationBasedFilterEditView view, ContextAwareServiceContainer serviceContainer) {
        this.myView = view;
        this.myServiceContainer = serviceContainer;
        this.createAndSetModels();
        this.subscribeToViewEvents();
        this.initializeView();
    }

    private void initializeView() {
        this.myView.stopEditingParameter();
    }

    private void createAndSetModels() {
        this.myParameterModel = new ArrayListModel();
        this.myView.setParameterModel(this.myParameterModel);
        this.myDataDescriber = new BranchSearchDataDescriber(this.myServiceContainer);
        SimulationFactory sf = (SimulationFactory)this.myServiceContainer.getService().getSimulationFactory();
        AbstractGroupedSimulationDataPanel simPanel = (AbstractGroupedSimulationDataPanel)sf.createSimulationDataPanel(this.myServiceContainer);
        this.initSimulationVariables(simPanel);
    }

    private void subscribeToViewEvents() {
        this.myView.addParameterEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationBasedFilterEditPresenter.this.addNewParameter();
            }
        });
        this.myView.removeParameterEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationBasedFilterEditPresenter.this.removeParameter();
            }
        });
        this.myView.editParameterEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationBasedFilterEditPresenter.this.startEditingParameter();
            }
        });
    }

    void addNewParameter() {
        Set<String> params = this.getAvailableParameters();
        String[] avalues = params.toArray(new String[params.size()]);
        String selected = this.myView.chooseParameter(avalues);
        if (selected != null) {
            this.resetVariableToInitialValue(selected);
            Parameter p = new Parameter(selected);
            int index = Collections.binarySearch(this.myParameterModel, p);
            assert (index < 0) : "The parameter is not supposed to be in the list!";
            int insertionPoint = -(index + 1);
            this.myParameterModel.add(insertionPoint, p);
            this.setModified();
            params.remove(selected);
            boolean existsMore = false;
            for (String s : params) {
                if (!s.startsWith(p.context + CONTEXT_FIELD_DELIMITER) && s.contains(CONTEXT_FIELD_DELIMITER)) continue;
                existsMore = true;
                break;
            }
            if (!existsMore) {
                this.myView.setParametersLeft(false);
            }
        }
    }

    private Set<String> getAvailableParameters() {
        String selectedContext = null;
        HashSet<String> params = new HashSet<String>();
        for (String id : this.myVariablesByIdentity.keySet()) {
            params.add(id);
        }
        for (Parameter par : this.myParameterModel) {
            params.remove(par.id);
            if (par.context == null) continue;
            assert (selectedContext == null || selectedContext.equals(par.context)) : "Mixed contexts!";
            selectedContext = par.context;
        }
        if (selectedContext != null) {
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                String param = (String)iterator.next();
                if (!param.contains(CONTEXT_FIELD_DELIMITER) || param.startsWith(selectedContext + CONTEXT_FIELD_DELIMITER)) continue;
                iterator.remove();
            }
        }
        return params;
    }

    void removeParameter() {
        Object param = this.myView.getSelectedParameter();
        if (param != null) {
            this.myView.stopEditingParameter();
            this.myParameterModel.remove(param);
            this.setModified();
            this.myView.setParametersLeft(true);
        }
    }

    void startEditingParameter() {
        Parameter param = (Parameter)this.myView.getSelectedParameter();
        if (param != null) {
            Variable var = param.getVariable();
            this.myView.editParameter(param.label, var);
        }
    }

    @Override
    public void populateViewFromFilter(BranchFilter filter) {
        SimulationBasedParameterBranchFilter bfilter = (SimulationBasedParameterBranchFilter)filter;
        this.myParameterModel.clear();
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (String varKey : bfilter.getParameterNames()) {
            Parameter p;
            Variable var = this.myVariablesByIdentity.get(varKey);
            if (var != null) {
                p = new Parameter(varKey);
                VariableHelper.setVariableValueString(var, bfilter.getParameterValue(varKey));
            } else {
                p = new UnknownParameter(varKey, bfilter.getParameterValue(varKey));
            }
            params.add(p);
        }
        this.myParameterModel.addAll(params);
        this.myView.setParametersLeft(!this.getAvailableParameters().isEmpty());
    }

    @Override
    public boolean updateFilterDataFromView(BranchFilter filter) throws InvalidViewDataException {
        this.checkParameters();
        SimulationBasedParameterBranchFilter bfilter = (SimulationBasedParameterBranchFilter)filter;
        bfilter.removeParameterValues();
        for (Parameter p : this.myParameterModel) {
            String value = p.getValue();
            bfilter.setParameterValue(p.id, value);
        }
        bfilter.notifyListeners();
        return true;
    }

    private void checkParameters() throws InvalidViewDataException {
        if (this.myParameterModel.isEmpty()) {
            throw new InvalidViewDataException("The filter must contain at least one parameter.");
        }
        for (Parameter p : this.myParameterModel) {
            Variable var = p.getVariable();
            if (var.isValueValid()) continue;
            String msg = String.format("The parameter %s has an invalid value.", p.label);
            throw new InvalidViewDataException(msg);
        }
    }

    @Override
    public void stopEditingFilter() {
        this.myParameterModel.clear();
        this.myView.stopEditingParameter();
    }

    private void resetVariableToInitialValue(String id) {
        String value = this.myInitialSimulationDataByIdentity.get(id);
        Variable var = this.myVariablesByIdentity.get(id);
        assert (var != null) : "Invalid/unknown id: " + id + " (service = " + this.myServiceContainer.getService().getId() + ")";
        VariableHelper.setVariableValueString(var, value);
    }

    private void initSimulationVariables(AbstractGroupedSimulationDataPanel simPanel) {
        VariableChangeHandler variableChangeHandler = new VariableChangeHandler();
        this.myVariablesByIdentity = new HashMap<String, Variable>();
        this.myInitialSimulationDataByIdentity = new HashMap<String, String>();
        Map<String, Variable> varMap = this.getSimulationVariableMap(simPanel);
        for (Map.Entry<String, Variable> entry : varMap.entrySet()) {
            String label = entry.getKey();
            Variable var = entry.getValue();
            this.myVariablesByIdentity.put(label, var);
            this.myInitialSimulationDataByIdentity.put(label, VariableHelper.getVariableValueString(var));
            var.setDataItem(variableChangeHandler);
        }
    }

    private Map<String, Variable> getSimulationVariableMap(AbstractGroupedSimulationDataPanel simPanel) {
        List<Variable> commonVariables = simPanel.getCommonParameters();
        this.excludeUnnecessaryCommonVariables(commonVariables);
        List<Variable> inputVariables = simPanel.getInputParameters();
        List<Variable> contextVariables = simPanel.getAllInputParameters();
        contextVariables.removeAll(inputVariables);
        if (contextVariables.size() > 0) {
            VarListUtil.removeVariablesByLabel(contextVariables, this.myServiceContainer.getClassRepository().getContextFieldIdentifier());
        }
        HashMap<String, Variable> map = new HashMap<String, Variable>();
        this.addToMap(map, commonVariables, false);
        this.addToMap(map, inputVariables, false);
        this.addToMap(map, contextVariables, true);
        return map;
    }

    private void excludeUnnecessaryCommonVariables(List<Variable> variables) {
        VarListUtil.removeVariablesByLabel(variables, "Comment", "Description");
    }

    private void addToMap(Map<String, Variable> map, List<Variable> variables, boolean deduceContext) {
        ClassRepository rep = this.myServiceContainer.getClassRepository();
        for (Variable var : variables) {
            String paramID = SimulationBasedParameterBranchFilter.getLabelWithoutInputSuffix(var);
            if (paramID.endsWith(" (OUT)")) continue;
            if (deduceContext) {
                FieldDefinition field = rep.getFieldDefinitionByName(paramID);
                if (field == null) continue;
                List<String> contexts = field.getContextNames();
                for (String context : contexts) {
                    String key = context + CONTEXT_FIELD_DELIMITER + paramID;
                    if (map.containsKey(key)) continue;
                    map.put(key, var);
                    var.setKey(key);
                }
                continue;
            }
            map.put(paramID, var);
            var.setKey(paramID);
        }
    }

    private class UnknownParameter
    extends Parameter {
        private final String myValue;
        private final Variable myVariable;

        UnknownParameter(String id, String value) {
            super(id);
            this.myValue = value;
            this.myVariable = new StringVariable("", value);
            this.myVariable.setAllowEdit(false);
        }

        @Override
        protected String getDataDescription() {
            return this.myValue;
        }

        @Override
        protected Variable getVariable() {
            return this.myVariable;
        }

        @Override
        protected String getValue() {
            return this.myValue;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public class Parameter
    implements Comparable<Parameter> {
        final String id;
        final String context;
        final String label;

        Parameter(String id) {
            this.id = id;
            int idx = id.indexOf(SimulationBasedFilterEditPresenter.CONTEXT_FIELD_DELIMITER);
            if (idx >= 0) {
                this.context = id.substring(0, idx);
                this.label = id.substring(idx + SimulationBasedFilterEditPresenter.CONTEXT_FIELD_DELIMITER.length());
            } else {
                this.context = null;
                this.label = id;
            }
        }

        protected String getValue() {
            String value = VariableHelper.getVariableValueString((Variable)SimulationBasedFilterEditPresenter.this.myVariablesByIdentity.get(this.id));
            return value;
        }

        protected Variable getVariable() {
            Variable var = (Variable)SimulationBasedFilterEditPresenter.this.myVariablesByIdentity.get(this.id);
            return var;
        }

        public String toString() {
            String desc = this.getDataDescription();
            String s = this.context == null ? String.format("%s = %s", this.label, desc) : String.format("%s = %s [%s]", this.label, desc, this.context);
            return s;
        }

        protected String getDataDescription() {
            Variable var = (Variable)SimulationBasedFilterEditPresenter.this.myVariablesByIdentity.get(this.id);
            Object data = VariableHelper.getVariableValueObject(var);
            return SimulationBasedFilterEditPresenter.this.myDataDescriber.describeParameterData(this.label, data);
        }

        @Override
        public int compareTo(Parameter o) {
            int result = 0;
            if (this.context != null ^ o.context != null) {
                result = this.context != null ? 1 : -1;
            } else {
                if (this.context != null) {
                    result = this.context.compareToIgnoreCase(o.context);
                }
                if (result == 0) {
                    result = this.label.compareToIgnoreCase(o.label);
                }
            }
            return result;
        }

        public boolean isValid() {
            Variable var = (Variable)SimulationBasedFilterEditPresenter.this.myVariablesByIdentity.get(this.id);
            return var.isValueValid();
        }
    }

    private class VariableChangeHandler
    extends DataItemAdapter {
        private VariableChangeHandler() {
        }

        @Override
        public void setDataItem(Object reference, Object object) {
            Variable var = (Variable)object;
            String id = var.getKey();
            int idx = -1;
            for (int i = 0; i < SimulationBasedFilterEditPresenter.this.myParameterModel.size(); ++i) {
                Parameter p = (Parameter)SimulationBasedFilterEditPresenter.this.myParameterModel.get(i);
                if (!id.equals(p.id)) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                SimulationBasedFilterEditPresenter.this.myParameterModel.set(idx, SimulationBasedFilterEditPresenter.this.myParameterModel.get(idx));
                SimulationBasedFilterEditPresenter.this.setModified();
            }
        }
    }
}

