/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.SettingsComparatorDataSource;
import com.ericsson.ere.gui.search.presenter.BranchSearchResultPresenter;
import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.BranchElementTypeMatcher;
import com.ericsson.ere.selectiontree.search.SettingsBasedBranchComparator;
import com.ericsson.ere.util.InverseComparator;
import com.ericsson.ere.util.Predicate;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.interfaces.TariffStructureNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SettingsComparatorDialogPanel
extends JPanel {
    private JComboBox myParameterSettingsBox;
    private JRadioButton myConditionButton;
    private JRadioButton myNodeButton;
    private JRadioButton myModifierButton;
    private SettingsComparatorDataSource myDataSource;
    private BranchSearchResultPresenter.SortingPriority myPriority;
    private JRadioButton myDescendComparisonButton;
    private JComboBox myElementNameBox;
    private DefaultComboBoxModel myConditionNamesModel;
    private DefaultComboBoxModel myNodeNamesModel;
    private DefaultComboBoxModel myModifierNamesModel;
    private final JLabel sortByLabel = new JLabel("Sort by...");
    private final JLabel basedOnLabel = new JLabel("Based on value of...");

    public SettingsComparatorDialogPanel(SettingsComparatorDataSource dataSource) {
        this.myDataSource = dataSource;
        this.myPriority = dataSource.getPriority();
        this.myConditionNamesModel = new DefaultComboBoxModel<String>(dataSource.getElementNamesForType(2).toArray(new String[0]));
        this.myNodeNamesModel = new DefaultComboBoxModel<String>(dataSource.getElementNamesForType(1).toArray(new String[0]));
        this.myModifierNamesModel = new DefaultComboBoxModel<String>(dataSource.getElementNamesForType(3).toArray(new String[0]));
        this.initLayout(this.findElementTypeToPopulateFor());
        if (dataSource.hasData()) {
            this.fillWithData();
        }
        this.setBorder(new TitledBorder("As " + this.myDataSource.getPriority().toString() + " priority "));
        this.setComponentNames();
    }

    private int findElementTypeToPopulateFor() {
        int type = 1;
        if (this.myConditionNamesModel.getSize() > 0) {
            type = 2;
        } else if (this.myModifierNamesModel.getSize() > 0) {
            type = 3;
        }
        return type;
    }

    private void setComponentNames() {
        this.myParameterSettingsBox.setName("BranchSearch.BranchSearchSettingDialog.JComboBox.Parameter_" + this.myPriority.toString());
        this.myConditionButton.setName("BranchSearch.BranchSearchSettingDialog.JRadioButton.Condition_" + this.myPriority.toString());
        this.myNodeButton.setName("BranchSearch.BranchSearchSettingDialog.JRadioButton.Node_" + this.myPriority.toString());
        this.myModifierButton.setName("BranchSearch.BranchSearchSettingDialog.JRadioButton.Modifier_" + this.myPriority.toString());
        this.myDescendComparisonButton.setName("BranchSearch.BranchSearchSettingDialog.JRadioButton.Descend_" + this.myPriority.toString());
        this.myElementNameBox.setName("BranchSearch.BranchSearchSettingDialog.JComboBox.ElementName_" + this.myPriority.toString());
    }

    private void fillWithData() {
        int elemType = this.myDataSource.getElementType();
        this.myNodeButton.setSelected(elemType == 1);
        this.myConditionButton.setSelected(elemType == 2);
        this.myModifierButton.setSelected(elemType == 3);
        this.setModelForElementNameBox(elemType);
        this.myElementNameBox.setSelectedItem(this.myDataSource.getElementName());
        this.myParameterSettingsBox.setModel(this.getComboBoxModelFor(elemType, this.myDataSource.getElementName()));
        this.myParameterSettingsBox.setSelectedItem(this.myDataSource.getParameter());
        this.myDescendComparisonButton.setSelected(this.myDataSource.isDescending());
    }

    private void setModelForElementNameBox(int elementType) {
        if (elementType == 1) {
            this.myElementNameBox.setModel(this.myNodeNamesModel);
        } else if (elementType == 2) {
            this.myElementNameBox.setModel(this.myConditionNamesModel);
        } else if (elementType == 3) {
            this.myElementNameBox.setModel(this.myModifierNamesModel);
        }
    }

    private void initLayout(int type) {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.sortByLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 5), 0, 0));
        JLabel matchElementsOfTypeLabel = new JLabel("Type:");
        this.add((Component)matchElementsOfTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 5), 0, 0));
        JPanel elementTypesPanel = this.buildElementsTypesPanel(type);
        this.add((Component)elementTypesPanel, new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        JLabel elementNameLabel = new JLabel("Name:");
        this.add((Component)elementNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 5), 0, 0));
        this.myElementNameBox = new JComboBox(this.setModelForElementBox(type));
        this.myElementNameBox.setPreferredSize(new Dimension(160, 25));
        this.myElementNameBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsComparatorDialogPanel.this.myParameterSettingsBox.setModel(SettingsComparatorDialogPanel.this.getComboBoxModelFor(SettingsComparatorDialogPanel.this.getSelectedElementType(), SettingsComparatorDialogPanel.this.getSelectedElementName()));
            }
        });
        this.add((Component)this.myElementNameBox, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.basedOnLabel, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 5), 0, 0));
        JLabel settingLabel = new JLabel("Parameter:");
        this.myParameterSettingsBox = new JComboBox();
        this.myParameterSettingsBox.setModel(this.getComboBoxModelFor(type, this.myElementNameBox.getSelectedItem().toString()));
        this.myParameterSettingsBox.setPreferredSize(new Dimension(160, 25));
        this.add((Component)settingLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 10), 0, 0));
        this.add((Component)this.myParameterSettingsBox, new GridBagConstraints(1, 4, 4, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        JLabel sortingOrderLabel = new JLabel("Order:");
        this.add((Component)sortingOrderLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        JRadioButton regCompareParameterButton = new JRadioButton("Ascend");
        regCompareParameterButton.setSelected(true);
        this.add((Component)regCompareParameterButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 5, 5), 0, 0));
        this.myDescendComparisonButton = new JRadioButton("Descend");
        this.add((Component)this.myDescendComparisonButton, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 5, 5), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(regCompareParameterButton);
        group.add(this.myDescendComparisonButton);
    }

    private ComboBoxModel setModelForElementBox(int type) {
        DefaultComboBoxModel aModel = this.myNodeNamesModel;
        if (type == 2) {
            aModel = this.myConditionNamesModel;
        } else if (type == 3) {
            aModel = this.myModifierNamesModel;
        }
        return aModel;
    }

    private void enableSelectableTypes() {
        Set<String> conds = this.myDataSource.getElementNamesForType(2);
        Set<String> mods = this.myDataSource.getElementNamesForType(3);
        this.myConditionButton.setEnabled(!conds.isEmpty());
        this.myModifierButton.setEnabled(!mods.isEmpty());
    }

    private JPanel buildElementsTypesPanel(int type) {
        JPanel elementsPanel = new JPanel(new GridBagLayout());
        JLabel conditionIconLabel = new JLabel(RmaDefs.getImageIcon("condition16.png"));
        conditionIconLabel.setToolTipText("Condition");
        JLabel nodeIconLabel = new JLabel(RmaDefs.getImageIcon("folder16.png"));
        nodeIconLabel.setToolTipText("Node");
        JLabel modifierIconLabel = new JLabel(RmaDefs.getImageIcon("modifier16.png"));
        modifierIconLabel.setToolTipText("Modifier");
        this.myConditionButton = new JRadioButton();
        this.myConditionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsComparatorDialogPanel.this.myElementNameBox.setModel(SettingsComparatorDialogPanel.this.myConditionNamesModel);
                SettingsComparatorDialogPanel.this.myParameterSettingsBox.setModel(SettingsComparatorDialogPanel.this.getComboBoxModelFor(2, SettingsComparatorDialogPanel.this.myElementNameBox.getSelectedItem().toString()));
            }
        });
        this.myConditionButton.setSelected(type == 2);
        this.myNodeButton = new JRadioButton();
        this.myNodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsComparatorDialogPanel.this.myElementNameBox.setModel(SettingsComparatorDialogPanel.this.myNodeNamesModel);
                SettingsComparatorDialogPanel.this.myParameterSettingsBox.setModel(SettingsComparatorDialogPanel.this.getComboBoxModelFor(1, SettingsComparatorDialogPanel.this.myElementNameBox.getSelectedItem().toString()));
            }
        });
        this.myNodeButton.setSelected(type == 1);
        this.myModifierButton = new JRadioButton();
        this.myModifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsComparatorDialogPanel.this.myElementNameBox.setModel(SettingsComparatorDialogPanel.this.myModifierNamesModel);
                SettingsComparatorDialogPanel.this.myParameterSettingsBox.setModel(SettingsComparatorDialogPanel.this.getComboBoxModelFor(3, SettingsComparatorDialogPanel.this.myElementNameBox.getSelectedItem().toString()));
            }
        });
        this.myModifierButton.setSelected(type == 3);
        ButtonGroup elementGroup = new ButtonGroup();
        elementGroup.add(this.myConditionButton);
        elementGroup.add(this.myNodeButton);
        elementGroup.add(this.myModifierButton);
        this.enableSelectableTypes();
        elementsPanel.add((Component)nodeIconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        elementsPanel.add((Component)this.myNodeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 5), 0, 0));
        elementsPanel.add((Component)conditionIconLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        elementsPanel.add((Component)this.myConditionButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 5), 0, 0));
        elementsPanel.add((Component)modifierIconLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        elementsPanel.add((Component)this.myModifierButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
        return elementsPanel;
    }

    public BranchSearchResultPresenter.SortingPriority getPriority() {
        return this.myPriority;
    }

    public Comparator<Branch> getComparator() {
        Comparator<Branch> comparator = null;
        Predicate<TariffStructureNode> matcher = this.createMatcher();
        String settingString = (String)this.myParameterSettingsBox.getSelectedItem();
        if (matcher != null) {
            comparator = new SettingsBasedBranchComparator(matcher, settingString);
            if (this.myDescendComparisonButton.isSelected()) {
                comparator = InverseComparator.wrap(comparator);
            }
        }
        return comparator;
    }

    public String getSelectedParameter() {
        return this.myParameterSettingsBox.getSelectedItem().toString();
    }

    public int getSelectedElementType() {
        int result = 0;
        if (this.myNodeButton.isSelected()) {
            result = 1;
        } else if (this.myConditionButton.isSelected()) {
            result = 2;
        } else if (this.myModifierButton.isSelected()) {
            result = 3;
        } else {
            throw new IllegalStateException("Element type does not seem to be selected.");
        }
        return result;
    }

    public boolean getIsDescendingOrder() {
        return this.myDescendComparisonButton.isSelected();
    }

    private ComboBoxModel getComboBoxModelFor(int elementType, String name) {
        return new DefaultComboBoxModel<String>(this.myDataSource.getParameterSettingsFor(elementType, name).toArray(new String[0]));
    }

    private Predicate<TariffStructureNode> createMatcher() {
        ArrayList<Integer> selectedElementsList = new ArrayList<Integer>();
        if (this.myNodeButton.isSelected()) {
            selectedElementsList.add(1);
        }
        if (this.myConditionButton.isSelected()) {
            selectedElementsList.add(2);
        }
        if (this.myModifierButton.isSelected()) {
            selectedElementsList.add(3);
        }
        return selectedElementsList.size() > 0 ? BranchElementTypeMatcher.createMatcher(selectedElementsList.toArray(new Integer[0])) : null;
    }

    public String getSelectedElementName() {
        return this.myElementNameBox.getSelectedItem().toString();
    }
}

