/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.SettingsComparatorDataSource;
import com.ericsson.ere.gui.search.SettingsComparatorDialogPanel;
import com.ericsson.ere.gui.search.presenter.BranchSearchResultPresenter;
import com.ericsson.ere.selectiontree.search.Branch;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SettingsComparatorDialog
extends JDialog {
    private JButton myOkButton;
    private List<SettingsComparatorDataSource> myDataSources;
    private Map<BranchSearchResultPresenter.SortingPriority, SettingsComparatorDialogPanel> myPanels;

    public SettingsComparatorDialog(JComponent owner, List<SettingsComparatorDataSource> dataSources) {
        if (dataSources.size() == 0 || dataSources.size() > 3) {
            throw new IllegalArgumentException("Invalid number of data sources (1-3).");
        }
        this.myDataSources = dataSources;
        this.setLayout(new GridBagLayout());
        this.init();
        this.setModal(true);
        this.setLocationRelativeTo(owner);
        this.setMinimumSize(new Dimension(300, 230));
        this.setComponentNames();
    }

    private void setComponentNames() {
        this.setName("BranchSearch.BranchSearchSettingDialog");
        this.myOkButton.setName("BranchSearch.OkButton");
    }

    private void init() {
        this.setTitle("Define parameter to sort by");
        this.buildPanels();
        this.buildButton();
        this.pack();
    }

    private void buildPanels() {
        this.myPanels = new HashMap<BranchSearchResultPresenter.SortingPriority, SettingsComparatorDialogPanel>();
        JPanel contentPane = new JPanel(new GridBagLayout());
        int verticalindex = 0;
        for (SettingsComparatorDataSource dataSource : this.myDataSources) {
            SettingsComparatorDialogPanel panel = new SettingsComparatorDialogPanel(dataSource);
            contentPane.add((Component)panel, new GridBagConstraints(0, verticalindex, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.myPanels.put(dataSource.getPriority(), panel);
            ++verticalindex;
        }
        JScrollPane contentScroll = new JScrollPane(contentPane);
        contentScroll.setHorizontalScrollBarPolicy(31);
        contentScroll.setVerticalScrollBarPolicy(20);
        contentScroll.setBorder(null);
        this.add((Component)contentScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 0, 10, 0), 0, 0));
    }

    private void buildButton() {
        this.myOkButton = new JButton("OK");
        this.myOkButton.setEnabled(true);
        this.myOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsComparatorDialog.this.dispose();
            }
        });
        this.add((Component)this.myOkButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 10, 10), 0, 0));
    }

    public boolean hasSettingsForPrio(BranchSearchResultPresenter.SortingPriority prio) {
        boolean result = false;
        for (SettingsComparatorDataSource dataSource : this.myDataSources) {
            if (!dataSource.getPriority().equals((Object)prio)) continue;
            result = this.myPanels.get((Object)prio).getComparator() != null;
            break;
        }
        return result;
    }

    public SettingsComparatorDataSource getDataSourceForPrio(BranchSearchResultPresenter.SortingPriority prio) {
        SettingsComparatorDialogPanel panel = this.myPanels.get((Object)prio);
        Comparator<Branch> comp = panel.getComparator();
        String param = panel.getSelectedParameter();
        String elemName = panel.getSelectedElementName();
        int elementType = panel.getSelectedElementType();
        boolean isDescending = panel.getIsDescendingOrder();
        return SettingsComparatorDataSource.createDataContainer(comp, elemName, param, elementType, prio, isDescending, this.myDataSources.get(0).getAllParameterSettings());
    }
}

