/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.presenter.BranchSearchResultPresenter;
import com.ericsson.ere.selectiontree.search.Branch;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SettingsComparatorDataSource {
    private final int myElementType;
    private final String mySelectedElement;
    private final Comparator<Branch> myComparator;
    private final BranchSearchResultPresenter.SortingPriority myPrio;
    private final boolean myHasData;
    private boolean myIsDescending;
    private Map<Integer, Map<String, Set<String>>> mySettings;
    private String mySelectedParameter;

    private SettingsComparatorDataSource(Comparator<Branch> comp, String selectedParameter, int elementType, BranchSearchResultPresenter.SortingPriority prio, boolean isDescending, Map<Integer, Map<String, Set<String>>> settings, String selectedElement) {
        this.myComparator = comp;
        this.mySelectedParameter = selectedParameter;
        this.mySelectedElement = selectedElement;
        this.myElementType = elementType;
        this.myPrio = prio;
        this.myHasData = true;
        this.myIsDescending = isDescending;
        this.mySettings = settings;
    }

    private SettingsComparatorDataSource(BranchSearchResultPresenter.SortingPriority prio, Map<Integer, Map<String, Set<String>>> settings) {
        this.myComparator = null;
        this.mySelectedParameter = null;
        this.myElementType = 2;
        this.mySelectedElement = null;
        this.myPrio = prio;
        this.myHasData = false;
        this.myIsDescending = false;
        this.mySettings = settings;
    }

    public int getElementType() {
        return this.myElementType;
    }

    public Set<String> getParameterSettingsFor(int elementType, String name) {
        SettingsComparatorDataSource.checkType(elementType);
        Set<String> retSet = this.mySettings.get(elementType).get(name);
        if (retSet == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(retSet);
    }

    public Set<String> getElementNamesForType(int elementType) {
        assert (elementType == 1 || elementType == 2 || elementType == 3);
        return Collections.unmodifiableSet(new HashSet<String>(this.mySettings.get(elementType).keySet()));
    }

    public Map<Integer, Map<String, Set<String>>> getAllParameterSettings() {
        return Collections.unmodifiableMap(this.mySettings);
    }

    public String getElementName() {
        return this.mySelectedElement;
    }

    public String getParameter() {
        return this.mySelectedParameter;
    }

    public Comparator<Branch> getComparator() {
        return this.myComparator;
    }

    public BranchSearchResultPresenter.SortingPriority getPriority() {
        return this.myPrio;
    }

    public boolean hasData() {
        return this.myHasData;
    }

    public boolean isDescending() {
        return this.myIsDescending;
    }

    public static SettingsComparatorDataSource createDataContainer(Comparator<Branch> comp, String element, String parameter, int elementType, BranchSearchResultPresenter.SortingPriority prio, boolean isDescending, Map<Integer, Map<String, Set<String>>> settingsMap) {
        SettingsComparatorDataSource.checkType(elementType);
        return new SettingsComparatorDataSource(comp, parameter, elementType, prio, isDescending, settingsMap, element);
    }

    private static void checkType(int type) {
        if (type != 1 && type != 2 && type != 3) {
            throw new IllegalArgumentException("Element types must be of the type node, condition or modifier.");
        }
    }

    public static SettingsComparatorDataSource createEmptyDataContainer(BranchSearchResultPresenter.SortingPriority prio, Map<Integer, Map<String, Set<String>>> settingsMap) {
        return new SettingsComparatorDataSource(prio, settingsMap);
    }
}

