/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.view.ElementBasedFilterEditView;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.AdvancedSearchPanel;
import ericsson.ere.gui.ratingrules.nodes.BooleanTest;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ElementBasedFilterEditPanel
extends JPanel
implements ElementBasedFilterEditView {
    private static final String[] SELECTORS = new String[]{RmaDefs.getStringResource("ratingrules.find.selector.0"), RmaDefs.getStringResource("ratingrules.find.selector.1"), RmaDefs.getStringResource("ratingrules.find.selector.3")};
    private static final int NUMBER_OF_PREDICATE_ROWS = 3;
    private Vector<String> mySelectors = new Vector<String>(Arrays.asList(SELECTORS));
    private AdvancedSearchPanel myPanel = AdvancedSearchPanel.buildPanelWithPredicates(this.mySelectors, 3);

    public ElementBasedFilterEditPanel() {
        super(new GridBagLayout());
        this.add((Component)this.myPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myPanel.addPanelChangeListener(new PanelChangeListener());
    }

    @Override
    public BooleanTest getPredicate() {
        return this.myPanel.createAdvancedPredicate();
    }

    @Override
    public void setPredicate(BooleanTest predicate) {
        if (predicate != null) {
            this.myPanel.populatePanel(predicate);
        }
    }

    @Override
    public void stopEditing() {
        this.myPanel.setEnabled(false);
    }

    private class PanelChangeListener
    extends KeyAdapter
    implements ItemListener,
    ActionListener,
    AncestorListener {
        private PanelChangeListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.fireEvent();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEvent();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.fireEvent();
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            if (ElementBasedFilterEditPanel.this.isShowing()) {
                this.fireEvent();
            }
        }

        private void fireEvent() {
            ElementBasedFilterEditPanel.this.firePropertyChange("filter-is-modified", false, true);
        }
    }
}

