/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.BranchSearchSearchPanel;
import com.ericsson.ere.gui.search.BranchSearchStateHandler;
import com.ericsson.ere.gui.search.BranchSearchUIContext;
import com.ericsson.ere.gui.search.presenter.BranchSearchSearchPresenter;
import com.ericsson.ere.gui.search.view.BranchSearchSearchView;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.help.HelpSystem;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.management.ContextAwareServiceContainer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class BranchSearchFrame
extends RmaFrameSupport {
    private JPanel myCards;
    private BranchSearchSearchView myMainView;

    public BranchSearchFrame(ContextAwareServiceContainer serviceContainer, File storage, TSTariffStructure root, BranchSearchUIContext ctx) {
        super("Search for branches in '" + ctx.getOwnerFrame().getTitle() + "'");
        HelpSystem.getInstance().enableHelpKey(this, this.getClass().toString());
        this.setPreferredSize(new Dimension(600, 530));
        this.setMinimumSize(new Dimension(600, 530));
        this.setDefaultCloseOperation(2);
        this.setFrameIcon(RmaDefs.getImageIcon("find_selection.png"));
        this.setName("RatingRuleFrame.BranchSearch");
        BranchSearchStateHandler stateHandler = new BranchSearchStateHandler(serviceContainer.getClassRepository(), root, this, ctx);
        BranchSearchSearchPanel searchCard = new BranchSearchSearchPanel();
        this.myMainView = searchCard;
        new BranchSearchSearchPresenter(searchCard, serviceContainer, storage, stateHandler);
        this.configureOwnerFrame(ctx.getOwnerFrame());
        this.initLayout(searchCard);
    }

    private void configureOwnerFrame(RmaFrameSupport frame) {
        frame.addOkToDiscardCallback(new RmaFrameSupport.FrameCallback<Boolean>(){

            @Override
            public Boolean call(RmaFrameSupport frame) {
                return BranchSearchFrame.this.isClosed() || BranchSearchFrame.this.isOkToClose(frame);
            }
        });
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (!BranchSearchFrame.this.isClosed()) {
                    BranchSearchFrame.this.dispose();
                }
            }
        });
    }

    @Override
    public boolean isOkToDiscardChanges() {
        boolean yes = true;
        if (this.myMainView.getFilterEditView().isModified()) {
            yes = this.myMainView.askYesNoQuestion("The filter being edited has unsaved changes that will be lost. Do you want to close anyway?");
        }
        return yes;
    }

    private boolean isOkToClose(RmaFrameSupport owner) {
        boolean yes;
        int result = DialogFactory.showOptionDialog(owner, "Closing associated branch search for '" + owner.getTitle() + "'...", "Closing the selection tree will close the associated branch search as well.\nClose selection tree and branch search?", new String[]{"Yes", "No"});
        boolean bl = yes = result == 0;
        if (yes) {
            yes = this.isOkToDiscardChanges();
        }
        return yes;
    }

    private void initLayout(JPanel filterCard) {
        this.setLayout(new CardLayout());
        this.myCards = new JPanel(new CardLayout());
        this.addCard(filterCard, "Branch Search Filter Card");
        this.add((Component)this.myCards, "Branch Search Cards");
        this.showView("Branch Search Filter Card");
        this.pack();
    }

    void showView(String identifier) {
        CardLayout cl = (CardLayout)this.myCards.getLayout();
        cl.show(this.myCards, identifier);
        this.myCards.requestFocus();
    }

    void addCard(JPanel resultCard, String identifier) {
        this.myCards.add((Component)resultCard, identifier);
        HelpSystem.getInstance().enableHelpKey(resultCard, this.getClass().toString());
    }
}

