/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.charging.common.NullStatusInterface;
import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.gui.search.AbstractViewPanel;
import com.ericsson.ere.gui.search.BranchSearchFilterType;
import com.ericsson.ere.gui.search.view.BranchSearchFilterEditView;
import com.ericsson.ere.gui.search.view.TypeSpecificFilterEditView;
import com.ericsson.ere.swing.EventSource;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.documents.StringDocument;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class BranchSearchFilterEditPanel
extends AbstractViewPanel
implements BranchSearchFilterEditView {
    private static final String CANCEL_EDIT_ICON = "cancel_edit.png";
    private static final String SAVE_FILTER_ICON = "commit_edit.png";
    private static final String NEW_INDICATOR_ICON = "cube_blue_new_16.png";
    private static final String MODIFIED_INDICATOR_ICON = "disk_blue_warning_16.png";
    private EventSource mySaveFilterEvent = new EventSource();
    private EventSource myStopEditFilterEvent = new EventSource();
    private StringVariable myFilterNameVariable;
    private JComponent myFilterIsNewIndicator;
    private JComponent myFilterIsModifiedIndicator;
    private JPanel myTypeSpecificPanelHolder;
    private JPanel myTypeSpecificView;
    private static final String FILTER_NEW_TOOLTIP = "This is a new filter";
    private static final String FILTER_MODIFIED_TOOLTIP = "This filter has been modified";
    private static final String SAVE_FILTER_TOOLTIP = "Commit filter changes";
    private static final String STOP_FILTER_EDIT_TOOLTIP = "Cancel editing of the current filter";

    public BranchSearchFilterEditPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.myFilterNameVariable = new StringVariable("", "", this.createNameDocument());
        this.myFilterNameVariable.setDataItem(new DataItemAdapter(){

            @Override
            public void setDataItem(Object reference, Object object) {
                BranchSearchFilterEditPanel.this.updateModified(true);
            }
        });
        this.myFilterIsNewIndicator = this.createNewFilterIndicator();
        this.myFilterIsNewIndicator.setVisible(false);
        this.myFilterIsModifiedIndicator = this.createModifiedFilterIndicator();
        this.myFilterIsModifiedIndicator.setVisible(false);
        this.myTypeSpecificPanelHolder = new JPanel(new BorderLayout());
        JPanel topPanel = this.createTopPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.myTypeSpecificPanelHolder, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    private Document createNameDocument() {
        StringDocument doc = new StringDocument(200L, false);
        doc.setStatusHandler(new NullStatusInterface());
        return doc;
    }

    private JPanel createTopPanel() {
        JPanel indicationPanel = new JPanel(new FlowLayout(0, 0, 0));
        indicationPanel.add(this.myFilterIsNewIndicator);
        indicationPanel.add(this.myFilterIsModifiedIndicator);
        indicationPanel.setPreferredSize(new Dimension(42, 16));
        indicationPanel.setOpaque(false);
        JButton saveButton = this.mySaveFilterEvent.createButton("", RmaDefs.getImageIcon(SAVE_FILTER_ICON), SAVE_FILTER_TOOLTIP);
        JButton stopEditButton = this.myStopEditFilterEvent.createButton("", RmaDefs.getImageIcon(CANCEL_EDIT_ICON), STOP_FILTER_EDIT_TOOLTIP);
        saveButton.setName("BranchSearchFilterEditPanel.JButton.CommitEdit");
        stopEditButton.setName("BranchSearchFilterEditPanel.JButton.StopEdit");
        JPanel topPanel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel("Name:");
        JTextField nameEditor = (JTextField)this.myFilterNameVariable.getEditor();
        Dimension d = nameEditor.getPreferredSize();
        nameEditor.setPreferredSize(new Dimension(180, d.height));
        nameEditor.setName("BranchSearchFilterEditPanel.JTextField.FilterName");
        Insets insets = new Insets(0, 0, 0, 5);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1280, 0, insets, 0, 0);
        topPanel.add((Component)nameLabel, gbc);
        gbc.gridx = -1;
        topPanel.add((Component)nameEditor, gbc);
        topPanel.add((Component)indicationPanel, gbc);
        gbc.weightx = 1.0;
        gbc.anchor = 1536;
        topPanel.add((Component)saveButton, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbc.insets.right = 0;
        topPanel.add((Component)stopEditButton, gbc);
        return topPanel;
    }

    private void showTypeSpecificPanel(BranchSearchFilterType type) {
        assert (this.myTypeSpecificPanelHolder.getComponentCount() == 0);
        this.myTypeSpecificView = type.createTypeSpecificViewPanel();
        assert (this.myTypeSpecificView instanceof TypeSpecificFilterEditView);
        this.myTypeSpecificView.addPropertyChangeListener("filter-is-modified", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BranchSearchFilterEditPanel.this.updateModified((Boolean)evt.getNewValue());
            }
        });
        this.myTypeSpecificPanelHolder.add((Component)this.myTypeSpecificView, "Center");
    }

    private JComponent createModifiedFilterIndicator() {
        JLabel lbl = new JLabel(RmaDefs.getImageIcon(MODIFIED_INDICATOR_ICON));
        lbl.setToolTipText(FILTER_MODIFIED_TOOLTIP);
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        return lbl;
    }

    private JComponent createNewFilterIndicator() {
        JLabel lbl = new JLabel(RmaDefs.getImageIcon(NEW_INDICATOR_ICON));
        lbl.setToolTipText(FILTER_NEW_TOOLTIP);
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        return lbl;
    }

    @Override
    public BranchSearchFilterType askForTypeOfFilter() {
        String title = "Select filter type";
        TypedDropDownVariable<BranchSearchFilterType> selector = new TypedDropDownVariable<BranchSearchFilterType>(title, BranchSearchFilterType.values(), new BranchSearchFilterTypeLabeler());
        int result = JOptionPane.showOptionDialog(this, selector.getEditor(), title, -1, 3, null, new Object[]{"OK", "Cancel"}, "OK");
        return result == 0 ? selector.getSelectedItem() : null;
    }

    @Override
    public String getFilterName() {
        String name = this.myFilterNameVariable.getValueString();
        if (!this.myFilterNameVariable.isValueValid()) {
            name = "";
        }
        return name;
    }

    @Override
    public EventSource saveFilterEvent() {
        return this.mySaveFilterEvent;
    }

    @Override
    public EventSource stopEditFilterEvent() {
        return this.myStopEditFilterEvent;
    }

    @Override
    public void startEditingFilter(String name, BranchSearchFilterType filterType) {
        GuiUtil.setContainerEnabled(this, true);
        this.myFilterNameVariable.setValue(name);
        ((JComponent)this.myFilterNameVariable.getEditor()).setToolTipText("<html>Original filter name: <b>" + name + "</b>");
        this.showTypeSpecificPanel(filterType);
    }

    @Override
    public void stopEditingFilter() {
        this.myFilterNameVariable.setValue(" ");
        ((JComponent)this.myFilterNameVariable.getEditor()).setToolTipText(null);
        this.myTypeSpecificPanelHolder.removeAll();
        this.updateModified(false);
        this.setFilterIsNew(false);
        GuiUtil.setContainerEnabled(this, false);
    }

    @Override
    public void setFilterIsNew(boolean isNew) {
        this.myFilterIsNewIndicator.setVisible(isNew);
        this.updateModified(isNew & true);
        if (isNew) {
            ((JComponent)this.myFilterNameVariable.getEditor()).requestFocusInWindow();
        }
    }

    @Override
    public boolean isModified() {
        return this.myFilterIsModifiedIndicator.isVisible();
    }

    @Override
    public TypeSpecificFilterEditView getTypeSpecificFilterEditView() {
        return (TypeSpecificFilterEditView)((Object)this.myTypeSpecificView);
    }

    private void updateModified(boolean modified) {
        this.myFilterIsModifiedIndicator.setVisible(modified);
    }

    private final class BranchSearchFilterTypeLabeler
    implements TypedDropDownVariable.ItemLabeler<BranchSearchFilterType> {
        private BranchSearchFilterTypeLabeler() {
        }

        @Override
        public String getDisplayStringFor(BranchSearchFilterType object, int index) {
            return object.getReadableName();
        }
    }
}

