/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.BranchSearchTableModelImpl;
import com.ericsson.ere.selectiontree.search.BranchSearchGUIUtil;
import com.ericsson.ere.selectiontree.search.BranchSearchUtil;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.interfaces.TariffStructureNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class BranchElementCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final Color LESS_GRAY = new Color(210, 210, 210);
    public static final Color SELECTION_BLUE = new Color(184, 207, 229);
    protected static Border EMPTY_BORDER = new EmptyBorder(2, 2, 2, 2);
    protected static Border SELECTED_BORDER = new BevelBorder(1);
    private boolean myIsRowBased;

    public BranchElementCellRenderer(boolean rowBased) {
        this.setOpaque(true);
        this.myIsRowBased = rowBased;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String valueStr = "";
        if (value instanceof TariffStructureNode) {
            TariffStructureNode tsNode = (TariffStructureNode)value;
            valueStr = this.getDescriptiveString(tsNode);
            this.setIcon(this.getTypeSpecificIcon(tsNode));
            this.setText(valueStr);
            this.setToolTipText(this.getTooltipString(tsNode));
            this.setBorder(this.getBorderForCell(tsNode, isSelected));
            if (isSelected) {
                this.setBackground(SELECTION_BLUE);
            } else {
                this.setBackground(this.getCellBackgroundColor(row, column));
            }
        } else {
            this.setIcon(null);
            this.setText("");
            this.setToolTipText(null);
            this.setBackground(this.getCellBackgroundColor(row, column));
            this.setBorder(EMPTY_BORDER);
        }
        return this;
    }

    private Border getBorderForCell(TariffStructureNode node, boolean isSelected) {
        Border borderToUse;
        if (this.myIsRowBased) {
            borderToUse = EMPTY_BORDER;
        } else {
            int childLevel;
            Integer lvl = SelectionTreeUtil.getElementData(node, BranchSearchTableModelImpl.ELEMENT_CHILD_LEVEL, Integer.class);
            int n = childLevel = lvl != null ? lvl : 0;
            if (childLevel > 0) {
                int leftInset = 2;
                borderToUse = isSelected ? new BevelBorderCustomInsets(1, leftInset) : new EmptyBorder(2, leftInset += 10 * childLevel, 2, 2);
            } else {
                borderToUse = isSelected ? SELECTED_BORDER : EMPTY_BORDER;
            }
        }
        return borderToUse;
    }

    private Color getCellBackgroundColor(int row, int column) {
        int index;
        int n = index = this.myIsRowBased ? row : column;
        if (index % 2 == 0) {
            return Color.WHITE;
        }
        return LESS_GRAY;
    }

    private Icon getTypeSpecificIcon(TariffStructureNode value) {
        ImageIcon icon = null;
        if (SelectionTreeUtil.isNode(value)) {
            icon = RmaDefs.getImageIcon("folder16.png");
        } else if (SelectionTreeUtil.isCondition(value)) {
            icon = RmaDefs.getImageIcon("condition16.png");
        } else if (SelectionTreeUtil.isModifier(value)) {
            icon = RmaDefs.getImageIcon("modifier16.png");
        } else if (!BranchSearchUtil.isDefinitionsNode(value)) {
            if (value.getNodeType() == 0) {
                icon = RmaDefs.getImageIcon("text_tree.png");
            } else {
                throw new AssertionError((Object)"Unknown node type");
            }
        }
        return icon;
    }

    private String getDescriptiveString(TariffStructureNode value) {
        String infoString = "";
        try {
            infoString = BranchSearchGUIUtil.getDescriptionForProfile(value);
        }
        catch (Exception ex) {
            infoString = value.getNodeId();
        }
        return infoString;
    }

    private String getTooltipString(TariffStructureNode value) {
        String infoString;
        try {
            infoString = BranchSearchGUIUtil.getAdditionalInfoForProfile(value);
        }
        catch (Exception ex) {
            infoString = "";
        }
        return infoString;
    }

    class BevelBorderCustomInsets
    extends BevelBorder {
        private int myLeftInset;

        public BevelBorderCustomInsets(int bevelType, int leftInset) {
            super(bevelType);
            this.myLeftInset = leftInset;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, this.myLeftInset, 2, 2);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 2;
            insets.top = 2;
            insets.left = 2;
            insets.left = this.myLeftInset;
            return insets;
        }
    }
}

