/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.ratingrules.actions;

import com.ericsson.ere.gui.ratingrules.actions.SelectionTreeActionContext;
import com.ericsson.ere.swing.ActionBuilder;
import com.ericsson.ere.swing.ConditionallyEnabledAbstractAction;
import com.ericsson.ere.swing.DispatchActionEvent;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public abstract class SelectionTreeMenuAction
extends ConditionallyEnabledAbstractAction<SelectionTreeActionContext> {
    @Override
    public final boolean shouldBeEnabled(SelectionTreeActionContext ctx) {
        Boolean shouldBeEnabled = null;
        shouldBeEnabled = this.calculateEnableValue(shouldBeEnabled, this.enabledDueToMultipleNodesSelected(ctx));
        shouldBeEnabled = this.calculateEnableValue(shouldBeEnabled, this.enabledDueToInvalidNodeSelected(ctx));
        shouldBeEnabled = this.calculateEnableValue(shouldBeEnabled, this.internalShouldBeEnabled(ctx));
        ActionBuilder.VisibilityController vc = (ActionBuilder.VisibilityController)this.getValue("visibility-controller-instance");
        if (vc != null && !vc.shouldBeVisible(this, null)) {
            shouldBeEnabled = false;
        }
        return shouldBeEnabled;
    }

    private Boolean enabledDueToMultipleNodesSelected(SelectionTreeActionContext ctx) {
        Boolean retVal = null;
        if (this.isMultipleNodesSelected(ctx)) {
            if (Boolean.TRUE == this.getValue("disabled-multi-select")) {
                retVal = false;
            } else if (Boolean.TRUE == this.getValue("enabled-multi-select")) {
                retVal = true;
            }
        }
        return retVal;
    }

    private Boolean enabledDueToInvalidNodeSelected(SelectionTreeActionContext ctx) {
        Boolean retVal = null;
        if (this.isInvalidNodeSelected(ctx)) {
            if (Boolean.TRUE == this.getValue("disabled-invalid-node-select")) {
                retVal = false;
            } else if (Boolean.TRUE == this.getValue("enabled-invalid-node-select")) {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean isInvalidNodeSelected(SelectionTreeActionContext ctx) {
        boolean retVal = false;
        for (TreePath treePath : ctx.selectionPaths()) {
            Object node = treePath.getLastPathComponent();
            if (!(node instanceof TSElement) || ((TSElement)node).isNodeValid()) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private boolean isMultipleNodesSelected(SelectionTreeActionContext ctx) {
        return ctx.selectionPaths().length > 1;
    }

    private Boolean calculateEnableValue(Boolean currentValue, Boolean input) {
        Boolean newValue = input != null ? (currentValue == null ? input : Boolean.valueOf(currentValue & input)) : currentValue;
        return newValue;
    }

    protected boolean internalShouldBeEnabled(SelectionTreeActionContext ctx) {
        return this.isEnabled();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        assert (e instanceof DispatchActionEvent) : "Not a DispatchActionEvent";
        DispatchActionEvent de = (DispatchActionEvent)e;
        SelectionTreeActionContext ctx = (SelectionTreeActionContext)de.getDispatchPayload();
        if (this.shouldBeEnabled(ctx)) {
            this.internalActionPerformed(e, ctx);
        }
    }

    protected abstract void internalActionPerformed(ActionEvent var1, SelectionTreeActionContext var2);
}

