/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.ratingrules;

import com.ericsson.ere.exception.UncheckedInterruptedException;
import com.ericsson.ere.gui.navigator.NavigatorFileChooser;
import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.ratingrules.SelectionTreeActionHandler;
import com.ericsson.ere.gui.ratingrules.SelectionTreeSaveHandler;
import com.ericsson.ere.gui.ratingrules.SelectionTreeUtil;
import com.ericsson.ere.gui.ratingrules.TariffClipboardOwner;
import com.ericsson.ere.gui.search.BranchSearchFrame;
import com.ericsson.ere.gui.search.BranchSearchUIContext;
import com.ericsson.ere.gui.simulator.SimulatorPanel;
import com.ericsson.ere.gui.simulator.SimulatorPanelInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGeneratorWizard;
import com.ericsson.ere.gui.undoredo.CreateNodeEdit;
import com.ericsson.ere.gui.undoredo.DeleteNodeEdit;
import com.ericsson.ere.gui.undoredo.MoveNodeDownEdit;
import com.ericsson.ere.gui.undoredo.MoveNodeUpEdit;
import com.ericsson.ere.gui.undoredo.OpenTreeEdit;
import com.ericsson.ere.gui.undoredo.QueryableCompoundEdit;
import com.ericsson.ere.gui.undoredo.RMAUndoManager;
import com.ericsson.ere.gui.undoredo.UndoableTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.Version;
import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.selectiontree.RmaClipboardHandler;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.FindPalette;
import ericsson.ere.gui.ratingrules.PasteFailedException;
import ericsson.ere.gui.ratingrules.RatingJTreeErrorHandler;
import ericsson.ere.gui.ratingrules.RatingJTreeNodeFactory;
import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.gui.ratingrules.RatingRuleNodeCopyAsTransferable;
import ericsson.ere.gui.ratingrules.RatingRuleNodeTransferable;
import ericsson.ere.gui.ratingrules.ShowFindParametersPalette;
import ericsson.ere.gui.ratingrules.nodes.LinkRefCellRenderer;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffCellRenderer;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.ArrayListModel;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.PaletteFrame;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.DefaultTariffStructureVisitor;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.interfaces.RatingRuleTreeNodeFactory;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import ericsson.ere.ratingrules.AmbiguousLinkTargetException;
import ericsson.ere.ratingrules.BuildErrorCounter;
import ericsson.ere.ratingrules.CycleDetectedException;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.ratingrules.UnresolvedLinkTargetException;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SelectionTreeActionHandlerImpl
implements SelectionTreeActionHandler,
TariffClipboardOwner {
    private static final String MSG_CYCLE_NOT_ALLOWED_FMT = "<html>Cycles are not allowed in the selection tree.<p>Pasting onto the selected node would create a cycle that looks like:<p><em>%s</em></html>";
    private static final String MSG_IMPORT_FAILED_IO = "Failed to import tariff structure because of an I/O error. Try again or contact support.";
    private static final String MSG_IMPORT_FAILED_XML = "Failed to import tariff structure, because of an error in the XML. Make sure the selected file has a valid XML structure.";
    private static final String MSG_CLIPBOARD_GET_DATA_FAILED = "Failed to extract data string from the clipboard.";
    private SelectionTree myTree;
    private ContextAwareServiceContainer myServiceContainer;
    private RatingRuleTreeNodeFactory myNodeFactory;
    private List<TariffDAGNode> myPastableNodes;
    private SelectionTreeSaveHandler mySaveHandler;
    private BranchSearchFrame myBranchSearchFrame;
    private DialogFactoryInterface myDialogFactory = new DefaultDialogFactory();

    public SelectionTreeActionHandlerImpl(SelectionTree tree, SelectionTreeSaveHandler saveHandler, ContextAwareServiceContainer serviceContainer) {
        this.myTree = tree;
        this.mySaveHandler = saveHandler;
        this.myServiceContainer = serviceContainer;
        this.myNodeFactory = new RatingJTreeNodeFactory(this.myServiceContainer.getService().getId(), this.myServiceContainer.getClassRepository());
    }

    public DialogFactoryInterface setDialogFactory(DialogFactoryInterface factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null dialog factory is not allowed.");
        }
        DialogFactoryInterface old = this.myDialogFactory;
        this.myDialogFactory = factory;
        return old;
    }

    private JTree getTreeComponent() {
        return this.myTree.getTreeComponent();
    }

    private UndoableTree getUndoableTree() {
        return this.myTree.getUndoableTree();
    }

    public void setupDragAndDrop() {
        JTree tree = this.getTreeComponent();
        tree.setDragEnabled(true);
        tree.setDropMode(DropMode.ON_OR_INSERT);
        tree.setTransferHandler(new TreeTransferHandler());
    }

    @Override
    public void collapseAllAction(ActionEvent actionEvent) {
        SelectionTreeUtil.collapseAll(this.getTreeComponent());
    }

    @Override
    public void copyAction(ActionEvent evt) {
        TreePath[] treepaths = SelectionTreeUtil.arrangePaths(this.getTreeComponent().getSelectionPaths());
        if (treepaths != null) {
            RmaClipboardHandler.getConfiguredClipboard().setContents(RatingRuleNodeCopyAsTransferable.createCopyTransferable(treepaths), this);
        }
    }

    @Override
    public void copyLinkAction(ActionEvent evt) {
        JTree tc = this.getTreeComponent();
        TreePath[] treepaths = SelectionTreeUtil.arrangePaths(tc.getSelectionPaths());
        if (treepaths != null && this.isValidSelection(treepaths)) {
            RmaClipboardHandler.getConfiguredClipboard().setContents(RatingRuleNodeCopyAsTransferable.createLinkTransferable(treepaths), this);
        }
    }

    private boolean isValidSelection(TreePath[] treepaths) {
        boolean isValid = true;
        JTree tree = this.getTreeComponent();
        for (TreePath path : treepaths) {
            path = SelectionTreeUtil.extractOriginalPath(this.getTreeModel(), path);
            if (!SelectionTreeUtil.checkNodeId(path)) {
                this.myDialogFactory.getErrorDialog(tree, "Invalid node id in path", "The Id of a node in the selection path is invalid.\nThe selected node can not act as a link target.");
                isValid = false;
                break;
            }
            if (!SelectionTreeUtil.checkNodeIdAmbiguity(tree, path)) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    @Override
    public void deleteAction(ActionEvent evt) {
        JTree tc = this.getTreeComponent();
        TreePath[] parentPaths = SelectionTreeUtil.arrangePaths(tc.getSelectionPaths());
        if (parentPaths != null) {
            TariffDAGModel model = this.getTreeModel();
            boolean allowDelete = true;
            for (int i = 0; allowDelete && i < parentPaths.length; allowDelete &= model.allowsDelete(parentPaths[i].getPath()), ++i) {
            }
            if (allowDelete) {
                if (this.myDialogFactory.getQuestionDialog(tc, RmaDefs.getStringResource("ratingrules.questions.confirmDelete.title"), RmaDefs.getStringResource("ratingrules.questions.confirmDelete.msg"))) {
                    for (TreePath parentPath : parentPaths) {
                        Object[] deletionPath = parentPath.getPath();
                        TariffDAGNode parent = (TariffDAGNode)parentPath.getParentPath().getLastPathComponent();
                        TariffDAGNode child = (TariffDAGNode)parentPath.getLastPathComponent();
                        int index = model.getIndexOfChild(parent, child);
                        Enumeration<TreePath> expandedDescendants = tc.getExpandedDescendants(new TreePath(deletionPath));
                        model.delete(deletionPath);
                        UndoableTree ut = this.getUndoableTree();
                        ut.getUndoManager().addEdit(new DeleteNodeEdit(ut, deletionPath, index, expandedDescendants));
                    }
                    int nextRowSelection = tc.getRowForPath(parentPaths[0].getParentPath());
                    if (nextRowSelection < 0) {
                        nextRowSelection = 0;
                    }
                    SelectionTreeUtil.selectAndMakeVisible(tc, tc.getPathForRow(nextRowSelection));
                }
            } else {
                this.myDialogFactory.getInformationDialog(tc, RmaDefs.getStringResource("ratingrules.errmsg.deleteNotAllowed.title"), RmaDefs.getStringResource("ratingrules.errmsg.deleteNotAllowed.msg"));
            }
        }
    }

    @Override
    public void distributeAction(ActionEvent evt) {
        this.mySaveHandler.saveToMultipleEREs();
    }

    @Override
    public void expandAllAction(ActionEvent actionEvent) {
        SelectionTreeUtil.expandAll(this.getTreeComponent());
    }

    @Override
    public void exportAction(ActionEvent evt) {
        this.mySaveHandler.export(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateCasesAction(ActionEvent actionEvent) {
        RatingRuleFrame frame = this.getFrame();
        SimulatorPanelInterface simPanel = frame.getSimulatorPanel();
        if (simPanel instanceof SimulatorPanel) {
            try {
                this.getTreeComponent().setCursor(new Cursor(3));
                new TestCaseGeneratorWizard(frame, this.myTree.getTreeComponent(), new TreePath[]{this.getTreeComponent().getSelectionPath()}, (SimulatorPanel)simPanel, this.myServiceContainer.getClassRepository());
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "generation", 2, "The Selection Tree Test Tool couldn't be started!", true);
            }
            finally {
                this.getTreeComponent().setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public List<TariffDAGNode> getPastableNodes() {
        this.myPastableNodes = this.buildNodesFromSystemClipboard();
        return this.myPastableNodes;
    }

    @Override
    public void moveDownAction(ActionEvent evt) {
        TreePath parentPath = this.getTreeComponent().getSelectionPath();
        if (parentPath != null) {
            Object[] movePath = parentPath.getPath();
            this.getTreeModel().moveDown(movePath);
            UndoableTree ut = this.getUndoableTree();
            ut.getUndoManager().addEdit(new MoveNodeDownEdit(ut, movePath));
            SelectionTreeUtil.selectAndMakeVisible(this.getTreeComponent(), parentPath);
        }
    }

    @Override
    public void moveUpAction(ActionEvent evt) {
        TreePath parentPath = this.getTreeComponent().getSelectionPath();
        if (parentPath != null) {
            Object[] movePath = parentPath.getPath();
            this.getTreeModel().moveUp(movePath);
            UndoableTree ut = this.getUndoableTree();
            ut.getUndoManager().addEdit(new MoveNodeUpEdit(ut, movePath));
            SelectionTreeUtil.selectAndMakeVisible(this.getTreeComponent(), parentPath);
        }
    }

    @Override
    public void openAction(ActionEvent evt) {
        File selectedFile = NavigatorFileChooser.getImportFile("File to import");
        if (selectedFile != null) {
            try {
                this.doImport(selectedFile);
            }
            catch (IOException ex) {
                ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, MSG_IMPORT_FAILED_IO, true);
            }
            catch (Exception ex) {
                ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, MSG_IMPORT_FAILED_XML, true);
            }
        }
    }

    @Override
    public void pasteAsChildAction(ActionEvent evt) {
        this.pasteAsChildOrSiblingAction(1);
    }

    @Override
    public void pasteAsSiblingAction(ActionEvent evt) {
        this.pasteAsChildOrSiblingAction(2);
    }

    @Override
    public void pasteDefaultAction(ActionEvent evt) {
        TreePath pathToPasteIn = this.getTreeComponent().getSelectionPath();
        if (this.myPastableNodes != null && pathToPasteIn != null) {
            if (this.isPasteDefaultAllowedOnPath(pathToPasteIn)) {
                QueryableCompoundEdit compoundPasteEdit = new QueryableCompoundEdit();
                try {
                    TariffDAGNode firstPastedNode = this.myPastableNodes.get(0);
                    this.pasteNodes(this.myPastableNodes, pathToPasteIn, 0, compoundPasteEdit, 0);
                    this.scrollTreeToPath(pathToPasteIn, firstPastedNode);
                }
                catch (PasteFailedException pfe) {
                    ExceptionUtil.handleException(pfe, "ratingRuleFrame", 1, "Paste default failed.", false);
                }
                this.addEditToUndoManager(compoundPasteEdit);
            } else {
                this.myDialogFactory.getInformationDialog(this.getTreeComponent(), "Paste not allowed", "Could not paste node onto path");
            }
        }
    }

    private boolean isPasteDefaultAllowedOnPath(TreePath path) {
        TariffDAGModel model = this.getTreeModel();
        boolean allowPaste = this.myPastableNodes.size() > 0;
        for (TariffDAGNode node : this.myPastableNodes) {
            allowPaste &= model.allowsAddTariffStructureNodeDefault(path.getPath(), node);
        }
        return allowPaste;
    }

    @Override
    public void pasteSpecialAction(ActionEvent evt) {
        TreePath pathToPasteIn = this.getTreeComponent().getSelectionPath();
        if (this.myPastableNodes != null && pathToPasteIn != null) {
            TariffDAGModel model = this.getTreeModel();
            Rectangle pathBounds = this.getTreeComponent().getPathBounds(pathToPasteIn);
            Point menuLocation = new Point((int)pathBounds.getMaxX(), (int)pathBounds.getMaxY());
            boolean allowPasteAsChild = true;
            boolean allowPasteAsSibling = true;
            for (TariffDAGNode node : this.myPastableNodes) {
                allowPasteAsChild &= model.allowsAddTariffStructureNodeAsChild(pathToPasteIn.getPath(), node);
                allowPasteAsSibling &= model.allowsAddTariffStructureNodeAsSibling(pathToPasteIn.getPath(), node);
            }
            this.showPasteMenu(menuLocation, this.myPastableNodes, pathToPasteIn, null, 1, allowPasteAsChild, allowPasteAsSibling);
        }
    }

    @Override
    public void printClassAction(ActionEvent evt) {
        System.out.println("Class Name for node " + this.getSelectedNode().getClass());
        System.out.println("No of children: " + this.getSelectedNode().getChildCount());
    }

    @Override
    public void printTariffAction(ActionEvent evt) {
        try {
            TariffDAGNode node = this.getSelectedNode();
            if (node != null) {
                System.out.println(node);
                PrintWriter out = new PrintWriter(System.out);
                node.print(out, 0, "\t");
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void redoAction(ActionEvent evt) {
        try {
            RMAUndoManager um = this.getUndoableTree().getUndoManager();
            if (um.canRedo()) {
                um.redo();
            }
        }
        catch (CannotRedoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveAction(ActionEvent evt) {
        final ProgressDialog progressDialog = new ProgressDialog("RMA", "Saving Selection Tree");
        new ericsson.ere.gui.util.SwingWorker(){

            @Override
            public Object construct() {
                ProgressIndicator progress = progressDialog.getProgressIndicator();
                SelectionTreeActionHandlerImpl.this.mySaveHandler.save(progress);
                return null;
            }

            @Override
            public void finished() {
                progressDialog.dispose();
            }
        }.start();
        progressDialog.setVisible(true);
    }

    @Override
    public void saveAsAction(ActionEvent evt) {
        final ProgressDialog progressDialog = new ProgressDialog("RMA", "Saving Selection Tree");
        new ericsson.ere.gui.util.SwingWorker(){

            @Override
            public Object construct() {
                ProgressIndicator progress = progressDialog.getProgressIndicator();
                SelectionTreeActionHandlerImpl.this.mySaveHandler.saveAs(progress);
                return null;
            }

            @Override
            public void finished() {
                progressDialog.dispose();
            }
        }.start();
        progressDialog.setVisible(true);
    }

    @Override
    public void showFindPaletteAction(ActionEvent evt) {
        JLayeredPane internalFrameOwner = GuiUtil.getInternalFrameOwner(this.getTreeComponent());
        FindPalette p = new FindPalette(this.myTree);
        JInternalFrame frame = p.getInternalFrame();
        internalFrameOwner.add((Component)frame, JLayeredPane.PALETTE_LAYER);
        this.displayInternalFrame(frame);
    }

    @Override
    public void showBranchSearchAction(ActionEvent evt) {
        if (this.myBranchSearchFrame == null || this.myBranchSearchFrame.isClosed()) {
            String fn = String.format("BranchSearchFilters-%s.dat", this.myServiceContainer.getService().getId());
            File storage = new File(Config.getInstance().getUserDir(), fn);
            BranchSearchUIContext ctx = new BranchSearchUIContext(this.getFrame());
            this.myBranchSearchFrame = new BranchSearchFrame(this.myServiceContainer, storage, (TSTariffStructure)this.getTreeModel().getRoot(), ctx);
            GuiServiceCenter.getInstance().getDesktopPane().add((Component)this.myBranchSearchFrame, "Center");
            this.myBranchSearchFrame.setVisible(true);
        } else {
            if (this.myBranchSearchFrame.isIcon()) {
                GuiServiceCenter.setIconNoVeto(this.myBranchSearchFrame, false);
            }
            GuiServiceCenter.setSelectedNoVeto(this.myBranchSearchFrame, true);
        }
    }

    @Override
    public void showReferencesAction(ActionEvent evt) {
        TreePath parentPath = this.getTreeComponent().getSelectionPath();
        if (parentPath != null) {
            JLayeredPane internalFrameOwner = GuiUtil.getInternalFrameOwner(this.getTreeComponent());
            TariffDAGNode node = (TariffDAGNode)parentPath.getLastPathComponent();
            ShowReferencesFrame frame = new ShowReferencesFrame(node);
            internalFrameOwner.add((Component)frame, JLayeredPane.PALETTE_LAYER);
            this.displayInternalFrame(frame);
        }
    }

    @Override
    public void gotoLinkTargetAction(ActionEvent evt) {
        TariffDAGNode currentNode;
        TreePath currentPath = this.getTreeComponent().getSelectionPath();
        if (currentPath != null && (currentNode = (TariffDAGNode)currentPath.getLastPathComponent()) != null) {
            TreePath selectionPath = null;
            if (currentNode.isLink()) {
                TariffDAGNode childNode = (TariffDAGNode)currentNode.getChildAt(0);
                selectionPath = this.getTreeModel().getPathToRoot(childNode);
            } else {
                selectionPath = this.getTreeModel().getPathToRoot(currentNode);
            }
            if (selectionPath != null) {
                this.getTreeComponent().setSelectionPath(selectionPath);
                this.getTreeComponent().scrollPathToVisible(selectionPath);
            }
        }
    }

    @Override
    public void undoAction(ActionEvent evt) {
        try {
            RMAUndoManager um = this.getUndoableTree().getUndoManager();
            if (um.canUndo()) {
                um.undo();
            }
        }
        catch (CannotUndoException e) {
            e.printStackTrace();
        }
    }

    private void pasteAsChildOrSiblingAction(int mode) {
        TreePath pathToPasteIn = this.getTreeComponent().getSelectionPath();
        if (this.myPastableNodes != null && pathToPasteIn != null) {
            try {
                this.pasteNodes(this.myPastableNodes, pathToPasteIn, mode, null, 0);
            }
            catch (PasteFailedException pfe) {
                String msg = mode == 1 ? "Paste as child failed." : "Paste as sibling failed.";
                ExceptionUtil.handleException(pfe, "ratingRuleFrame", 1, msg, false);
            }
        }
    }

    private TariffDAGNode getSelectedNode() {
        TreePath selPath = this.getTreeComponent().getSelectionPath();
        if (selPath != null) {
            return (TariffDAGNode)selPath.getLastPathComponent();
        }
        return null;
    }

    private void displayInternalFrame(JInternalFrame frame) {
        Container p = this.getTreeComponent().getParent();
        while (!(p instanceof JScrollPane)) {
            p = p.getParent();
        }
        JScrollPane pane = (JScrollPane)p;
        Dimension d = pane.getViewport().getExtentSize();
        while (!(p instanceof JInternalFrame)) {
            p = p.getParent();
        }
        JInternalFrame owningFrame = (JInternalFrame)p;
        Point oFrameLoc = owningFrame.getLocationOnScreen();
        int oFrameWidth = owningFrame.getWidth();
        Point treeLoc = this.getTreeComponent().getLocationOnScreen();
        int x = (int)(3.0 * d.getWidth() / 4.0);
        if (treeLoc.x + x + frame.getWidth() > oFrameLoc.x + oFrameWidth) {
            x -= treeLoc.x + x + frame.getWidth() - (oFrameLoc.x + oFrameWidth);
        }
        x = Math.max(0, x);
        int y = Math.max(0, (int)(3.0 * d.getHeight() / 4.0) - frame.getHeight());
        frame.setLocation(x, y);
        frame.setVisible(true);
    }

    private List<TariffDAGNode> buildNodesFromSystemClipboard() {
        Element rootElement;
        String pastedText;
        List<TariffDAGNode> tariffNodes = null;
        Transferable contents = RmaClipboardHandler.getConfiguredClipboard().getContents(this);
        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor) && (pastedText = this.getTextFromTransferable(contents)) != null && (rootElement = this.getElementClipboardText(pastedText)) != null) {
            NodeList nodeList = rootElement.getChildNodes();
            tariffNodes = this.buildTariffNodesFromNodeList(nodeList);
        }
        return tariffNodes;
    }

    private List<TariffDAGNode> buildTariffNodesFromNodeList(NodeList nodeList) {
        ArrayList<TariffDAGNode> nodes = new ArrayList<TariffDAGNode>();
        BuildErrorCounter errorHandler = new BuildErrorCounter();
        RatingRuleBuilder builder = new RatingRuleBuilder(this.myNodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            TariffDAGNode newNode;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            try {
                newNode = (TariffDAGNode)builder.buildFromString(DomWriter.nodeToString(node, false));
            }
            catch (Exception ex) {
                ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, "Failed to build nodes from clipboard data.", false);
                nodes = null;
                break;
            }
            nodes.add(newNode);
        }
        if (errorHandler.getNumberOfErrors() > 0) {
            nodes = null;
        }
        return nodes;
    }

    private String getTextFromTransferable(Transferable contents) {
        String text = null;
        try {
            text = (String)contents.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException ex) {
            throw new AssertionError((Object)"Unsupported flavor even though we checked it.");
        }
        catch (IOException ex) {
            ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, MSG_CLIPBOARD_GET_DATA_FAILED, false);
        }
        return text;
    }

    private Element getElementClipboardText(String text) {
        Element element = null;
        if (!StringUtil.isEmptyString(text) && text.startsWith(RatingRuleNodeTransferable.TAG_NODE_COPY_START) && text.endsWith(RatingRuleNodeTransferable.TAG_NODE_COPY_END)) {
            try {
                element = XMLUtil.buildDocumentFromString(text).getDocumentElement();
            }
            catch (Exception ex) {
                ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, "Failed to build nodes from clipboard data.", false);
            }
        }
        return element;
    }

    private void deleteNodes(TreePath[] pathToNodesToDelete, CompoundEdit compoundOuterEdit) {
        TariffDAGModel model = this.getTreeModel();
        boolean allowDelete = true;
        for (int i = 0; allowDelete && i < pathToNodesToDelete.length; allowDelete &= model.allowsDelete(pathToNodesToDelete[i].getPath()), ++i) {
        }
        if (allowDelete) {
            QueryableCompoundEdit compoundDeleteEdit = new QueryableCompoundEdit();
            for (TreePath path : pathToNodesToDelete) {
                TariffDAGNode parent = (TariffDAGNode)path.getParentPath().getLastPathComponent();
                int index = model.getIndexOfChild(parent, path.getLastPathComponent());
                Object[] deletionPath = path.getPath();
                model.delete(deletionPath);
                DeleteNodeEdit deleteNodeEdit = new DeleteNodeEdit(this.getUndoableTree(), deletionPath, index);
                if (compoundOuterEdit != null) {
                    compoundOuterEdit.addEdit(deleteNodeEdit);
                    continue;
                }
                compoundDeleteEdit.addEdit(deleteNodeEdit);
            }
            if (compoundOuterEdit == null) {
                this.addEditToUndoManager(compoundDeleteEdit);
            }
        }
    }

    private void doImport(File selectedFile) throws Exception {
        ImportWorker importWorker = new ImportWorker(selectedFile);
        importWorker.execute();
    }

    private void pasteNodes(List<TariffDAGNode> nodesToPaste, TreePath pathToPasteIn, int pasteMethod, CompoundEdit compoundOuterEdit, int preferedIndex) throws PasteFailedException {
        if (nodesToPaste == null || pathToPasteIn == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        CompoundEdit compoundPasteEdit = null;
        TariffDAGModel model = this.getTreeModel();
        for (int i = nodesToPaste.size() - 1; i >= 0; --i) {
            TariffDAGNode dropNode = nodesToPaste.get(i);
            dropNode.setTreeModel(model);
            try {
                switch (pasteMethod) {
                    case 2: {
                        model.addTariffStrucureNodeAsSibling(pathToPasteIn.getPath(), dropNode);
                        break;
                    }
                    case 1: {
                        model.addTariffStrucureNodeAsChild(pathToPasteIn.getPath(), dropNode);
                        break;
                    }
                    case 0: {
                        model.addTariffStrucureNodeDefault(pathToPasteIn.getPath(), dropNode);
                        break;
                    }
                    case 3: {
                        model.addTariffStrucureNodeAsChild(pathToPasteIn.getPath(), dropNode, preferedIndex);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Paste method parameter not recognized.");
                    }
                }
            }
            catch (CycleDetectedException cde) {
                StringBuffer buf = new StringBuffer();
                List<DAGNode> cycle = cde.getCyclePath();
                for (DAGNode node : cycle) {
                    String str = node.toString();
                    if (node instanceof TSLink) {
                        buf.append("/\\" + str.substring(1));
                        continue;
                    }
                    buf.append("/" + str);
                }
                String msg = String.format(MSG_CYCLE_NOT_ALLOWED_FMT, buf.toString());
                JOptionPane.showMessageDialog(this.getTreeComponent(), msg, "Paste failed", 0);
                if (compoundPasteEdit != null) {
                    this.addEditToUndoManager((QueryableCompoundEdit)compoundPasteEdit);
                }
                throw new PasteFailedException("Paste failed.", cde);
            }
            catch (UnresolvedLinkTargetException ulte) {
                TariffStructureNode node = (TariffStructureNode)ulte.getContextNode();
                String id = "";
                if (node != null) {
                    id = node.getNodeId();
                }
                String unresolvableId = ulte.getUnresolvable();
                String msg = "<html>It is not allowed to have links that doesn't point to an identified node.<p> The node <em>" + id + "</em> does not contain a child with the id: <em>" + unresolvableId + "</em><p>Details: " + ulte.getMessage() + "</html>";
                JOptionPane.showMessageDialog(this.getTreeComponent(), msg, "Paste failed", 0);
                if (compoundPasteEdit != null) {
                    this.addEditToUndoManager((QueryableCompoundEdit)compoundPasteEdit);
                }
                throw new PasteFailedException("Paste failed.", ulte);
            }
            catch (AmbiguousLinkTargetException ex) {
                String msg = "<html>It is not allowed to have links that don't point to a unique node. <p>" + ex.getMessage() + "</p><p>Make sure that the node " + ex.getAmbiguousNodeName() + " has a unique ID.</html>";
                JOptionPane.showMessageDialog(this.getTreeComponent(), msg, "Paste failed", 0);
                if (compoundPasteEdit != null) {
                    this.addEditToUndoManager((QueryableCompoundEdit)compoundPasteEdit);
                }
                throw new PasteFailedException("Paste failed.", ex);
            }
            Object[] newPath = SelectionTreeUtil.findClosestMatchingPath(dropNode, this.getUndoableTree().getTop(), pathToPasteIn.getPath());
            int index = model.getIndexOfChild(newPath[newPath.length - 2], dropNode);
            CreateNodeEdit createNodeEdit = new CreateNodeEdit(this.getUndoableTree(), newPath, index);
            if (compoundOuterEdit != null) {
                compoundOuterEdit.addEdit(createNodeEdit);
            } else {
                if (compoundPasteEdit == null) {
                    compoundPasteEdit = new QueryableCompoundEdit();
                }
                compoundPasteEdit.addEdit(createNodeEdit);
            }
            if (compoundPasteEdit == null) continue;
            this.addEditToUndoManager((QueryableCompoundEdit)compoundPasteEdit);
        }
    }

    private void scrollTreeToPath(TreePath path, TariffDAGNode node) {
        Object[] newSel = SelectionTreeUtil.findClosestMatchingPath(node, this.getUndoableTree().getTop(), path.getPath());
        SelectionTreeUtil.selectAndMakeVisible(this.getTreeComponent(), new TreePath(newSel));
    }

    private Element extractDropDataElement(Transferable transferData, int dropAction) {
        String dropData = "";
        Element rootElement = null;
        try {
            dropData = dropAction == 1 || dropAction == 2 ? (String)transferData.getTransferData(RatingRuleNodeTransferable.NODE_FLAVOR) : (dropAction == 0x40000000 ? (String)transferData.getTransferData(RatingRuleNodeTransferable.LINK_TO_NODE_FLAVOR) : (String)transferData.getTransferData(DataFlavor.stringFlavor));
            if (dropData != null && dropData.startsWith(RatingRuleNodeTransferable.TAG_NODE_COPY_START) && dropData.endsWith(RatingRuleNodeTransferable.TAG_NODE_COPY_END)) {
                rootElement = XMLUtil.buildDocumentFromString(dropData).getDocumentElement();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, "Failed to extract data from transferable.", false);
        }
        return rootElement;
    }

    private void showPasteMenu(Point menuLocation, List<TariffDAGNode> nodesToPaste, TreePath pathToPasteIn, TreePath[] deletePaths, int dropAction, boolean allowPasteAsChild, boolean allowPasteAsSibling) {
        if (dropAction == 2 && deletePaths == null) {
            throw new IllegalArgumentException("showPasteMenu: deletePath parameter cannot be null");
        }
        String namePrefix = "RatingRuleTree.JMenuItem.";
        PasteSpecialAction action = new PasteSpecialAction(nodesToPaste, pathToPasteIn, deletePaths, dropAction);
        JMenuItem pasteAsChildMenuItem = new JMenuItem("Paste as child");
        pasteAsChildMenuItem.setName(namePrefix + "paste-as-child");
        pasteAsChildMenuItem.setActionCommand(String.valueOf(1));
        pasteAsChildMenuItem.addActionListener(action);
        JMenuItem pasteAsSiblingMenuItem = new JMenuItem("Paste as sibling");
        pasteAsSiblingMenuItem.setName(namePrefix + "paste-as-sibling");
        pasteAsSiblingMenuItem.setActionCommand(String.valueOf(2));
        pasteAsSiblingMenuItem.addActionListener(action);
        pasteAsChildMenuItem.setEnabled(allowPasteAsChild);
        pasteAsSiblingMenuItem.setEnabled(allowPasteAsSibling);
        JPopupMenu pastePopupMenu = new JPopupMenu();
        pastePopupMenu.setName("RatingRuleTree.JPopupMenu.paste-menu");
        pastePopupMenu.add(pasteAsChildMenuItem);
        pastePopupMenu.add(pasteAsSiblingMenuItem);
        pastePopupMenu.addSeparator();
        JMenuItem cancelMenuItem = new JMenuItem("Cancel paste");
        cancelMenuItem.setName(namePrefix + "cancel");
        pastePopupMenu.add(cancelMenuItem);
        pastePopupMenu.show(this.getTreeComponent(), menuLocation.x, menuLocation.y);
    }

    private void addEditToUndoManager(QueryableCompoundEdit edit) {
        if (edit != null && edit.getEditCount() > 0) {
            edit.end();
            RMAUndoManager um = this.getUndoableTree().getUndoManager();
            if (edit.getEditCount() > 1) {
                um.addEdit(edit);
            } else {
                um.addEdit(edit.getEditAt(0));
            }
        }
    }

    private TariffDAGModel getTreeModel() {
        return (TariffDAGModel)this.getTreeComponent().getModel();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private RatingRuleFrame getFrame() {
        return SelectionTreeUtil.getRatingRuleFrame(this.myTree.getTreeComponent());
    }

    @Override
    public void showFindParametersAction(ActionEvent evt) {
        TariffDAGNode node = this.getSelectedNode();
        if (node != null) {
            TreePath path = DAGUtil.getPathToRoot(node);
            Object[] appPath = path.getPath();
            StringBuilder buf = new StringBuilder(200);
            for (int i = 0; i < path.getPathCount(); ++i) {
                TariffDAGNode n = (TariffDAGNode)appPath[i];
                buf.append('/');
                buf.append(n.getNodeId());
            }
            Map<String, Object> params = node.getParameters();
            ShowFindParametersPalette p = new ShowFindParametersPalette(buf.toString(), params);
            JLayeredPane internalFrameOwner = GuiUtil.getInternalFrameOwner(this.getTreeComponent());
            internalFrameOwner.add((Component)p, JLayeredPane.PALETTE_LAYER);
            this.displayInternalFrame(p);
        }
    }

    private class TreeTransferHandler
    extends TransferHandler {
        private boolean myOngoingDnD = false;

        private TreeTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean validImport = false;
            if (support.isDrop()) {
                validImport = true;
                if (!this.myOngoingDnD && this.containsTransferableAnyLink(support)) {
                    validImport = false;
                } else if (support.getDropAction() == 0x40000000 && this.myOngoingDnD) {
                    validImport = SelectionTreeActionHandlerImpl.this.isValidSelection(SelectionTreeActionHandlerImpl.this.getTreeComponent().getSelectionPaths());
                }
            }
            return validImport;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            boolean nodeInserted = false;
            if (this.canImport(support)) {
                try {
                    List<TariffDAGNode> dropNodes;
                    Transferable transferable = support.getTransferable();
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        this.handleDroppedFile(transferable);
                    } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && this.isDndAllowedFromSetting(support) && (dropNodes = this.getDropNodes(support)) != null) {
                        nodeInserted = this.insertNodesIntoModel(support, dropNodes);
                    }
                }
                catch (Exception x) {
                    ExceptionUtil.handleException(x, "ratingRuleFrame", 0, "The object that was dropped is not allowed in this part of the Selection Tree!", true);
                }
            }
            return nodeInserted;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        private void handleDroppedFile(Transferable transferData) throws Exception {
            List fileList = (List)transferData.getTransferData(DataFlavor.javaFileListFlavor);
            File file = (File)fileList.get(0);
            if (file != null) {
                SelectionTreeActionHandlerImpl.this.doImport(file);
            }
        }

        private boolean isDndAllowedFromSetting(TransferHandler.TransferSupport support) {
            boolean doPaste = true;
            if (support.getDropAction() == 2 && RmaDefs.getInstance().getConfirmSelectionTreeDragAndDropSetting()) {
                doPaste = SelectionTreeActionHandlerImpl.this.myDialogFactory.getQuestionDialogCustomButtons(SelectionTreeActionHandlerImpl.this.getTreeComponent(), "Confirm Drag&Drop in Selection Tree", "Do you want to move selected node in Selection Tree?", "Yes", "No");
            }
            return doPaste;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean insertNodesIntoModel(TransferHandler.TransferSupport support, List<TariffDAGNode> dropNodes) {
            boolean nodeInserted = false;
            QueryableCompoundEdit compoundEdit = new QueryableCompoundEdit();
            JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
            int index = dropLocation.getChildIndex();
            if (index == -1) {
                index = 0;
            }
            if (this.isValidInsert(dropLocation, dropNodes, index)) {
                try {
                    SelectionTreeActionHandlerImpl.this.pasteNodes(dropNodes, dropLocation.getPath(), 3, compoundEdit, index);
                    if (support.getDropAction() == 2 && this.myOngoingDnD) {
                        SelectionTreeActionHandlerImpl.this.deleteNodes(SelectionTreeActionHandlerImpl.this.getTreeComponent().getSelectionPaths(), compoundEdit);
                    }
                    SelectionTreeActionHandlerImpl.this.scrollTreeToPath(dropLocation.getPath(), dropNodes.get(0));
                    nodeInserted = true;
                }
                catch (PasteFailedException pfe) {
                    ExceptionUtil.handleException(pfe, "ratingRuleFrame", 1, "Paste by drag and drop failed.", false);
                }
                finally {
                    SelectionTreeActionHandlerImpl.this.addEditToUndoManager(compoundEdit);
                }
            } else {
                SelectionTreeActionHandlerImpl.this.myDialogFactory.getInformationDialog(SelectionTreeActionHandlerImpl.this.getTreeComponent(), "Paste not allowed", "Could not paste node onto path");
            }
            return nodeInserted;
        }

        private boolean isValidInsert(JTree.DropLocation dropLocation, List<TariffDAGNode> dropNodes, int index) {
            boolean validInsert = true;
            for (TariffDAGNode node : dropNodes) {
                validInsert &= SelectionTreeActionHandlerImpl.this.getTreeModel().allowsAddTariffStructureNodeAsChild(dropLocation.getPath().getPath(), node, node.getNodeType(), index);
            }
            return validInsert;
        }

        private List<TariffDAGNode> getDropNodes(TransferHandler.TransferSupport support) throws Exception {
            Transferable transferable = support.getTransferable();
            Element pasteRootElement = SelectionTreeActionHandlerImpl.this.extractDropDataElement(transferable, this.getActionForCurrentDrop(support));
            JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
            TreePath dropPath = dropLocation.getPath();
            ArrayList<TariffDAGNode> dropNodes = null;
            if (pasteRootElement != null && dropPath != null && this.isValidDrop(support)) {
                dropNodes = new ArrayList<TariffDAGNode>();
                BuildErrorCounter errorHandler = new BuildErrorCounter();
                RatingRuleBuilder builder = new RatingRuleBuilder(SelectionTreeActionHandlerImpl.this.myNodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
                for (Node child : new NodeListIterable(pasteRootElement.getChildNodes(), 1)) {
                    Element element = (Element)child;
                    TariffDAGNode currentNode = (TariffDAGNode)builder.buildFromElement(element, null);
                    currentNode.setTreeModel(SelectionTreeActionHandlerImpl.this.getTreeModel());
                    dropNodes.add(currentNode);
                }
                if (errorHandler.getNumberOfErrors() > 0) {
                    dropNodes = null;
                }
            }
            return dropNodes;
        }

        private int getActionForCurrentDrop(TransferHandler.TransferSupport support) {
            int dropAction = support.getDropAction();
            return !this.myOngoingDnD && dropAction == 0x40000000 ? 1 : dropAction;
        }

        private boolean isValidDrop(TransferHandler.TransferSupport support) {
            boolean isValidDrop = false;
            TreePath[] paths = SelectionTreeUtil.arrangePaths(SelectionTreeActionHandlerImpl.this.getTreeComponent().getSelectionPaths());
            TreePath pathToDropOn = ((JTree.DropLocation)support.getDropLocation()).getPath();
            isValidDrop = this.isValidDropLocation(pathToDropOn, paths);
            return isValidDrop;
        }

        private boolean isValidDropLocation(TreePath dropPath, TreePath[] dragPaths) {
            boolean isValidLocation = true;
            if (dragPaths != null) {
                for (TreePath dragPath : dragPaths) {
                    if (!this.myOngoingDnD || !dragPath.equals(dropPath) && !dragPath.isDescendant(dropPath)) continue;
                    isValidLocation = false;
                }
            }
            return isValidLocation;
        }

        private boolean isNodeTransferable(TariffDAGNode node) {
            return node != null && !node.getTypename().equals("Defs") && (node instanceof TSNode || node instanceof TSLink || node instanceof TSModifier || node instanceof TSCondition);
        }

        private boolean isSingleSelection(TreePath[] path) {
            return path != null && path.length == 1;
        }

        private boolean containsTransferableAnyLink(TransferHandler.TransferSupport support) {
            boolean foundLink = false;
            try {
                List<TariffDAGNode> dropNodes = this.getDropNodes(support);
                LinkVisitorBreakCondition linkVisitorCondition = new LinkVisitorBreakCondition();
                DAGUtil.visitPreorderWithCondition(dropNodes.get(0), new DefaultTariffStructureVisitor(), linkVisitorCondition);
                foundLink = linkVisitorCondition.getLinkFound();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return foundLink;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            this.myOngoingDnD = false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            RatingRuleNodeTransferable transferable = null;
            TreePath[] selectionPaths = SelectionTreeActionHandlerImpl.this.getTreeComponent().getSelectionPaths();
            if (this.isNodeTransferable(SelectionTreeActionHandlerImpl.this.getSelectedNode()) && this.isSingleSelection(selectionPaths)) {
                transferable = new RatingRuleNodeTransferable(selectionPaths, false);
                this.myOngoingDnD = true;
            }
            return transferable;
        }

        private class LinkVisitorBreakCondition
        implements DAGUtil.VisitorCondition {
            boolean myLinkFound = false;

            private LinkVisitorBreakCondition() {
            }

            @Override
            public boolean shouldVisit(TariffStructureNode node) {
                this.myLinkFound = node.isLink();
                return !this.myLinkFound;
            }

            public boolean getLinkFound() {
                return this.myLinkFound;
            }
        }
    }

    private class PasteSpecialAction
    implements ActionListener {
        private List<TariffDAGNode> myNodesToPaste;
        private TreePath myPathToPasteIn;
        private int myDropAction;
        private TreePath[] myDeletePaths;

        PasteSpecialAction(List<TariffDAGNode> nodes, TreePath path, TreePath[] deletePaths, int dropAction) {
            this.myNodesToPaste = nodes;
            this.myPathToPasteIn = path;
            this.myDeletePaths = deletePaths;
            this.myDropAction = dropAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryableCompoundEdit compoundEdit = new QueryableCompoundEdit();
            boolean pasteSuccessful = true;
            int pasteAs = Integer.parseInt(e.getActionCommand());
            try {
                SelectionTreeActionHandlerImpl.this.pasteNodes(this.myNodesToPaste, this.myPathToPasteIn, pasteAs, compoundEdit, 0);
                if (this.myDropAction == 2) {
                    SelectionTreeActionHandlerImpl.this.deleteNodes(this.myDeletePaths, compoundEdit);
                }
            }
            catch (PasteFailedException pfe) {
                boolean child = pasteAs == 1;
                ExceptionUtil.handleException(pfe, "ratingRuleFrame", 1, "Paste as " + (child ? "child" : "sibling") + " failed.", false);
                pasteSuccessful = false;
            }
            SelectionTreeActionHandlerImpl.this.addEditToUndoManager(compoundEdit);
            if (pasteSuccessful) {
                SelectionTreeActionHandlerImpl.this.scrollTreeToPath(this.myPathToPasteIn, this.myNodesToPaste.get(0));
            }
        }
    }

    class RefListSelectionListener
    implements ListSelectionListener {
        RefListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TariffDAGNode sel;
            if (!e.getValueIsAdjusting() && (sel = (TariffDAGNode)((JList)e.getSource()).getSelectedValue()) != null) {
                Object[] path = DAGUtil.getCanonicalPath(sel);
                SelectionTreeUtil.selectAndMakeVisible(SelectionTreeActionHandlerImpl.this.getTreeComponent(), new TreePath(path));
            }
        }
    }

    private class ShowReferencesFrame
    extends PaletteFrame
    implements TreeModelListener {
        private JList myRefs;
        private TariffDAGNode myNode;

        public ShowReferencesFrame(TariffDAGNode aNode) {
            super("REF: " + aNode.getDescription(), true, true);
            this.setDefaultCloseOperation(2);
            this.myNode = aNode;
            this.setFrameIcon(TariffCellRenderer.getIconForValue(this.myNode));
            JComponent contentPane = (JComponent)this.getContentPane();
            this.myRefs = new JList<DAGNode>(aNode.getReferers());
            this.myRefs.getSelectionModel().setSelectionMode(0);
            this.myRefs.setCellRenderer(new LinkRefCellRenderer());
            this.myRefs.addListSelectionListener(new RefListSelectionListener());
            contentPane.add((Component)new JScrollPane(this.myRefs), "Center");
            SelectionTreeActionHandlerImpl.this.getTreeModel().addTreeModelListener(this);
            this.pack();
        }

        private void updateModel() {
            ArrayListModel<DAGNode> model = new ArrayListModel<DAGNode>();
            model.addAll(Arrays.asList(this.myNode.getReferers()));
            this.myRefs.setModel(model);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.updateModel();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.updateModel();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.updateModel();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.updateModel();
        }
    }

    private final class ImportWorker
    extends SwingWorker<Object, Object> {
        private final File myFile;
        private Document myDocument;

        public ImportWorker(File file) {
            this.myFile = file;
        }

        @Override
        protected Object doInBackground() throws Exception {
            String serviceId = SelectionTreeActionHandlerImpl.this.myServiceContainer.getService().getId();
            this.myDocument = XMLUtil.buildDocumentFromFile(this.myFile);
            boolean one = ImportUtil.containsOneValidTariffStructure(this.myDocument, serviceId);
            SelectionTreeActionHandlerImpl.this.myTree.isModified();
            return one;
        }

        @Override
        protected void done() {
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    boolean yes;
                    if (SelectionTreeActionHandlerImpl.this.myTree.isModified() && !(yes = SelectionTreeActionHandlerImpl.this.myDialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Tree is modified", "The selection tree contains unsaved modifications, still continue with the import?"))) {
                        return;
                    }
                    int dialogResult = SelectionTreeActionHandlerImpl.this.myDialogFactory.getQuestionDialogWithCancel(GuiServiceCenter.getInstance().getMainWindow(), "Direct import", "Exactly one tariff structure was found in the file, import it in the opened selection tree?");
                    switch (dialogResult) {
                        case 0: {
                            this.doFastImport(this.myDocument);
                            break;
                        }
                        case 1: {
                            this.doRegularImport(this.myFile);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    this.doRegularImport(this.myFile);
                }
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "ratingRuleFrame", 2, "Failed to import file", true);
            }
        }

        private void doRegularImport(File selectedFile) {
            RatingPeriodNode targetNode = SelectionTreeActionHandlerImpl.this.getFrame().getPeriodNode();
            WizardView view = WizardFactory.createNavigatorImportWizard(GuiServiceCenter.getInstance().getMainWindow(), selectedFile, targetNode);
            view.run();
        }

        private void doFastImport(Document doc) {
            final ProgressDialog dialog = new ProgressDialog("Importing...", "Importing Selection Tree");
            final FastImportWorker fastImport = new FastImportWorker(dialog, doc);
            dialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fastImport.cancel(true);
                    dialog.dispose();
                }
            });
            fastImport.execute();
            dialog.setVisible(true);
        }

        private final class FastImportWorker
        extends SwingWorker<Object, Object> {
            private final ProgressDialog myDialog;
            private final Document myDoc;
            UndoableTree myUndoTree;
            TSTariffStructure myTop;
            TSTariffStructure myOldRootNode;

            private FastImportWorker(ProgressDialog dialog, Document doc) {
                this.myDialog = dialog;
                this.myDoc = doc;
            }

            @Override
            protected Object doInBackground() throws Exception {
                RatingJTreeErrorHandler errorHandler = new RatingJTreeErrorHandler();
                RatingRuleBuilder builder = new RatingRuleBuilder(SelectionTreeActionHandlerImpl.this.myNodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
                ProgressIndicator indicator = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myDialog);
                ProgressIndicator[] indicators = indicator.splitProgress(new int[]{3, 7});
                try {
                    this.myUndoTree = SelectionTreeActionHandlerImpl.this.getUndoableTree();
                    indicators[0].setInfo("Fetching tree...");
                    indicators[0].progressStart();
                    this.myTop = (TSTariffStructure)builder.build(this.myDoc, indicators[1]);
                    Version version = SelectionTreeActionHandlerImpl.this.myTree.getVersion();
                    this.myTop.setVersion(version);
                    this.myTop.setTreeModel(new TariffDAGModel(null, this.myTop));
                    this.myOldRootNode = (TSTariffStructure)this.myUndoTree.getTop();
                    indicators[0].progressFinished();
                    indicators[1].progressStart();
                    indicators[1].setInfo("Validating node...");
                    this.myTop.isNodeValid();
                    indicators[1].progressIncrement(10);
                    indicators[1].setInfo("Opening structure...");
                }
                catch (Exception ex) {
                    if (!this.isInterruption(ex)) {
                        ExceptionUtil.handleException(ex, "ratingRuleFrame", 2, "Failed to import tariff structure", true);
                    }
                    return false;
                }
                return true;
            }

            private boolean isInterruption(Throwable t) {
                if (t == null) {
                    return false;
                }
                if (t instanceof InterruptedException || t instanceof InterruptedIOException || t instanceof UncheckedInterruptedException) {
                    return true;
                }
                return this.isInterruption(t.getCause());
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled() && ((Boolean)this.get()).booleanValue()) {
                        this.myUndoTree.openANewStructure(this.myTop);
                        this.myUndoTree.getUndoManager().addEdit(new OpenTreeEdit(this.myUndoTree, this.myOldRootNode, this.myTop));
                        SelectionTreeActionHandlerImpl.this.myDialogFactory.getInformationDialog(SelectionTreeActionHandlerImpl.this.getTreeComponent(), "Import successful", "The Selection tree was successfully imported");
                    }
                }
                catch (Exception e) {
                    ExceptionUtil.handleException(e, "ratingRuleFrame", 2, "Failed to import tariff structure", true);
                }
                this.myDialog.dispose();
            }
        }
    }
}

