/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.sdp;

import com.ericsson.ere.gui.navigator.interfaces.NavigatorConfigurationHandler;
import com.ericsson.ere.gui.navigator.interfaces.NavigatorNodeConfiguration;
import com.ericsson.ere.proxy.EreProxy;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.ConnectorFactory;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public class SDPNavigatorConfigLoader
implements NavigatorConfigurationHandler {
    public static final String SMA_NODES_CONFIG_PATH = File.separator + "ericsson" + File.separator + "chargingsystem" + File.separator + "sdp" + File.separator + "config" + File.separator + "SystemNodes.xml";
    public static final String CONNECTOR_TYPE_CS40 = "SDP";
    public static final String TAG_SMA_SYSTEM_LIST = "SystemList";
    public static final String TAG_SMA_SYSTEM = "System";
    public static final String TAG_SMA_SERVER_INFO = "ServerInfo";
    public static final String TAG_SMA_NAME = "Name";
    public static final String TAG_SMA_HOST = "Host";
    public static final String TAG_SMA_PORT = "Port";
    public static final String TAG_SMA_DESCRIPTION = "Description";
    public static final String TAG_SMA_ENABLED = "Enabled";
    public static final String TAG_SMA_CONNECT_AT_STARTUP = "ConnectAtStartup";
    public static final String TAG_SMA_USERNAME = "Username";
    public static final String TAG_RMACONFIG = "RmaConfig";
    public static final String TAG_RMA_NAME = "Name";
    public static final String TAG_RMA_HOST = "DestinationHost";
    public static final String TAG_RMA_PORT = "Port";
    public static final String TAG_RMA_DESCRIPTION = "Description";
    public static final String TAG_RMA_ENABLED = "Enabled";
    public static final String TAG_RMA_CONNECT_AT_STARTUP = "Connect at startup";
    public static final String TAG_RMA_USERNAME = "Username";

    @Override
    public List<NavigatorNodeConfiguration> getNavigatorConfiguration() {
        ArrayList<NavigatorNodeConfiguration> configList = new ArrayList<NavigatorNodeConfiguration>();
        try {
            Logger.getLogger("rma").finest("loadSDPConfig - hasSMAconfig: " + SDPNavigatorConfigLoader.hasSMAConfig());
            if (!SDPNavigatorConfigLoader.hasSMAConfig()) {
                return configList;
            }
            File systemNodesFile = new File(System.getProperty("user.home") + SMA_NODES_CONFIG_PATH);
            Document systemNodes = XMLUtil.buildDocumentFromFile(systemNodesFile);
            Logger.getLogger("rma").finest("loadSDPConfig - systemNodes: " + DomWriter.nodeToString(systemNodes, true));
            if (systemNodes.getDocumentElement().getNodeName().equalsIgnoreCase(TAG_SMA_SYSTEM_LIST)) {
                List<Element> sdpNodes = XMLUtil.getElementNodesNamed(TAG_SMA_SYSTEM, systemNodes.getDocumentElement().getChildNodes());
                for (Element sdpNode : sdpNodes) {
                    Element server = XMLUtil.getNamedElement(TAG_SMA_SERVER_INFO, sdpNode.getChildNodes());
                    NodeList attributes = server.getChildNodes();
                    String name = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("Name", attributes));
                    String host = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(TAG_SMA_HOST, attributes));
                    String port = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("Port", attributes));
                    String description = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("Description", attributes));
                    String enabled = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("Enabled", attributes));
                    String connectAtStartup = XMLUtil.getNamedElement(TAG_SMA_CONNECT_AT_STARTUP, attributes) != null ? XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(TAG_SMA_CONNECT_AT_STARTUP, attributes)) : "false";
                    String username = XMLUtil.getNamedElement("Username", attributes) != null ? XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("Username", attributes)) : "";
                    NavigatorNodeConfiguration config = new NavigatorNodeConfiguration.Builder(CONNECTOR_TYPE_CS40).setParameter("Name", XMLUtil.escape(name), NavigatorNodeConfiguration.ParameterType.TYPE_STRING).setParameter(TAG_RMA_HOST, XMLUtil.escape(host), NavigatorNodeConfiguration.ParameterType.TYPE_STRING).setParameter("Port", XMLUtil.escape(port), NavigatorNodeConfiguration.ParameterType.TYPE_INTEGER).setParameter("Description", XMLUtil.escape(description), NavigatorNodeConfiguration.ParameterType.TYPE_STRING).setParameter("Enabled", XMLUtil.escape(enabled), NavigatorNodeConfiguration.ParameterType.TYPE_BOOLEAN).setParameter(TAG_RMA_CONNECT_AT_STARTUP, XMLUtil.escape(connectAtStartup), NavigatorNodeConfiguration.ParameterType.TYPE_BOOLEAN).setParameter("Username", XMLUtil.escape(username), NavigatorNodeConfiguration.ParameterType.TYPE_STRING).build();
                    configList.add(config);
                }
                return configList;
            }
        }
        catch (Exception e) {
            DialogFactory.getErrorDialog("Loading Node Config", "Failed to load SMA node configuration" + (e.getMessage() != null ? " (" + e.getMessage() + ")" : ".") + "\nCS40 nodes that are added will be saved to config!");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(baos));
            Logger.getLogger("rma").warning(baos.toString());
        }
        return configList;
    }

    private static boolean hasSMAConfig() {
        File smaNodesFile = new File(System.getProperty("user.home") + SMA_NODES_CONFIG_PATH);
        boolean hasSMAConfig = smaNodesFile.canRead();
        String[] connectorTypes = ConnectorFactory.getInstance().getTypes();
        boolean canCreateCS40Nodes = connectorTypes == null ? false : Arrays.asList(connectorTypes).contains(CONNECTOR_TYPE_CS40);
        return hasSMAConfig && canCreateCS40Nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveNavigatorConfiguration(List<EreProxy> ereProxyList) {
        boolean retVal = true;
        try {
            Document cfgDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element smaSystemListElement = cfgDoc.createElement(TAG_SMA_SYSTEM_LIST);
            for (EreProxy ereProxy : ereProxyList) {
                if (!this.handles(ereProxy)) continue;
                SettingsMap properties = ereProxy.getSettingsMap();
                Element system = cfgDoc.createElement(TAG_SMA_SYSTEM);
                Element serverInfo = cfgDoc.createElement(TAG_SMA_SERVER_INFO);
                serverInfo.appendChild(cfgDoc.createElement("Name")).setTextContent(properties.getParameterAsString("Name"));
                serverInfo.appendChild(cfgDoc.createElement(TAG_SMA_HOST)).setTextContent(properties.getParameterAsString(TAG_RMA_HOST));
                serverInfo.appendChild(cfgDoc.createElement("Port")).setTextContent(properties.getParameterAsString("Port"));
                serverInfo.appendChild(cfgDoc.createElement("Description")).setTextContent(properties.getParameterAsString("Description"));
                serverInfo.appendChild(cfgDoc.createElement("Enabled")).setTextContent(properties.getParameter("Enabled").getValue());
                serverInfo.appendChild(cfgDoc.createElement(TAG_SMA_CONNECT_AT_STARTUP)).setTextContent(properties.getParameter(TAG_RMA_CONNECT_AT_STARTUP).getValue());
                serverInfo.appendChild(cfgDoc.createElement("Username")).setTextContent(properties.getParameterAsString("Username"));
                system.appendChild(serverInfo);
                smaSystemListElement.appendChild(system);
            }
            File systemNodesFile = new File(System.getProperty("user.home") + SMA_NODES_CONFIG_PATH);
            try (BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(systemNodesFile), "UTF-8"));){
                DomWriter.nodeToWriter(smaSystemListElement, fileWriter, true, false);
                fileWriter.flush();
            }
        }
        catch (Exception e) {
            DialogFactory.getErrorDialog("Saving Node Config", "Failed to save node configuration:\n" + e.getMessage());
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean handles(EreProxy ereProxy) {
        return CONNECTOR_TYPE_CS40.equals(ereProxy.getType());
    }
}

