/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.popupmenus;

import com.ericsson.ere.gui.navigator.NavigatorConfigLoader;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.actions.AddEreAction;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.EreNode;
import com.ericsson.ere.gui.navigator.nodes.InternalEreNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.navigator.popupmenus.AbstractNavigatorPopupMenu;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.integration.connector.ConnectorFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;

public class NavigatorPopupMenu
extends AbstractNavigatorPopupMenu
implements ActionListener {
    static final String LBL_ADD_NODE = "Add ERE Node";
    static final String LBL_CONNECT_RATING_MANAGER = "Connect";
    static final String LBL_REFRESH_RATING_MANAGER = "Refresh";
    static final String LBL_ENABLE = "Enable";
    static final String LBL_DISABLE = "Disable";
    static final JMenu addNodeMenu = new JMenu("Add ERE Node");
    static final JMenuItem enableMenu = new JMenuItem("Enable");

    public NavigatorPopupMenu(NavigatorTree owner) {
        super(owner);
        this.initNodeMenu();
    }

    private void initNodeMenu() {
        addNodeMenu.removeAll();
        String[] types = ConnectorFactory.getInstance().getTypes();
        for (int i = 0; types != null && i < types.length; ++i) {
            AddEreAction addEreAction = new AddEreAction(this.myOwner);
            addEreAction.setType(types[i]);
            JMenuItem item = new JMenuItem(addEreAction);
            item.setText(types[i]);
            addNodeMenu.add(item);
        }
        enableMenu.addActionListener(this);
    }

    private void menuForEreNode() {
        this.removeAll();
        this.addNewNodeMenu();
        this.addSeparator();
        this.addDeleteMenu(false);
        this.addSeparator();
        this.addConnectMenu();
        this.addDisconnectMenu();
        this.addSeparator();
        this.addPropertiesMenu();
    }

    private void menuForInternalEreNode() {
        this.removeAll();
        this.addNewNodeMenu();
        this.addSeparator();
        this.addConnectMenu();
        this.addDisconnectMenu();
        this.addSeparator();
        this.addPropertiesMenu();
    }

    private void menuForNavigatorNode() {
        this.removeAll();
        this.addNewNodeMenu();
    }

    private void addNewNodeMenu() {
        myPopupMenu.add(addNodeMenu);
    }

    @Override
    public void enablePopupMenu() {
        this.enableActions();
        DefaultMutableTreeNode tmpTreeNode = this.myOwner.getSelectedNode();
        if (tmpTreeNode == null) {
            this.removeAll();
            return;
        }
        if (tmpTreeNode instanceof NavigatorNode) {
            this.menuForNavigatorNode();
            saveMenu.setEnabled(GuiServiceCenter.getInstance().isNodeConfigModified());
        } else if (tmpTreeNode instanceof EreNode) {
            this.menuForEreNode();
            EreNode node = (EreNode)tmpTreeNode;
            if (node.isConnected()) {
                connectMenu.setText(LBL_REFRESH_RATING_MANAGER);
            } else {
                connectMenu.setText(LBL_CONNECT_RATING_MANAGER);
            }
        } else if (tmpTreeNode instanceof InternalEreNode) {
            this.menuForInternalEreNode();
            InternalEreNode node = (InternalEreNode)tmpTreeNode;
            if (node.isConnected()) {
                connectMenu.setText(LBL_REFRESH_RATING_MANAGER);
            } else {
                connectMenu.setText(LBL_CONNECT_RATING_MANAGER);
            }
            if (node.isEnabled()) {
                enableMenu.setText(LBL_ENABLE);
            } else {
                enableMenu.setText(LBL_DISABLE);
                connectMenu.setEnabled(false);
            }
        }
    }

    @Override
    public void enableActions() {
        AbstractNavigatorNode node;
        this.myOwner.disableAllActions();
        DefaultMutableTreeNode tmpTreeNode = this.myOwner.getSelectedNode();
        if (tmpTreeNode == null) {
            return;
        }
        NavigatorTree.saveAction.setEnabled(GuiServiceCenter.getInstance().isNodeConfigModified());
        if (tmpTreeNode instanceof EreNode) {
            node = (EreNode)tmpTreeNode;
            NavigatorTree.disconnectAction.setEnabled(((EreNode)node).isConnected());
            NavigatorTree.connectAction.setEnabled(true);
            NavigatorTree.propertiesAction.setEnabled(true);
            NavigatorTree.deleteAction.setEnabled(true);
        }
        if (tmpTreeNode instanceof InternalEreNode) {
            node = (InternalEreNode)tmpTreeNode;
            NavigatorTree.disconnectAction.setEnabled(((InternalEreNode)node).isConnected());
            NavigatorTree.connectAction.setEnabled(true);
            NavigatorTree.propertiesAction.setEnabled(true);
            NavigatorTree.deleteAction.setEnabled(true);
        }
        connectMenu.setEnabled(NavigatorTree.connectAction.isEnabled());
        disconnectMenu.setEnabled(NavigatorTree.disconnectAction.isEnabled());
        propertiesMenu.setEnabled(NavigatorTree.propertiesAction.isEnabled());
        deleteMenu.setEnabled(NavigatorTree.deleteAction.isEnabled());
        saveMenu.setEnabled(NavigatorTree.saveAction.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode node = this.myOwner.getSelectedNode();
        if (node instanceof NavigatorNodeInterface) {
            if (actionEvent.getActionCommand().equals(LBL_ENABLE)) {
                if (node instanceof InternalEreNode) {
                    // empty if block
                }
            } else if (!actionEvent.getActionCommand().equals(LBL_DISABLE)) {
                ((NavigatorNodeInterface)((Object)node)).newNode(actionEvent.getActionCommand());
                NavigatorConfigLoader.getInstance().saveNodeConfiguration(GuiServiceCenter.getInstance().getNavigatorRootNode());
            }
        }
    }
}

