/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes.task;

import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorInternalFrame;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.FrameOpener;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.w3c.dom.Element;

public class OpenServiceTask
implements Runnable {
    final JDesktopPane desk = GuiServiceCenter.getInstance().getDesktopPane();
    private ServiceProxy myServiceProxy = null;
    private ProgressDialog myDialog;

    public OpenServiceTask(ServiceProxy proxy) {
        this.myServiceProxy = proxy;
    }

    public void openService() {
        if (!this.isServiceAlreadyOpen()) {
            this.myDialog = new ProgressDialog("Open Service " + this.myServiceProxy.getName(), "Open Service " + this.myServiceProxy.getName());
            Thread t = new Thread(this);
            t.start();
            this.myDialog.setVisible(true);
        }
    }

    @Override
    public void run() {
        try {
            ProgressIndicator indicator = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myDialog, 100);
            ProgressIndicator[] progress = indicator.splitProgress(2);
            progress[0].progressStart();
            progress[0].setInfo("Fetching the service definition from the server...");
            Element serviceXML = this.myServiceProxy.getServiceDefinition();
            progress[0].progressFinished();
            progress[1].progressStart();
            progress[1].setInfo("Opening the Service Editor...");
            this.openServiceEditor(serviceXML);
            progress[1].progressFinished();
            this.myDialog.dispose();
        }
        catch (Exception e) {
            this.myDialog.dispose();
            ExceptionUtil.handleException(e, "service", 1, "Failed to open the Service Editor.", true);
        }
    }

    private boolean isServiceAlreadyOpen() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        for (int ii = 0; ii < frames.length; ++ii) {
            if (!(frames[ii] instanceof ServiceEditorInternalFrame) || !((ServiceEditorInternalFrame)frames[ii]).compareServiceAndEreConnector(this.myServiceProxy)) continue;
            JInternalFrame frame = frames[ii];
            new FrameOpener(frame).activate();
            return true;
        }
        return false;
    }

    private void openServiceEditor(Element serviceDefinition) throws Exception {
        ServiceEditorInternalFrame frame = ServiceEditorInternalFrame.createSafely(this.myServiceProxy, serviceDefinition);
        new FrameOpener(frame).open();
    }
}

