/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes.task;

import com.ericsson.ere.exception.UncheckedInterruptedException;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.gui.util.FrameOpener;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.management.Service;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InterruptedIOException;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public class OpenRatingPeriodTask
implements Runnable {
    private RatingPeriodProxy myRatingPeriodProxy = null;
    private ProgressDialog myDialog;
    private volatile boolean myIsCancelled = false;
    private volatile ProgressIndicator[] myProgresses;
    private TreePath myNodePath;
    private Thread myOpenThread;

    public OpenRatingPeriodTask(TreePath nodePath, RatingPeriodProxy proxy) {
        this.myNodePath = nodePath;
        this.myRatingPeriodProxy = proxy;
        String msg = "Open Rating Period " + this.myRatingPeriodProxy.getName();
        this.myDialog = new ProgressDialog(msg, msg);
        this.myDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenRatingPeriodTask.this.myIsCancelled = true;
                OpenRatingPeriodTask.this.myOpenThread.interrupt();
                OpenRatingPeriodTask.this.myProgresses[0].setInfo("Cancelled...");
                OpenRatingPeriodTask.this.myProgresses[1].setInfo("Cancelled...");
                OpenRatingPeriodTask.this.myProgresses[2].setInfo("Cancelled...");
            }
        });
    }

    public void openRatingPeriod() {
        this.myOpenThread = new Thread(this);
        this.myOpenThread.start();
        this.myDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block6: {
            Service service;
            String periodName;
            block5: {
                periodName = this.myRatingPeriodProxy.getName();
                ProgressIndicator indicator = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myDialog, 100);
                this.myProgresses = indicator.splitProgress(3);
                service = this.retrieveService(this.myProgresses[0]);
                if (!this.myIsCancelled) break block5;
                EDT.runLater(new Runnable(){

                    @Override
                    public void run() {
                        OpenRatingPeriodTask.this.myDialog.dispose();
                    }
                });
                return;
            }
            try {
                Element ratingRuleTreeElement = this.retrieveTree(this.myProgresses[1]);
                if (this.myIsCancelled) break block6;
                this.openRatingPeriodEditor(service, ratingRuleTreeElement, this.myProgresses[2]);
            }
            catch (Exception e) {
                block7: {
                    try {
                        if (this.isInterruption(e)) break block7;
                        ExceptionUtil.handleException(e, "ratingRuleFrame", 1, "Failed to start Selection Tree Editor for " + periodName, true);
                    }
                    catch (Throwable throwable) {
                        EDT.runLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                EDT.runLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        EDT.runLater(new /* invalid duplicate definition of identical inner class */);
    }

    private Service retrieveService(ProgressIndicator progress) throws Exception {
        progress.setInfo("Retrieving service " + this.myRatingPeriodProxy.getServiceName() + " from the server...");
        progress.progressStart();
        ServiceProxy serviceProxy = this.myRatingPeriodProxy.getRatingManagerProxy().getServiceListProxy().getServiceProxy(this.myRatingPeriodProxy.getServiceName());
        Service service = serviceProxy.instantiateServiceObject();
        progress.progressFinished();
        return service;
    }

    private Element retrieveTree(ProgressIndicator progress) throws EreCommunicationException {
        progress.setInfo("Retrieving the Selection Tree for " + this.myRatingPeriodProxy.getName() + " from the server...");
        progress.progressStart();
        Element ratingRuleTreeElement = this.myRatingPeriodProxy.getRatingPeriodRuleTree();
        progress.progressFinished();
        return ratingRuleTreeElement;
    }

    private boolean isInterruption(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof InterruptedException || t instanceof InterruptedIOException || t instanceof UncheckedInterruptedException) {
            return true;
        }
        return this.isInterruption(t.getCause());
    }

    private void openRatingPeriodEditor(Service service, Element ratingRuleTreeElement, ProgressIndicator progress) throws Exception {
        RatingRuleFrame frame = RatingRuleFrame.createSafelyForProxy(this.myRatingPeriodProxy, this.myNodePath, service, ratingRuleTreeElement, progress);
        this.configureFrameCleanup(frame);
        new FrameOpener(frame).open();
    }

    private void configureFrameCleanup(final RatingRuleFrame frame) {
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                ClassRepository classRep = frame.getRatingRuleTree().getClassRepository();
                if (classRep != null) {
                    classRep.setTreeRootObject(null);
                }
            }
        });
    }
}

