/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes;

import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.DeletableNode;
import com.ericsson.ere.gui.navigator.nodes.InternalEreNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.integration.connector.CanceledEreLoginException;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.http.NavigatorMenuBuilder;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class EreNode
extends AbstractNavigatorNode
implements EditablePropertiesInterface,
NavigatorNodeInterface,
Comparable<AbstractNavigatorNode>,
DeletableNode {
    private static final long serialVersionUID = -6645564761635100856L;
    static final String ICON_IMAGE_AVAILABLE = "navigator_ere_remote.png";
    static final String ICON_IMAGE_UNAVAILABLE = "navigator_ere_remote_stopped.png";
    static final String ICON_IMAGE_UNKNOWN = "NodeStatusUnknown.gif";
    static final String PAR_NAME = "Name";
    public static final String ATTR_TYPE = "type";
    static final Color CONNECTION_FAILED = Color.GRAY;
    private String myName = "EreNode";
    private EreProxy myEreProxy = null;
    String myType = null;
    boolean removeAtCancel = false;

    public EreNode(EreProxy someEreProxy) {
        this.myEreProxy = someEreProxy;
    }

    @Override
    public String toString() {
        return this.myEreProxy.getName() + " (" + this.myEreProxy.getType() + ")";
    }

    @Override
    public EditablePropertiesInterface getPropertyOwner() {
        return this;
    }

    public void removeAtCancel() {
        this.removeAtCancel = true;
    }

    @Override
    public void cancel() {
        if (this.removeAtCancel) {
            ((DefaultMutableTreeNode)this.getParent()).remove(this);
        }
    }

    @Override
    public String getTitle() {
        return this.toString();
    }

    @Override
    public void performNodeAction() {
        EreNode.connectToERE(this.myEreProxy);
        this.myOwner.expandRatingPeriodNode(this);
        NavigatorMenuBuilder navMenuBuilder = this.myEreProxy.getNavigatorMenuBuilderForNavigatorTree(this.myOwner);
        navMenuBuilder.registerCustomPopupMenus(this.myOwner);
    }

    public static void connectToERE(final EreProxy ereProxy) {
        ProgressDialog dialog = new ProgressDialog("Fetching Rating Manager", "Fetching Rating Manager");
        ereProxy.clearAbortRefresh();
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ereProxy.abortRefresh();
            }
        });
        Thread work = new Thread(new ConnectWorker(ereProxy, dialog));
        work.start();
        dialog.setVisible(true);
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        switch (EreNode.getNodeState(this.myEreProxy)) {
            case 0: {
                return RmaDefs.getImageIcon(ICON_IMAGE_UNKNOWN);
            }
            case 2: {
                return RmaDefs.getImageIcon(ICON_IMAGE_UNAVAILABLE);
            }
        }
        return RmaDefs.getImageIcon(ICON_IMAGE_AVAILABLE);
    }

    @Override
    public Color getNodeColor() {
        if (EreNode.getNodeState(this.myEreProxy) == 2) {
            return CONNECTION_FAILED;
        }
        return null;
    }

    @Override
    public String getNodeToolTip() {
        String myTooltip = "Node status: unknown";
        switch (this.myEreProxy.getConnectionState()) {
            case 4: {
                myTooltip = "Node status: connected";
                break;
            }
            case 1: {
                myTooltip = "Node status: disabled";
            }
        }
        return myTooltip;
    }

    @Override
    public int compareTo(AbstractNavigatorNode o) {
        if (o instanceof InternalEreNode) {
            return 1;
        }
        if (o instanceof EreNode) {
            EreNode c = (EreNode)o;
            int compare = this.myType.compareTo(c.myType);
            if (compare == 0) {
                compare = this.myName.compareTo(c.myName);
            }
            return compare;
        }
        throw new ClassCastException("Compare failed. " + o.getClass() + " is not an EreNode instance");
    }

    public boolean isConnected() {
        return EreNode.getNodeState(this.myEreProxy) == 4;
    }

    public static int getNodeState(EreProxy ereProxy) {
        return ereProxy.getConnectionState();
    }

    @Override
    public void setNavigatorTree(NavigatorTree owner) {
    }

    public EreProxy getEreProxy() {
        return this.myEreProxy;
    }

    @Override
    public boolean isMenuOn() {
        return true;
    }

    @Override
    public AbstractEreProxy getProxy() {
        return this.myEreProxy;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    private static class ConnectWorker
    implements Runnable {
        private EreProxy myProxy;
        private ProgressDialog myDialog;

        private ConnectWorker(EreProxy proxy, ProgressDialog dialog) {
            this.myProxy = proxy;
            this.myDialog = dialog;
        }

        @Override
        public void run() {
            ProgressIndicator indicator;
            block4: {
                indicator = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myDialog);
                indicator.setInfo("Removing old");
                indicator.progressStart();
                EreProxyManager.getInstance().setProgressIndicator(indicator);
                if (EreNode.getNodeState(this.myProxy) == 1) {
                    this.myDialog.dispose();
                    return;
                }
                try {
                    indicator.progressIncrement();
                    indicator.setInfo("Refreshing Rating Manager");
                    this.myProxy.refreshRatingManagerDocument();
                    indicator.progressIncrement();
                    indicator.setInfo("Building Proxy Structure");
                    this.myProxy.getRatingManagerProxy();
                }
                catch (CanceledEreLoginException canceledEreLoginException) {
                }
                catch (EreCommunicationException e) {
                    if (e.getCause() instanceof CanceledEreLoginException) break block4;
                    ExceptionUtil.handleException(e, "ereProxyStructure", 1, "Could not connect to the remote ERE", true);
                }
            }
            indicator.progressFinished();
            this.myDialog.dispose();
        }
    }
}

