/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport.states;

import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.gui.navigator.nodeimport.ImportWizardModel;
import com.ericsson.ere.gui.navigator.nodeimport.panels.RatingManagerImportFilePanel;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.migration.MigrationContext;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingWorker;
import org.w3c.dom.Document;

public class ImportWizardFileState
extends AbstractWizardState
implements Observer {
    private RatingManagerImportFilePanel myPanel;
    private boolean hasNotBeenActivated = true;

    public ImportWizardFileState(ImportWizardModel model) {
        super(model);
        this.createPanel();
        this.myPanel.addObserver(this);
    }

    private void createPanel() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardFileState.this.myPanel = new RatingManagerImportFilePanel();
            }
        });
    }

    @Override
    public void activate() {
        File selectedFile = this.getMyImportWizardModel().getSelectedSourceFile();
        if (selectedFile == null) {
            this.myModel.setStandardStartNavigationButtonMode();
        } else if (this.hasNotBeenActivated) {
            this.setFileNameInPanel(selectedFile);
            this.myModel.setStandardStartNavigationButtonMode();
            this.doImport();
        } else {
            this.setBackAndNextEnabled(false, true);
        }
        this.hasNotBeenActivated = false;
    }

    private void doImport() {
        this.showProgressAsIndeterminate();
        this.setMessageInPanel("Examining file");
        SwingWorker<Void, Void> importWorker = new SwingWorker<Void, Void>(){
            boolean success = false;

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    Document doc = XMLUtil.buildDocumentFromFile(((ImportWizardModel)ImportWizardFileState.this.myModel).getSelectedSourceFile());
                    boolean fileValid = ImportWizardFileState.this.getMyImportWizardModel().isSelectedSourceFileValid();
                    if (!fileValid) {
                        if (ImportUtil.containOneServiceElement(doc) || ImportUtil.containsFloatingServiceElement(doc)) {
                            ImportWizardFileState.this.getMyImportWizardModel().setNeedsMigration(false);
                            MigrationContext ctx = ImportUtil.createContextForServiceDefinitionImport(doc);
                            ImportWizardFileState.this.getMyImportWizardModel().migrateSelectedSourceFile(ctx);
                            Document migratedDoc = XMLUtil.buildDocumentFromFile(((ImportWizardModel)ImportWizardFileState.this.myModel).getMigratedFile());
                            ImportWizardFileState.this.getMyImportWizardModel().setRootElement(migratedDoc.getDocumentElement());
                            ImportWizardFileState.this.setMessageInPanel("Valid file");
                            this.success = true;
                        } else if (!ImportUtil.hasValidRootTag(doc)) {
                            ImportWizardFileState.this.setMessageInPanel("Invalid file format, only files exported from RMA are supported.");
                        } else {
                            ImportWizardFileState.this.setMessageInPanel("Incomplete file, migration is needed. Click next to proceed.");
                            ImportWizardFileState.this.getMyImportWizardModel().setNeedsMigration(true);
                            this.success = true;
                        }
                    } else {
                        ImportWizardFileState.this.getMyImportWizardModel().setNeedsMigration(false);
                        ImportWizardFileState.this.getMyImportWizardModel().setRootElement(doc.getDocumentElement());
                        ImportWizardFileState.this.setMessageInPanel("Valid file");
                        this.success = true;
                    }
                }
                catch (FileNotFoundException fnfEx) {
                    ExceptionUtil.handleException(fnfEx, "navigator", 2, "Failed to import file. Could not find specified file.", false);
                    ImportWizardFileState.this.setMessageInPanel("Could not find specified file, see log for more information.");
                }
                catch (IOException ioEx) {
                    ExceptionUtil.handleException(ioEx, "navigator", 2, "An I/O exception occured while reading file", false);
                    ImportWizardFileState.this.setMessageInPanel("Failed to build document from XML file (incorrect encoding?), see log for more information.");
                }
                catch (Exception ex) {
                    ExceptionUtil.handleException(ex, "navigator", 2, "Import file is invalid", false);
                    ImportWizardFileState.this.setMessageInPanel("Failed to build document from XML file, see log for more information.");
                }
                ImportWizardFileState.this.setProgressToFinished();
                return null;
            }

            @Override
            protected void done() {
                ImportWizardFileState.this.myModel.setNextEnabled(this.success);
            }
        };
        importWorker.execute();
    }

    private ImportWizardModel getMyImportWizardModel() {
        return (ImportWizardModel)this.myModel;
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }

    @Override
    public void selectPreviousState() {
        if (this.myPreviousState != null) {
            this.myModel.setCurrentState(this.myPreviousState);
            ((ImportWizardModel)this.myModel).setSelectedSourceFile(null);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        File selectedSourceFile = (File)arg;
        ((ImportWizardModel)this.myModel).setSelectedSourceFile(selectedSourceFile);
        if (selectedSourceFile != null) {
            this.doImport();
        } else {
            this.clearFileSelection();
        }
    }

    private void clearFileSelection() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardFileState.this.myModel.setNextEnabled(false);
                ImportWizardFileState.this.myPanel.setMessage("No file selected");
                ImportWizardFileState.this.myPanel.hideProgressBar();
            }
        });
    }

    private void setMessageInPanel(final String message) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardFileState.this.myPanel.setMessage(message);
            }
        });
    }

    private void setFileNameInPanel(final File file) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardFileState.this.myPanel.setFileName(file);
            }
        });
    }

    private void showProgressAsIndeterminate() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardFileState.this.myPanel.showProgressPanelIndeterminate();
            }
        });
    }

    private void setProgressToFinished() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardFileState.this.myPanel.setProgressToFinished(100);
            }
        });
    }
}

