/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport.panels;

import com.ericsson.ere.gui.navigator.nodeimport.ElementTreeNode;
import com.ericsson.ere.gui.navigator.nodeimport.ImportTreeRenderer;
import com.ericsson.ere.gui.navigator.nodeimport.ImportWizardModel;
import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableNodeWrapper;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableTreeModel;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.xml.ElementIterator;
import ericsson.ere.xml.XMLUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImportNodesPanel
extends AbstractWizardPanel
implements WizardStateView {
    private JScrollPane myJScrollPane = null;
    private JTree myJTree = null;
    private SelectableTreeModel myImportTreeModel;
    private JButton mySelectAllButton = null;
    private JButton mySelectNoneButton = null;
    private ImportWizardModel myModel;

    public ImportNodesPanel(ImportWizardModel model) {
        this.myModel = model;
        this.initialize();
    }

    public void initiateTreeModel() {
        ElementTreeNode wrappedRoot = this.wrapImportableElements(this.myModel.getRootElement());
        SelectableNodeWrapper selectableRoot = SelectableTreeModel.wrapTree(wrappedRoot);
        this.myImportTreeModel = new SelectableTreeModel(selectableRoot);
        if (this.myModel.isSelectAllTreeNodes()) {
            this.myImportTreeModel.markAllForExport(true);
        }
        this.myJTree.setModel(this.myImportTreeModel);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 16;
        gridBagConstraints2.insets = new Insets(11, 4, 0, 0);
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(17, 11, 0, 0);
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(6, 11, 11, 11);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(418, 353));
        this.add((Component)this.createJScrollPane(), gridBagConstraints);
        this.add((Component)this.createSelectAllButton(), gridBagConstraints1);
        this.add((Component)this.createSelectNoneButton(), gridBagConstraints2);
        this.setName("WizardDialog.ImportNodesPanel");
    }

    @Override
    public String getPanelIdentifier() {
        return "ImportNodeSelection";
    }

    @Override
    public String getPanelDescription() {
        return "Select the elements that you want to import.";
    }

    @Override
    public void wizardCanceled() {
    }

    public boolean hasImportableSelection() {
        boolean result = false;
        if (this.myImportTreeModel != null) {
            result = this.myImportTreeModel.hasExportableSelection();
        }
        return result;
    }

    public Vector<DefaultMutableTreeNode> getAllNodesToImport() {
        return this.myImportTreeModel.getAllMarkedForExport();
    }

    private JScrollPane createJScrollPane() {
        this.myJScrollPane = new JScrollPane();
        this.myJScrollPane.setViewportView(this.createJTree());
        return this.myJScrollPane;
    }

    private JTree createJTree() {
        this.myJTree = new JTree(){

            @Override
            protected void setExpandedState(TreePath path, boolean state) {
                if (ImportNodesPanel.this.myJTree.getRowForPath(path) != 0) {
                    super.setExpandedState(path, state);
                }
            }
        };
        this.myJTree.setName("WizardDialog.ImportNodesPanel.jTree");
        this.myJTree.setCellRenderer(new ImportTreeRenderer());
        this.myJTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = ImportNodesPanel.this.myJTree.getRowForLocation(e.getX(), e.getY());
                Object comp = ImportNodesPanel.this.myJTree.getLastSelectedPathComponent();
                if (row != -1 && comp instanceof SelectableNodeWrapper) {
                    ((SelectableNodeWrapper)comp).toggleMarkedForExport();
                    ImportNodesPanel.this.myJTree.repaint();
                    ImportNodesPanel.this.triggerObservers();
                }
            }
        });
        this.myJTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                if (k.getKeyCode() != 32) {
                    return;
                }
                Object comp = ImportNodesPanel.this.myJTree.getLastSelectedPathComponent();
                if (comp instanceof SelectableNodeWrapper) {
                    ((SelectableNodeWrapper)comp).toggleMarkedForExport();
                    ImportNodesPanel.this.myJTree.repaint();
                    ImportNodesPanel.this.triggerObservers();
                }
            }
        });
        return this.myJTree;
    }

    private ElementTreeNode wrapImportableElements(Element rootNode) {
        ElementTreeNode tRoot = new ElementTreeNode(rootNode);
        tRoot.elementLabel = XMLUtil.getAttributeFromElement(rootNode, "Name", rootNode.getNodeName());
        tRoot.elementType = rootNode.getNodeName();
        ElementIterator nodes = new ElementIterator(rootNode.getChildNodes());
        for (Node nextNode : nodes) {
            String nodeName;
            if (!(nextNode instanceof Element) || !(nodeName = nextNode.getNodeName()).equals("EreExport") && !nodeName.equals("ServiceProviderList") && !nodeName.equals("ServiceProvider") && !nodeName.equals("RatingPlan") && !nodeName.equals("RatingPeriod") && !nodeName.equals("ServiceList") && !nodeName.equals("Service")) continue;
            tRoot.add(this.wrapImportableElements((Element)nextNode));
        }
        return tRoot;
    }

    private JButton createSelectAllButton() {
        this.mySelectAllButton = new JButton();
        this.mySelectAllButton.setToolTipText("Select all");
        this.mySelectAllButton.setPreferredSize(new Dimension(20, 20));
        this.mySelectAllButton.setMinimumSize(new Dimension(20, 20));
        this.mySelectAllButton.setIcon(RmaDefs.getImageIcon("MultiSelect16.gif"));
        this.mySelectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportNodesPanel.this.myImportTreeModel.markAllForExport(true);
                ImportNodesPanel.this.myJTree.repaint();
                ImportNodesPanel.this.triggerObservers();
            }
        });
        return this.mySelectAllButton;
    }

    private JButton createSelectNoneButton() {
        this.mySelectNoneButton = new JButton();
        this.mySelectNoneButton.setToolTipText("Clear all");
        this.mySelectNoneButton.setPreferredSize(new Dimension(20, 20));
        this.mySelectNoneButton.setMinimumSize(new Dimension(20, 20));
        this.mySelectNoneButton.setIcon(RmaDefs.getImageIcon("MultiDeSelect16.gif"));
        this.mySelectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportNodesPanel.this.myImportTreeModel.markAllForExport(false);
                ImportNodesPanel.this.myJTree.repaint();
                ImportNodesPanel.this.triggerObservers();
            }
        });
        return this.mySelectNoneButton;
    }
}

