/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeexport.panels;

import com.ericsson.ere.gui.navigator.NavigatorFileChooser;
import com.ericsson.ere.gui.navigator.nodeexport.ExportWizardModel;
import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ExportFilePanel
extends AbstractWizardPanel
implements WizardStateView {
    private ExportWizardModel myModel;
    private JTextField myFileNameField = null;
    private JButton mySelectFileButton = null;
    private JLabel mySelectFileLabel = null;

    public ExportFilePanel(ExportWizardModel model) {
        this.myModel = model;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 16;
        gridBagConstraints2.insets = new Insets(17, 11, 0, 0);
        gridBagConstraints2.gridy = 0;
        this.mySelectFileLabel = new JLabel();
        this.mySelectFileLabel.setText("Export destination:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(6, 3, 10, 12);
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 11;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridx = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 11, 5, 2);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(443, 268));
        this.add((Component)this.createFileNameField(), gridBagConstraints);
        this.add((Component)this.createSelectFileButton(), gridBagConstraints1);
        this.add((Component)this.mySelectFileLabel, gridBagConstraints2);
    }

    private JTextField createFileNameField() {
        if (this.myFileNameField == null) {
            this.myFileNameField = new JTextField();
            this.myFileNameField.setPreferredSize(new Dimension(4, 27));
            this.myFileNameField.setEnabled(false);
        }
        return this.myFileNameField;
    }

    private JButton createSelectFileButton() {
        this.mySelectFileButton = new JButton();
        this.mySelectFileButton.setName("ExportFilePanel.JButton.Browse");
        this.mySelectFileButton.setText("Browse");
        this.mySelectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File aFile = NavigatorFileChooser.getExportFile("Export to file");
                if (aFile != null) {
                    ExportFilePanel.this.myFileNameField.setText(aFile.getAbsolutePath());
                } else {
                    ExportFilePanel.this.myFileNameField.setText("");
                }
                ExportFilePanel.this.triggerObservers(aFile);
            }
        });
        return this.mySelectFileButton;
    }

    @Override
    public String getPanelDescription() {
        return "Select the file that the export should be written to.";
    }

    @Override
    public String getPanelIdentifier() {
        return "FilePanel";
    }

    @Override
    public void wizardCanceled() {
    }
}

