/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.model;

import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.model.event.NavigatorModelStructureEvent;
import com.ericsson.ere.gui.navigator.model.event.NavigatorModelStructureListener;
import com.ericsson.ere.gui.navigator.model.filter.NavigatorFilter;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.EreNode;
import com.ericsson.ere.gui.navigator.nodes.InternalEreNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.navigator.nodes.RatingPlanNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceListNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceProviderListNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceProviderNode;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.InternalEreProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.event.ProxyManagementEvent;
import com.ericsson.ere.proxy.event.ProxyManagementListener;
import com.ericsson.ere.proxy.event.ProxyPropertyEvent;
import com.ericsson.ere.proxy.event.ProxyPropertyListener;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import com.ericsson.ere.proxy.event.ProxyStructureListener;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.RmaDefsPropertiesChangeEvent;
import ericsson.ere.defs.RmaDefsPropertiesChangeListener;
import ericsson.ere.integration.connector.http.NavigatorTreeBuilder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NavigatorTreeModel
extends DefaultTreeModel
implements ProxyStructureListener,
ProxyPropertyListener,
RmaDefsPropertiesChangeListener {
    private EventListenerList myModelListenerList = new EventListenerList();
    private NavigatorNode myMasterRootNode = null;
    private EreProxyManager myEreProxyManager = null;
    private Vector<NavigatorFilter> myFilterList = new Vector();
    private boolean myClearFilteredNodes = false;
    private boolean myIsRebuilding = false;

    public NavigatorTreeModel() {
        super(new NavigatorNode());
        this.myMasterRootNode = (NavigatorNode)this.getRoot();
    }

    public void setProxyManager(EreProxyManager ereProxyManager) {
        this.myEreProxyManager = ereProxyManager;
        ereProxyManager.addProxyManagementListener(new ProxyManagementHandler());
        this.listenTo(Arrays.asList(ereProxyManager.getInternalEreProxy()));
        this.listenTo(ereProxyManager.getRemoteEreList());
        this.rebuildTree();
    }

    void listenTo(List<? extends EreProxy> proxies) {
        for (EreProxy ereProxy : proxies) {
            if (ereProxy == null) continue;
            ereProxy.addProxyPropertyEventListener(this);
            ereProxy.addProxyStructureEventListener(this);
        }
    }

    private void rebuildTree() {
        this.myIsRebuilding = true;
        try {
            this.fireModelStructureWillChangeEvent(new NavigatorModelStructureEvent(this.myMasterRootNode));
            this.myMasterRootNode.removeAllChildren();
            this.createAndAddInternalEreNode(this.myEreProxyManager.getInternalEreProxy());
            this.createAndAddEreNodes(this.myEreProxyManager.getRemoteEreList());
            this.reload();
            this.fireModelStructureHasChangedEvent(new NavigatorModelStructureEvent(this.myMasterRootNode));
        }
        finally {
            this.myIsRebuilding = false;
        }
    }

    private void createAndAddInternalEreNode(InternalEreProxy proxy) {
        if (proxy == null) {
            return;
        }
        NavigatorTreeBuilder builder = proxy.getNavigatorTreeBuilder();
        InternalEreNode newEreNode = new InternalEreNode(proxy);
        if (proxy.isConnected()) {
            newEreNode.add(builder.build(proxy.getRatingManagerProxy()));
        }
        this.myMasterRootNode.add(newEreNode);
    }

    private void createAndAddEreNodes(List<? extends EreProxy> proxies) {
        for (EreProxy ereProxy : proxies) {
            NavigatorTreeBuilder builder = ereProxy.getNavigatorTreeBuilder();
            EreNode newEreNode = new EreNode(ereProxy);
            if (ereProxy.isConnected()) {
                newEreNode.add(builder.build(ereProxy.getRatingManagerProxy()));
            }
            this.myMasterRootNode.add(newEreNode);
        }
    }

    public void performNodeAction(DefaultMutableTreeNode anyNode) {
        if (anyNode instanceof NavigatorNodeInterface) {
            ((NavigatorNodeInterface)((Object)anyNode)).performNodeAction();
        }
    }

    public AbstractNavigatorNode getNodeForProxy(AbstractEreProxy proxy) {
        return this.recGetNodeForProxy(this.myMasterRootNode, proxy);
    }

    private AbstractNavigatorNode recGetNodeForProxy(AbstractNavigatorNode node, AbstractEreProxy proxy) {
        if (proxy.equals(node.getProxy())) {
            return node;
        }
        AbstractNavigatorNode n = null;
        Enumeration<TreeNode> e = node.children();
        while (n == null && e.hasMoreElements()) {
            n = this.recGetNodeForProxy((AbstractNavigatorNode)e.nextElement(), proxy);
        }
        return n;
    }

    private DefaultMutableTreeNode getTreeNodeForPath(TreePath path) {
        NavigatorNode result = null;
        DefaultMutableTreeNode workNode = this.myMasterRootNode;
        int i = 0;
        for (i = 0; i < path.getPathCount(); ++i) {
            String lookingFor = path.getPathComponent(i).toString();
            Enumeration<TreeNode> e = workNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)e.nextElement();
                if (!tNode.toString().equals(lookingFor)) continue;
                workNode = tNode;
            }
        }
        if (i == path.getPathCount()) {
            result = workNode;
        }
        return result;
    }

    @Deprecated
    public void addProxyStructureEventListener(ProxyStructureListener listener) {
        if (this.myEreProxyManager.getInternalEreProxy() != null) {
            this.myEreProxyManager.getInternalEreProxy().addProxyStructureEventListener(listener);
        }
        for (EreProxy ereProxy : this.myEreProxyManager.getRemoteEreList()) {
            ereProxy.addProxyStructureEventListener(listener);
        }
    }

    @Deprecated
    public void addProxyPropertyChangedListener(ProxyPropertyListener listener) {
        if (this.myEreProxyManager == null) {
            return;
        }
        if (this.myEreProxyManager.getInternalEreProxy() != null) {
            this.myEreProxyManager.getInternalEreProxy().addProxyPropertyEventListener(listener);
        }
        for (EreProxy ereProxy : this.myEreProxyManager.getRemoteEreList()) {
            ereProxy.addProxyPropertyEventListener(listener);
        }
    }

    @Override
    public void proxyStructureChanged(final ProxyStructureEvent e) {
        if (this.myIsRebuilding) {
            return;
        }
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                NavigatorTreeModel.this.handleProxyStructureChange(e);
            }
        });
    }

    void handleProxyStructureChange(ProxyStructureEvent e) {
        AbstractNavigatorNode eventNode = this.getNodeForProxy((AbstractEreProxy)e.getSource());
        this.fireModelStructureWillChangeEvent(new NavigatorModelStructureEvent(eventNode));
        this.rebuildNode(eventNode);
        this.fireModelStructureHasChangedEvent(new NavigatorModelStructureEvent(eventNode));
        this.myClearFilteredNodes = true;
        this.applyFilters();
    }

    private void rebuildNode(AbstractNavigatorNode eventNode) {
        EreProxy sourceProxy;
        eventNode.removeAllChildren();
        AbstractEreProxy proxy = eventNode.getProxy();
        NavigatorTreeBuilder builder = proxy.getNavigatorTreeBuilder();
        if (eventNode instanceof RatingPlanNode) {
            builder.buildRatingPlanStructure((RatingPlanProxy)proxy, (RatingPlanNode)eventNode);
        } else if (eventNode instanceof ServiceProviderNode) {
            builder.buildServiceProviderNode((ServiceProviderProxy)proxy, (ServiceProviderNode)eventNode);
        } else if (eventNode instanceof ServiceProviderListNode) {
            builder.buildServiceProviderListNode((ServiceProviderListProxy)proxy, (ServiceProviderListNode)eventNode);
        } else if (eventNode instanceof ServiceListNode) {
            builder.buildServiceListNode((ServiceListProxy)proxy, (ServiceListNode)eventNode);
        } else if ((eventNode instanceof EreNode || eventNode instanceof InternalEreNode) && (sourceProxy = proxy.getEreProxy()).isConnected()) {
            eventNode.add(builder.build(sourceProxy.getRatingManagerProxy()));
        }
        this.reload(eventNode);
    }

    public void applyFilters() {
        for (NavigatorFilter filter : this.myFilterList) {
            AbstractNavigatorNode node = (AbstractNavigatorNode)this.getTreeNodeForPath(filter.path);
            this.fireModelStructureWillChangeEvent(new NavigatorModelStructureEvent(node));
            this.applyFilterToNode(filter, node);
            this.fireModelStructureHasChangedEvent(new NavigatorModelStructureEvent(node));
        }
    }

    private void applyFilterToNode(NavigatorFilter filter, AbstractNavigatorNode node) {
        if (!this.myClearFilteredNodes) {
            node.showFilteredChildren();
        }
        node.filterChildren(filter);
        this.myClearFilteredNodes = false;
        this.reload(node);
    }

    @Override
    public void proxyPropertyChanged(ProxyPropertyEvent e) {
        AbstractEreProxy aProxy = (AbstractEreProxy)e.getSource();
        AbstractNavigatorNode eventNode = this.getNodeForProxy(aProxy);
        this.reload(eventNode);
    }

    public void addFilter(NavigatorFilter filter) {
        this.myFilterList.add(filter);
        this.applyFilters();
    }

    public void addModelStructureListener(NavigatorModelStructureListener listener) {
        this.myModelListenerList.add(NavigatorModelStructureListener.class, listener);
    }

    public void removeModelStructureListener(NavigatorModelStructureListener listener) {
        this.myModelListenerList.remove(NavigatorModelStructureListener.class, listener);
    }

    private void fireModelStructureWillChangeEvent(NavigatorModelStructureEvent event) {
        Object[] listeners = this.myModelListenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != NavigatorModelStructureListener.class) continue;
            ((NavigatorModelStructureListener)listeners[i + 1]).modelStructureWillChange(event);
        }
    }

    private void fireModelStructureHasChangedEvent(NavigatorModelStructureEvent event) {
        Object[] listeners = this.myModelListenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != NavigatorModelStructureListener.class) continue;
            ((NavigatorModelStructureListener)listeners[i + 1]).modelStructureHasChanged(event);
        }
    }

    public NavigatorFilter getFilterForPath(TreePath selectionPath) {
        for (NavigatorFilter filter : this.myFilterList) {
            if (!filter.path.toString().equals(selectionPath.toString())) continue;
            return filter;
        }
        return null;
    }

    public void removeFilter(NavigatorFilter toRemove) {
        AbstractNavigatorNode node = (AbstractNavigatorNode)this.getTreeNodeForPath(toRemove.path);
        node.showFilteredChildren();
        this.myFilterList.remove(toRemove);
        this.reload(node);
    }

    public void registerTreeOwner(NavigatorTree navigatorTree) {
        this.recRegisterTreeOwner(this.myMasterRootNode, navigatorTree);
    }

    private void recRegisterTreeOwner(AbstractNavigatorNode treeNode, NavigatorTree owner) {
        treeNode.myOwner = owner;
        Enumeration<TreeNode> e = treeNode.children();
        while (e.hasMoreElements()) {
            AbstractNavigatorNode nNode = (AbstractNavigatorNode)e.nextElement();
            this.recRegisterTreeOwner(nNode, owner);
        }
    }

    @Override
    public void propertiesChange(RmaDefsPropertiesChangeEvent changeEvent) {
        this.rebuildTree();
    }

    private class ProxyManagementHandler
    implements ProxyManagementListener {
        private ProxyManagementHandler() {
        }

        @Override
        public void ereProxyAdded(ProxyManagementEvent e) {
            EreProxy ereProxy = (EreProxy)e.getSource();
            if (!(ereProxy instanceof InternalEreProxy)) {
                NavigatorTreeModel.this.listenTo(Arrays.asList(ereProxy));
                NavigatorTreeModel.this.createAndAddEreNodes(Arrays.asList(ereProxy));
                NavigatorTreeModel.this.reload();
            }
        }

        @Override
        public void ereProxyRemoved(ProxyManagementEvent e) {
            EreProxy ereProxy = (EreProxy)e.getSource();
            AbstractNavigatorNode tNode = NavigatorTreeModel.this.getNodeForProxy(ereProxy);
            NavigatorTreeModel.this.myMasterRootNode.remove(tNode);
            NavigatorTreeModel.this.reload();
        }
    }
}

