/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.gui.navigator.distribute.AbstractEREDistributeTask;
import com.ericsson.ere.gui.navigator.distribute.EREDistributorDialog;
import com.ericsson.ere.gui.navigator.nodes.EreNode;
import com.ericsson.ere.proxy.EreProxy;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.gui.util.SwingWorker;
import ericsson.ere.progress.ProgressIndicator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class EREDistributionItem
extends JPanel {
    private EreStatus myEreStatus;
    private AbstractEREDistributeTask myTask;
    private EreProxy myERE;
    private EREDistributorDialog.DistributionMode myMode;
    private static final Color NORMAL_COLOR = new Color(0, 0, 0);
    private static final Color ERROR_COLOR = new Color(139, 24, 12);
    private static final Color WARNING_COLOR = new Color(175, 163, 12);
    private static final Color READY_COLOR = new Color(79, 160, 24);
    private JLabel myNameLabel;
    private JCheckBox mySelectedBox;
    private JLabel myERELabel;
    private JPanel myInfoPanel;
    private Color myBackground;
    private ProgressDialog myProgressDialog;
    private EREDistributorDialog myParent;
    private JLabel myExpandButton;

    public EREDistributionItem(EreProxy ere, AbstractEREDistributeTask task, Color background, EREDistributorDialog.DistributionMode mode, EREDistributorDialog parent) {
        this.myParent = parent;
        this.myBackground = background;
        this.myERE = ere;
        this.myTask = task;
        this.myMode = mode;
        this.init();
        if (mode == EREDistributorDialog.DistributionMode.PERFORM) {
            this.setInfoPanel(this.myTask.getPerformPanel(), this.myTask.getPerformStatus());
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setBackground(this.myBackground);
        this.myNameLabel = new JLabel(this.myERE.toString());
        this.mySelectedBox = new JCheckBox();
        this.mySelectedBox.setBackground(null);
        this.myExpandButton = new JLabel("   ");
        this.myERELabel = new JLabel();
        ToolTipManager.sharedInstance().registerComponent(this.myERELabel);
        if (this.myERE.isConnected()) {
            this.myEreStatus = EreStatus.CONNECTED;
            this.myERELabel.setIcon(RmaDefs.getImageIcon("navigator_ere_local.png"));
            this.myERELabel.setToolTipText("Connected");
        } else {
            this.myEreStatus = EreStatus.DISCONNECTED;
            this.myERELabel.setIcon(RmaDefs.getImageIcon("navigator_ere_local_stopped.png"));
            this.myERELabel.setToolTipText("Disconnected");
        }
        this.mySelectedBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!EREDistributionItem.this.mySelectedBox.isSelected()) {
                    EREDistributionItem.this.myProgressDialog = new ProgressDialog("ERE Distribution dialog", "Selecting " + EREDistributionItem.this.myERE);
                    final ProgressIndicator progress = EREDistributionItem.this.myProgressDialog.getProgressIndicator(100);
                    new SwingWorker(){

                        @Override
                        public Object construct() {
                            EREDistributionItem.this.select(progress);
                            return null;
                        }

                        @Override
                        public void finished() {
                            EREDistributionItem.this.myProgressDialog.dispose();
                        }
                    }.start();
                    EREDistributionItem.this.myProgressDialog.setVisible(true);
                } else {
                    EREDistributionItem.this.myParent.removeSelectedERE(EREDistributionItem.this.getThis());
                }
            }
        });
        MouseAdapter showInfoOnClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (EREDistributionItem.this.myMode == EREDistributorDialog.DistributionMode.ANALYZE && EREDistributionItem.this.myInfoPanel.getComponentCount() == 0) {
                    EREDistributionItem.this.myProgressDialog = new ProgressDialog("ERE Distribution dialog", "Selecting " + EREDistributionItem.this.myERE);
                    final ProgressIndicator progress = EREDistributionItem.this.myProgressDialog.getProgressIndicator(100);
                    new SwingWorker(){

                        @Override
                        public Object construct() {
                            EREDistributionItem.this.select(progress);
                            return null;
                        }

                        @Override
                        public void finished() {
                            EREDistributionItem.this.myProgressDialog.dispose();
                        }
                    }.start();
                    EREDistributionItem.this.myProgressDialog.setVisible(true);
                } else {
                    EREDistributionItem.this.showOrHideInfo();
                }
            }
        };
        this.myNameLabel.addMouseListener(showInfoOnClick);
        this.myERELabel.addMouseListener(showInfoOnClick);
        this.addMouseListener(showInfoOnClick);
        this.myInfoPanel = new JPanel(new GridBagLayout());
        this.myInfoPanel.setVisible(false);
        if (this.myMode == EREDistributorDialog.DistributionMode.ANALYZE) {
            this.add((Component)this.mySelectedBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(2, 0, 2, 10), 0, 0));
        }
        this.add((Component)this.myExpandButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.myERELabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.myNameLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.myInfoPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        MouseAdapter hoverItem = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                EREDistributionItem.this.setBackground(new Color(210, 226, 240));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!EREDistributionItem.this.myInfoPanel.isVisible()) {
                    EREDistributionItem.this.setBackground(EREDistributionItem.this.myBackground);
                }
            }
        };
        this.addMouseListener(hoverItem);
        this.mySelectedBox.addMouseListener(hoverItem);
        this.myERELabel.addMouseListener(hoverItem);
        this.myNameLabel.addMouseListener(hoverItem);
    }

    public void connect() {
        EreNode.connectToERE(this.myERE);
        if (this.myERE.isConnected()) {
            this.myEreStatus = EreStatus.CONNECTED;
            this.myERELabel.setIcon(RmaDefs.getImageIcon("navigator_ere_local.png"));
            this.myERELabel.setToolTipText("Connected");
        } else {
            this.setInfoPanel(AbstractEREDistributeTask.getInformationPanel(null, "Couldn't connect to " + this.myERE + "!"), AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE);
            this.mySelectedBox.setSelected(false);
            this.myParent.removeSelectedERE(this);
            this.myERELabel.setIcon(RmaDefs.getImageIcon("navigator_ere_local_stopped.png"));
            this.myERELabel.setToolTipText("Disconnected");
        }
    }

    public void analyzeTask(ProgressIndicator progress) {
        if (!this.myERE.isConnected()) {
            this.setInfoPanel(AbstractEREDistributeTask.getInformationPanel(null, "Couldn't fetch " + this.myERE + "s manager node!"), AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE);
            this.myERELabel.setIcon(RmaDefs.getImageIcon("navigator_ere_local_stopped.png"));
            this.myERELabel.setToolTipText("Disconnected");
            return;
        }
        this.myTask.analyze(progress);
        if (this.myTask.getAnalyzeStatus() == AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE) {
            this.mySelectedBox.setSelected(false);
            this.myParent.removeSelectedERE(this);
        } else if (this.myTask.getAnalyzeStatus() == AbstractEREDistributeTask.DistributionTaskStatus.WARNING) {
            this.mySelectedBox.setSelected(true);
            this.myParent.addSelectedERE(this);
        } else if (this.myTask.getAnalyzeStatus() == AbstractEREDistributeTask.DistributionTaskStatus.READY) {
            this.mySelectedBox.setSelected(true);
            this.myParent.addSelectedERE(this);
        }
        this.setInfoPanel(this.myTask.getAnalyzePanel(), this.myTask.getAnalyzeStatus());
        this.validate();
    }

    public AbstractEREDistributeTask getTask() {
        return this.myTask;
    }

    public void select(ProgressIndicator progress) {
        ProgressIndicator[] splitProgress = progress.splitProgress(2);
        if (this.myEreStatus == EreStatus.DISCONNECTED) {
            splitProgress[0].progressStart(1);
            splitProgress[0].setInfo("Connecting to " + this.myERE);
            this.connect();
            splitProgress[0].progressFinished();
        }
        if (this.myEreStatus == EreStatus.CONNECTED) {
            splitProgress[1].progressStart(1);
            splitProgress[1].setInfo("Analyzing task feasability at " + this.myERE);
            this.analyzeTask(splitProgress[1]);
            splitProgress[1].progressFinished();
        }
    }

    public void performTask(ProgressIndicator progress) {
        this.myTask.perform(progress);
    }

    public void showInfo() {
        if (this.myInfoPanel.getComponentCount() != 0) {
            this.myExpandButton.setIcon(RmaDefs.getImageIcon("collapse16.gif"));
            this.myInfoPanel.setVisible(true);
            this.setBackground(new Color(210, 226, 240));
            this.setBorder(BorderFactory.createLineBorder(new Color(99, 130, 191), 1));
        }
    }

    public void hideInfo() {
        if (this.myInfoPanel.isVisible()) {
            this.myExpandButton.setIcon(RmaDefs.getImageIcon("expand16.gif"));
            this.myInfoPanel.setVisible(false);
            this.setBorder(null);
            this.setBackground(this.myBackground);
        }
    }

    private void showOrHideInfo() {
        if (this.myInfoPanel.isVisible()) {
            this.hideInfo();
        } else {
            this.showInfo();
        }
    }

    private void setInfoPanel(JPanel info, AbstractEREDistributeTask.DistributionTaskStatus taskStatus) {
        if (taskStatus == AbstractEREDistributeTask.DistributionTaskStatus.NONE) {
            this.myNameLabel.setForeground(NORMAL_COLOR);
        } else if (taskStatus == AbstractEREDistributeTask.DistributionTaskStatus.READY) {
            this.myNameLabel.setForeground(READY_COLOR);
        } else if (taskStatus == AbstractEREDistributeTask.DistributionTaskStatus.WARNING) {
            this.myNameLabel.setForeground(WARNING_COLOR);
        } else if (taskStatus == AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE) {
            this.myNameLabel.setForeground(ERROR_COLOR);
        } else if (taskStatus == AbstractEREDistributeTask.DistributionTaskStatus.SUCCESS) {
            this.myNameLabel.setForeground(READY_COLOR);
        } else if (taskStatus == AbstractEREDistributeTask.DistributionTaskStatus.FAILURE) {
            this.myNameLabel.setForeground(ERROR_COLOR);
        }
        this.myInfoPanel.removeAll();
        JPanel borderPanel = new JPanel(new GridBagLayout());
        borderPanel.setBorder(BorderFactory.createEtchedBorder());
        this.myInfoPanel.add((Component)borderPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        borderPanel.add((Component)info, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.myExpandButton.setText("");
        if (taskStatus == AbstractEREDistributeTask.DistributionTaskStatus.FAILURE) {
            this.showInfo();
        }
        if (this.myInfoPanel.isVisible()) {
            this.myExpandButton.setIcon(RmaDefs.getImageIcon("collapse16.gif"));
            this.myInfoPanel.validate();
        } else {
            this.myExpandButton.setIcon(RmaDefs.getImageIcon("expand16.gif"));
        }
    }

    public boolean isConnected() {
        return this.myEreStatus == EreStatus.CONNECTED;
    }

    public boolean isSelected() {
        return this.mySelectedBox.isSelected();
    }

    public void deselect() {
        this.mySelectedBox.setSelected(false);
        this.myParent.removeSelectedERE(this);
    }

    @Override
    public String toString() {
        return this.myERE.toString();
    }

    private EREDistributionItem getThis() {
        return this;
    }

    private static enum EreStatus {
        DISCONNECTED,
        CONNECTED;

    }
}

