/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.gui.navigator.distribute.AbstractEREDistributeTask;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.proxy.util.ProxyUtil;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.xml.XMLUtil;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class DistributedSaveRatingPeriodTask
extends AbstractEREDistributeTask {
    private JPanel myAnalyzePanel;
    private JPanel myPerformPanel;

    public DistributedSaveRatingPeriodTask(EreProxy ere, AbstractEreProxy source, Element sourceStructure) {
        super(ere, source, sourceStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(ProgressIndicator progress) {
        ProgressIndicator[] theProgress = progress.splitProgress(2);
        RatingPeriodProxy sourceProxy = (RatingPeriodProxy)this.mySource;
        try {
            try {
                theProgress[0].progressStart();
                RatingPlanProxy ratingPlanProxy = this.getPlan(this.myTargetEREProxy, sourceProxy.getServiceProviderName(), sourceProxy.getRatingPlanName());
                if (!this.isDistributionAllowed()) {
                    this.myAnalyzePanel = DistributedSaveRatingPeriodTask.getInformationPanel(this.myTargetEREProxy + " does not allow distribution", "");
                    this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                    return;
                }
                if (!ratingPlanProxy.getServiceName().equals(sourceProxy.getServiceName())) {
                    this.myAnalyzePanel = DistributedSaveRatingPeriodTask.getInformationPanel("A Rating plan named '" + ratingPlanProxy.getName() + "' was found at " + this.myTargetEREProxy + " using a different service than " + sourceProxy.getServiceName(), "");
                    this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                    return;
                }
                this.myAnalyzePanel = DistributedSaveRatingPeriodTask.getInformationPanel(null, "'" + sourceProxy.getName() + "' will be distributed to " + this.myTargetEREProxy);
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
            }
            catch (Exception e) {
                try {
                    this.getService(this.myTargetEREProxy, sourceProxy.getServiceName());
                    this.myAnalyzePanel = DistributedSaveRatingPeriodTask.getInformationPanel(null, "'" + sourceProxy.getName() + "' will be distributed to " + this.myTargetEREProxy);
                    this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
                    return;
                }
                catch (Exception ee) {
                    this.myAnalyzePanel = DistributedSaveRatingPeriodTask.getInformationPanel(null, "'" + sourceProxy.getName() + "' will be distributed with its Service '" + sourceProxy.getServiceName() + "' to " + this.myTargetEREProxy + ".");
                    this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
                    return;
                }
            }
            finally {
                theProgress[0].progressFinished();
            }
            try {
                theProgress[1].progressStart();
                RatingPeriodProxy ratingPeriodProxy = this.getPeriod(this.myTargetEREProxy, sourceProxy.getServiceProviderName(), sourceProxy.getRatingPlanName(), sourceProxy.getName(), sourceProxy.getRatingPeriodStartTime());
                this.myAnalyzePanel = DistributedSaveRatingPeriodTask.getInformationPanel("A Rating period named '" + ratingPeriodProxy.getName() + "' was found at " + this.myTargetEREProxy + ".", "If you go ahead, that period will be overwritten!");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.WARNING;
                return;
            }
            catch (Exception e) {
                this.myAnalyzePanel = DistributedSaveRatingPeriodTask.getInformationPanel(null, "'" + sourceProxy.getName() + "' will be distributed to " + this.myTargetEREProxy);
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
            }
            finally {
                theProgress[1].progressStart();
            }
        }
        catch (Exception e) {
            this.myAnalyzePanel = DistributedSaveRatingPeriodTask.getInformationPanel("'" + sourceProxy.getName() + "' cannot be distributed to " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(ProgressIndicator progress) {
        ProgressIndicator[] theProgress = progress.splitProgress(3);
        RatingPeriodProxy sourceRatingPeriodProxy = (RatingPeriodProxy)this.mySource;
        try {
            block24: {
                try {
                    theProgress[0].progressStart();
                    this.getServiceProvider(this.myTargetEREProxy, sourceRatingPeriodProxy.getServiceProviderName());
                }
                catch (Exception e) {
                    ServiceProviderProxy provider = ProxyUtil.getServiceProviderProxy(sourceRatingPeriodProxy);
                    SettingsMap propertyMap = (SettingsMap)provider.getSettingsMap().clone();
                    this.myTargetEREProxy.getRatingManagerProxy().getServiceProviderListProxy().createServiceProvider(propertyMap);
                }
                finally {
                    theProgress[0].progressFinished();
                }
                try {
                    theProgress[1].progressStart();
                    RatingPlanProxy targetRatingPlanProxy = this.getPlan(this.myTargetEREProxy, sourceRatingPeriodProxy.getServiceProviderName(), sourceRatingPeriodProxy.getRatingPlanName());
                    if (!targetRatingPlanProxy.getServiceName().equals(sourceRatingPeriodProxy.getServiceName())) {
                        this.myPerformPanel = DistributedSaveRatingPeriodTask.getInformationPanel("A Rating plan named '" + targetRatingPlanProxy.getName() + "' was found at " + this.myTargetEREProxy + " using a different service than " + sourceRatingPeriodProxy.getServiceName(), "");
                        this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                        return;
                    }
                }
                catch (Exception e) {
                    boolean createRatingPlan;
                    boolean bl = createRatingPlan = this.myTargetEREProxy.isServiceEditingAllowed() && !this.CONNECTOR_TYPE_CS40.equals(this.myTargetEREProxy.getType());
                    if (!createRatingPlan) break block24;
                    SettingsMap properties = (SettingsMap)sourceRatingPeriodProxy.getParentRatingPlanProxy().getSettingsMap().clone();
                    try {
                        this.getService(this.myTargetEREProxy, sourceRatingPeriodProxy.getServiceName());
                    }
                    catch (Exception ee) {
                        ServiceProxy sourceServiceProxy = ProxyUtil.getServiceProxy(sourceRatingPeriodProxy);
                        SettingsMap sourceSettings = (SettingsMap)sourceServiceProxy.getSettingsMap().clone();
                        Element definitionElement = sourceServiceProxy.getServiceDefinition();
                        Element conditionElement = sourceServiceProxy.getServiceCondition();
                        this.myTargetEREProxy.getRatingManagerProxy().getServiceListProxy().createService(sourceSettings, definitionElement, conditionElement);
                    }
                    this.myTargetEREProxy.getRatingManagerProxy().getServiceProviderListProxy().getServiceProvider(sourceRatingPeriodProxy.getServiceProviderName()).createRatingPlan(properties);
                }
                finally {
                    theProgress[1].progressFinished();
                }
            }
            try {
                theProgress[2].progressStart();
                RatingPeriodProxy targetRatingPeriodProxy = this.getPeriod(this.myTargetEREProxy, sourceRatingPeriodProxy.getServiceProviderName(), sourceRatingPeriodProxy.getRatingPlanName(), sourceRatingPeriodProxy.getName(), sourceRatingPeriodProxy.getRatingPeriodStartTime());
                if (this.mySourceStructure == null) {
                    this.mySourceStructure = sourceRatingPeriodProxy.getRatingPeriodRuleTree();
                }
                if (this.mySourceStructure.getNodeName().equals("RatingPeriod")) {
                    this.mySourceStructure = XMLUtil.getNamedElement("TariffStructure", this.mySourceStructure.getChildNodes());
                }
                targetRatingPeriodProxy.updateRatingPeriodRuleTree(this.mySourceStructure);
                targetRatingPeriodProxy.updateSettingsMap((SettingsMap)sourceRatingPeriodProxy.getSettingsMap().clone());
                this.myPerformPanel = DistributedSaveRatingPeriodTask.getInformationPanel("'" + targetRatingPeriodProxy.getName() + "' was succesfully overwritten at " + this.myTargetEREProxy + ".", "");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.SUCCESS;
            }
            catch (Exception e) {
                if (this.mySourceStructure == null) {
                    this.mySourceStructure = sourceRatingPeriodProxy.getRatingPeriodRuleTree();
                }
                this.createTypeSpecificRatingPlan(sourceRatingPeriodProxy);
                this.myPerformPanel = DistributedSaveRatingPeriodTask.getInformationPanel(null, "'" + sourceRatingPeriodProxy.getName() + "' was succesfully distributed to " + this.myTargetEREProxy);
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
            }
            finally {
                theProgress[2].progressFinished();
            }
        }
        catch (Exception e) {
            this.myPerformPanel = DistributedSaveRatingPeriodTask.getInformationPanel("'" + sourceRatingPeriodProxy.getName() + "' cannot be distributed to " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
        }
    }

    protected void createTypeSpecificRatingPlan(RatingPeriodProxy sourceRatingPeriodProxy) throws Exception, EreCommunicationException {
        RatingPlanProxy targetRatingPlanProxy = this.getPlan(this.myTargetEREProxy, sourceRatingPeriodProxy.getServiceProviderName(), sourceRatingPeriodProxy.getRatingPlanName());
        if (this.mySourceStructure.getNodeName().equals("RatingPeriod")) {
            targetRatingPlanProxy.createRatingPeriod(this.mySourceStructure);
        } else if (this.mySourceStructure.getNodeName().equals("TariffStructure")) {
            targetRatingPlanProxy.createRatingPeriod((SettingsMap)sourceRatingPeriodProxy.getSettingsMap().clone(), this.mySourceStructure);
        }
    }

    @Override
    public JPanel getAnalyzePanel() {
        return this.myAnalyzePanel;
    }

    @Override
    public JPanel getPerformPanel() {
        return this.myPerformPanel;
    }

    public static String getDescription() {
        return "distribute";
    }

    public static boolean performOnAssociatedERE() {
        return false;
    }
}

