/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.gui.navigator.distribute.AbstractEREDistributeTask;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import ericsson.ere.progress.ProgressIndicator;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class DistributedActivateTask
extends AbstractEREDistributeTask {
    private JPanel myAnalyzePanel;
    private JPanel myPerformPanel;

    public DistributedActivateTask(EreProxy ere, AbstractEreProxy source, Element sourceStructure) {
        super(ere, source, sourceStructure);
    }

    @Override
    public void analyze(ProgressIndicator progress) {
        RatingPeriodProxy sourceProxy = (RatingPeriodProxy)this.mySource;
        try {
            if (!this.isDistributionAllowed()) {
                this.myAnalyzePanel = DistributedActivateTask.getInformationPanel(this.myTargetEREProxy + " does not allow distribution", "");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                return;
            }
            RatingPeriodProxy targetProxy = this.getPeriodActiveOrSaved(this.myTargetEREProxy, sourceProxy.getServiceProviderName(), sourceProxy.getRatingPlanName(), sourceProxy.getName(), sourceProxy.getRatingPeriodStartTime());
            if (!targetProxy.hasActiveOrSavedParentProxy()) {
                this.myAnalyzePanel = DistributedActivateTask.getInformationPanel(null, "Activation is not supported by this nodes connector");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                return;
            }
            if (targetProxy.isSelectedActive()) {
                this.myAnalyzePanel = DistributedActivateTask.getInformationPanel(null, "'" + targetProxy.getName() + "' is already activated on " + this.myTargetEREProxy + ".");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
            } else {
                this.myAnalyzePanel = DistributedActivateTask.getInformationPanel(null, "'" + targetProxy.getName() + "' was found on " + this.myTargetEREProxy + " and will be activated.");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
            }
        }
        catch (Exception e) {
            this.myAnalyzePanel = DistributedActivateTask.getInformationPanel("'" + sourceProxy.getName() + "' cannot be activated at " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
        }
    }

    @Override
    public void perform(ProgressIndicator progress) {
        RatingPeriodProxy sourceProxy = (RatingPeriodProxy)this.mySource;
        try {
            RatingPeriodProxy targetProxy = this.getPeriodActiveOrSaved(this.myTargetEREProxy, sourceProxy.getServiceProviderName(), sourceProxy.getRatingPlanName(), sourceProxy.getName(), sourceProxy.getRatingPeriodStartTime());
            if (!targetProxy.hasActiveOrSavedParentProxy()) {
                this.myPerformPanel = DistributedActivateTask.getInformationPanel(null, "Activation is not supported by this nodes connector");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                return;
            }
            if (targetProxy.isSelectedActive()) {
                this.myPerformPanel = DistributedActivateTask.getInformationPanel(null, "'" + targetProxy.getName() + "' is already activated on " + this.myTargetEREProxy + ".");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
            } else {
                targetProxy.activateRatingPeriod();
                this.myPerformPanel = DistributedActivateTask.getInformationPanel("'" + targetProxy.getName() + "' was succesfully activated at " + this.myTargetEREProxy, "");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
            }
        }
        catch (Exception e) {
            this.myPerformPanel = DistributedActivateTask.getInformationPanel("'" + sourceProxy.getName() + "' cannot be activated at " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
        }
    }

    @Override
    public JPanel getAnalyzePanel() {
        return this.myAnalyzePanel;
    }

    @Override
    public JPanel getPerformPanel() {
        return this.myPerformPanel;
    }

    public static String getDescription() {
        return "activate";
    }
}

